/*
 * Decompiled with CFR 0.152.
 */
package Game.particles;

import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.GameController;
import Game.particles.Emitter;
import Game.particles.Particle;
import java.awt.Color;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"LGame/particles/SmokeEmitter;", "LGame/particles/Emitter;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "width", "", "emitSeconds", "", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;ID)V", "makeParticle", "LGame/particles/Particle;", "emitTicksLeft", "Companion", "TankWarsKotlin"})
public final class SmokeEmitter
extends Emitter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Color[] smokeColors;
    @NotNull
    private static final Double[] smokeSizes;

    public SmokeEmitter(@NotNull IGameScene parent, @NotNull Pos2D position, int width, double emitSeconds) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        super(parent, position, width, emitSeconds, 0, 16, null);
        parent.add(this);
    }

    @Override
    @NotNull
    public Particle makeParticle(int emitTicksLeft) {
        double x = Random.Default.nextDouble(this.getPosition().getX() - (double)this.getWidth() / 2.0, this.getPosition().getX() + (double)this.getWidth() / 2.0);
        double xvel = Random.Default.nextDouble(-0.1, 0.1);
        double extraLife = emitTicksLeft % 5 == 0 ? 0.5 : 0.0;
        return new Particle(this.getParent(), new Pos2D(x, this.getPosition().getY()), new Vec2D(xvel, Random.Default.nextDouble(-1.0, -0.5)), new Vec2D(GameController.INSTANCE.getWind() / 120.0, 0.0), Random.Default.nextDouble(1.8, 2.6) + extraLife, smokeColors, smokeSizes);
    }

    static {
        Serializable[] serializableArray = new Color[]{new Color(0, 0, 0, 2), new Color(0, 0, 0, 4), new Color(0, 0, 0, 8), new Color(0, 0, 0, 8), new Color(0, 0, 0, 8), new Color(0, 0, 0, 8), new Color(0, 0, 0, 4), new Color(0, 0, 0, 2)};
        smokeColors = serializableArray;
        serializableArray = new Double[]{14.0, 10.0, 8.0, 6.0, 4.0, 2.0, 1.0};
        smokeSizes = serializableArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"LGame/particles/SmokeEmitter$Companion;", "", "<init>", "()V", "smokeColors", "", "Ljava/awt/Color;", "getSmokeColors", "()[Ljava/awt/Color;", "[Ljava/awt/Color;", "smokeSizes", "", "getSmokeSizes", "()[Ljava/lang/Double;", "[Ljava/lang/Double;", "TankWarsKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color[] getSmokeColors() {
            return smokeColors;
        }

        @NotNull
        public final Double[] getSmokeSizes() {
            return smokeSizes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

