/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.GameObject2;
import Engine.GameSceneKt;
import Engine.IGameScene;
import Engine.Pos2D;
import Game.GameController;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Weapon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0017"}, d2={"LGame/TerrainScene/WeaponBar;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;)V", "stroke", "Ljava/awt/BasicStroke;", "getStroke", "()Ljava/awt/BasicStroke;", "purple", "Ljava/awt/Color;", "getPurple", "()Ljava/awt/Color;", "darkPurple", "getDarkPurple", "update", "", "draw", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
public final class WeaponBar
extends GameObject2 {
    @NotNull
    private final BasicStroke stroke;
    @NotNull
    private final Color purple;
    @NotNull
    private final Color darkPurple;

    public WeaponBar(@NotNull IGameScene parent, @NotNull Pos2D position) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        super(parent, position);
        this.stroke = new BasicStroke(3.0f, 0, 1);
        this.purple = new Color(30, 30, 80);
        this.darkPurple = new Color(20, 20, 40);
        this.setDrawOrder(100);
    }

    @NotNull
    public final BasicStroke getStroke() {
        return this.stroke;
    }

    @NotNull
    public final Color getPurple() {
        return this.purple;
    }

    @NotNull
    public final Color getDarkPurple() {
        return this.darkPurple;
    }

    @Override
    public void update() {
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        GameSceneKt.drawAsHud(g, arg_0 -> WeaponBar.draw$lambda$0(g, this, arg_0));
    }

    private static final Unit draw$lambda$0(Graphics2D $g, WeaponBar this$0, Graphics2D it) {
        Weapon selectedWeapon;
        Intrinsics.checkNotNullParameter(it, "it");
        $g.setColor(Color.DARK_GRAY);
        $g.fillRect((int)this$0.getPosition().getX(), (int)this$0.getPosition().getY(), this$0.getParent().getWidth(), 32);
        $g.setStroke(this$0.stroke);
        int i = 0;
        int idx = 0;
        Player player = GameController.INSTANCE.getCurrentPlayer();
        if (player == null) {
            return Unit.INSTANCE;
        }
        Player currentPlayer = player;
        int currentWeaponId = currentPlayer.getCurrentWeaponId();
        for (Weapon weapon : Weapon.Companion.getAllWeapons().values()) {
            if (weapon.getId() == currentWeaponId) {
                $g.setColor(currentPlayer.getColor());
            } else {
                $g.setColor(this$0.darkPurple);
            }
            $g.drawRect((int)(this$0.getPosition().getX() + (double)i), (int)this$0.getPosition().getY(), 32, 32);
            Integer n = currentPlayer.getWeaponry().get(weapon.getId());
            if ((n != null ? n : 0) > 0) {
                weapon.drawIcon($g, (int)(this$0.getPosition().getX() + (double)i), (int)this$0.getPosition().getY());
            }
            i += 35;
            ++idx;
        }
        Weapon weapon = selectedWeapon = Weapon.Companion.getAllWeapons().get(currentWeaponId);
        String selectedWeaponName = weapon != null ? weapon.getName() : null;
        Weapon weapon2 = selectedWeapon;
        Integer n = currentPlayer.getWeaponry().get(weapon2 != null ? Integer.valueOf(weapon2.getId()) : null);
        int selectedWeaponAmmo = n != null ? n : 0;
        $g.drawString(selectedWeaponName + " (" + selectedWeaponAmmo + ')', (int)(this$0.getPosition().getX() + (double)i), 42);
        return Unit.INSTANCE;
    }
}

