/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene.Player;

import Game.GameController;
import Game.TerrainScene.Player.Cpu;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Player.PlayerDecision;
import Game.TerrainScene.Tank;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"LGame/TerrainScene/Player/RandomCpu;", "LGame/TerrainScene/Player/Cpu;", "<init>", "()V", "getDecision", "LGame/TerrainScene/Player/PlayerDecision;", "player", "LGame/TerrainScene/Player/Player;", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nRandomCpu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomCpu.kt\nGame/TerrainScene/Player/RandomCpu\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n535#2:54\n520#2,6:55\n1782#3,4:61\n*S KotlinDebug\n*F\n+ 1 RandomCpu.kt\nGame/TerrainScene/Player/RandomCpu\n*L\n8#1:54\n8#1:55,6\n9#1:61,4\n*E\n"})
public final class RandomCpu
extends Cpu {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PlayerDecision getDecision(@NotNull Player player) {
        int n;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        Map<Integer, Integer> $this$filter$iv = player.getWeaponry();
        boolean $i$f$filter = false;
        Map<Integer, Integer> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((Number)it.getValue()).intValue() > 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        int chosenWeaponId = ((Number)CollectionsKt.random(destination$iv$iv.keySet(), Random.Default)).intValue();
        Iterable $this$count$iv = GameController.INSTANCE.getPlayers();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                if (!it.getPlaying() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n <= 1) {
            return new PlayerDecision(player, 0, 0, player.getCurrentWeaponId());
        }
        Player target = this.getRandomTargetExcept(player);
        Tank targetTank = target.getTank();
        Tank playersTank = player.getTank();
        if (targetTank == null || playersTank == null) {
            return new PlayerDecision(player, 0, 0, player.getCurrentWeaponId());
        }
        int minAngle = 0;
        int maxAngle = 180;
        int minPower = 50;
        int maxPower = 300;
        if (playersTank.getPosition().getX() > targetTank.getPosition().getX()) {
            minAngle = 91;
        } else if (playersTank.getPosition().getX() < targetTank.getPosition().getX()) {
            maxAngle = 89;
        }
        double distance = playersTank.getPosition().distance(targetTank.getPosition());
        PlayerDecision decision = new PlayerDecision(player, Random.Default.nextInt(minAngle, maxAngle), Random.Default.nextInt(minPower, maxPower += (int)distance / 10), chosenWeaponId);
        return decision;
    }
}

