/*
 * Decompiled with CFR 0.152.
 */
package Game.Menu.MenuPoints;

import Engine.ExtensionsKt;
import Engine.IGameScene;
import Game.Menu.MenuPoints.MenuPointGameObject;
import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0003J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"LGame/Menu/MenuPoints/TextInputMenuPoint;", "LGame/Menu/MenuPoints/MenuPointGameObject;", "label", "", "parent", "LEngine/IGameScene;", "initialTextValue", "coloredBorder", "Ljava/awt/Color;", "initialFontSize", "", "maxTextLength", "maxTextLengthIsMs", "", "<init>", "(Ljava/lang/String;LEngine/IGameScene;Ljava/lang/String;Ljava/awt/Color;IIZ)V", "getMaxTextLength", "()I", "getMaxTextLengthIsMs", "()Z", "lighterColoredBorder", "value", "textValue", "getTextValue", "()Ljava/lang/String;", "setTextValue", "(Ljava/lang/String;)V", "textWidthInMs", "", "draw", "", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nTextInputMenuPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextInputMenuPoint.kt\nGame/Menu/MenuPoints/TextInputMenuPoint\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,68:1\n1104#2,3:69\n1104#2,3:72\n1104#2,3:75\n1104#2,3:78\n1104#2,3:81\n1104#2,3:84\n1104#2,3:87\n*S KotlinDebug\n*F\n+ 1 TextInputMenuPoint.kt\nGame/Menu/MenuPoints/TextInputMenuPoint\n*L\n35#1:69,3\n36#1:72,3\n37#1:75,3\n38#1:78,3\n39#1:81,3\n40#1:84,3\n41#1:87,3\n*E\n"})
public final class TextInputMenuPoint
extends MenuPointGameObject {
    @NotNull
    private final String label;
    @Nullable
    private final Color coloredBorder;
    private final int maxTextLength;
    private final boolean maxTextLengthIsMs;
    @Nullable
    private Color lighterColoredBorder;
    @NotNull
    private String textValue;

    public TextInputMenuPoint(@NotNull String label, @NotNull IGameScene parent, @NotNull String initialTextValue, @Nullable Color coloredBorder, int initialFontSize, int maxTextLength, boolean maxTextLengthIsMs) {
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(initialTextValue, "initialTextValue");
        super(label, parent, false, true, initialFontSize, false, TextInputMenuPoint::_init_$lambda$0, 36, null);
        this.label = label;
        this.coloredBorder = coloredBorder;
        this.maxTextLength = maxTextLength;
        this.maxTextLengthIsMs = maxTextLengthIsMs;
        Color color = this.coloredBorder;
        this.lighterColoredBorder = color != null ? ExtensionsKt.lighter(color, 100) : null;
        this.textValue = initialTextValue;
        this.setTextValue(initialTextValue);
    }

    public /* synthetic */ TextInputMenuPoint(String string, IGameScene iGameScene, String string2, Color color, int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            color = null;
        }
        if ((n3 & 0x10) != 0) {
            n = 24;
        }
        if ((n3 & 0x20) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n3 & 0x40) != 0) {
            bl = false;
        }
        this(string, iGameScene, string2, color, n, n2, bl);
    }

    public final int getMaxTextLength() {
        return this.maxTextLength;
    }

    public final boolean getMaxTextLengthIsMs() {
        return this.maxTextLengthIsMs;
    }

    @NotNull
    public final String getTextValue() {
        return this.textValue;
    }

    public final void setTextValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (this.maxTextLengthIsMs) {
            if (this.textWidthInMs(value) <= (float)this.maxTextLength) {
                this.setText(this.label + ": " + value);
                this.textValue = value;
            }
        } else if (value.length() <= this.maxTextLength) {
            this.setText(this.label + ": " + value);
            this.textValue = value;
        }
    }

    public final float textWidthInMs(@NotNull String value) {
        int element$iv;
        int element$iv2;
        int element$iv3;
        int element$iv4;
        int element$iv5;
        Intrinsics.checkNotNullParameter(value, "value");
        CharSequence $this$count$iv = value;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            int it = element$iv5 = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == 109)) continue;
            ++count$iv;
        }
        int smallMs = count$iv;
        CharSequence $this$count$iv2 = value;
        boolean $i$f$count2 = false;
        int count$iv2 = 0;
        for (element$iv5 = 0; element$iv5 < $this$count$iv2.length(); ++element$iv5) {
            int it = element$iv4 = $this$count$iv2.charAt(element$iv5);
            boolean bl = false;
            if (!(it == 77 || it == 198)) continue;
            ++count$iv2;
        }
        int bigMs = count$iv2;
        CharSequence $this$count$iv3 = value;
        boolean $i$f$count3 = false;
        int count$iv3 = 0;
        for (element$iv4 = 0; element$iv4 < $this$count$iv3.length(); ++element$iv4) {
            int it = element$iv3 = $this$count$iv3.charAt(element$iv4);
            boolean bl = false;
            if (!(it == 78 || it == 68 || it == 85)) continue;
            ++count$iv3;
        }
        int bigNs = count$iv3;
        CharSequence $this$count$iv4 = value;
        boolean $i$f$count4 = false;
        int count$iv4 = 0;
        for (element$iv3 = 0; element$iv3 < $this$count$iv4.length(); ++element$iv3) {
            int it = element$iv2 = $this$count$iv4.charAt(element$iv3);
            boolean bl = false;
            if (!(it == 110 || it == 107 || it == 75 || it == 82 || it == 97)) continue;
            ++count$iv4;
        }
        int ns = count$iv4;
        CharSequence $this$count$iv5 = value;
        boolean $i$f$count5 = false;
        int count$iv5 = 0;
        for (element$iv2 = 0; element$iv2 < $this$count$iv5.length(); ++element$iv2) {
            int it = element$iv = $this$count$iv5.charAt(element$iv2);
            boolean bl = false;
            if (!(it == 114)) continue;
            ++count$iv5;
        }
        int rs = count$iv5;
        CharSequence $this$count$iv6 = value;
        boolean $i$f$count6 = false;
        int count$iv6 = 0;
        for (element$iv = 0; element$iv < $this$count$iv6.length(); ++element$iv) {
            char element$iv6;
            char it = element$iv6 = $this$count$iv6.charAt(element$iv);
            boolean bl = false;
            if (!(it == 'f')) continue;
            ++count$iv6;
        }
        int mids = count$iv6;
        CharSequence $this$count$iv7 = value;
        boolean $i$f$count7 = false;
        int count$iv7 = 0;
        for (int i = 0; i < $this$count$iv7.length(); ++i) {
            char element$iv7;
            char it = element$iv7 = $this$count$iv7.charAt(i);
            boolean bl = false;
            if (!(it == 'l' || it == 'i' || it == 'j' || it == '\'' || it == '.' || it == ',' || it == '!')) continue;
            ++count$iv7;
        }
        int smalls = count$iv7;
        int size = ((CharSequence)value).length();
        int others = size - smallMs - bigMs - bigNs - rs - ns - mids - smalls;
        float width = (float)smalls * 0.3f + (float)mids * 0.4f + (float)rs * 0.5f + (float)others * 0.65f + (float)ns * 0.7f + (float)bigNs * 0.8f + (float)bigMs + (float)smallMs * 1.1f;
        return width;
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        if (this.coloredBorder != null) {
            g.setColor(this.getSelected() ? this.lighterColoredBorder : this.coloredBorder);
            g.setFont(this.getFont());
            int width = g.getFontMetrics().stringWidth(this.getText());
            g.fillRect((int)this.getPosition().getX() - 3, (int)(this.getPosition().getY() - (double)3), width, 6);
        }
        super.draw(g);
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }
}

