/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Engine.Pos2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0005\u0010\u000eJ\u0006\u0010\u0015\u001a\u00020\u0000J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0000J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0000J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010!\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\fH\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012\u00a8\u0006*"}, d2={"LEngine/Vec2D;", "", "x", "", "y", "<init>", "(DD)V", "p1", "LEngine/Pos2D;", "p2", "(LEngine/Pos2D;LEngine/Pos2D;)V", "xi", "", "yi", "(II)V", "getX", "()D", "setX", "(D)V", "getY", "setY", "copy", "plus", "other", "unaryMinus", "minus", "mag", "dot", "angleTo", "hat", "times", "num", "div", "normalized", "reflect", "component1", "component2", "equals", "", "hashCode", "toString", "", "TankWarsKotlin"})
public final class Vec2D {
    private double x;
    private double y;

    public Vec2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public Vec2D(@NotNull Pos2D p1, @NotNull Pos2D p2) {
        Intrinsics.checkNotNullParameter(p1, "p1");
        Intrinsics.checkNotNullParameter(p2, "p2");
        this(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    public Vec2D(int xi, int yi) {
        this((double)xi, (double)yi);
    }

    @NotNull
    public final Vec2D copy() {
        return new Vec2D(this.x, this.y);
    }

    @NotNull
    public final Vec2D plus(@NotNull Vec2D other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vec2D(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public final Vec2D unaryMinus() {
        return new Vec2D(-this.x, -this.y);
    }

    @NotNull
    public final Vec2D minus(@NotNull Vec2D other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vec2D(this.x - other.x, this.y - other.y);
    }

    public final double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final double dot(@NotNull Vec2D other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.x * other.x + this.y * other.y;
    }

    public final double angleTo(@NotNull Vec2D other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Math.acos(this.dot(other) / (this.mag() * other.mag()));
    }

    @NotNull
    public final Vec2D hat() {
        return new Vec2D(-this.y, this.x);
    }

    @NotNull
    public final Vec2D times(double num) {
        return new Vec2D(this.x * num, this.y * num);
    }

    @NotNull
    public final Vec2D div(double num) {
        return new Vec2D(this.x / num, this.y / num);
    }

    @NotNull
    public final Vec2D normalized() {
        return new Vec2D(this.x, this.y).div(this.mag());
    }

    @NotNull
    public final Vec2D reflect(@NotNull Vec2D other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Vec2D n = other.normalized().hat();
        return this.minus(n.times((double)2 * this.dot(n)));
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Vec2D copy(double x, double y) {
        return new Vec2D(x, y);
    }

    public static /* synthetic */ Vec2D copy$default(Vec2D vec2D, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = vec2D.x;
        }
        if ((n & 2) != 0) {
            d2 = vec2D.y;
        }
        return vec2D.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Vec2D(x=" + this.x + ", y=" + this.y + ')';
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vec2D)) {
            return false;
        }
        Vec2D vec2D = (Vec2D)other;
        if (Double.compare(this.x, vec2D.x) != 0) {
            return false;
        }
        return Double.compare(this.y, vec2D.y) == 0;
    }
}

