/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Engine.AudioClipPlayer;
import java.net.URL;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"LEngine/AudioHelper;", "", "<init>", "()V", "clipPlayer", "LEngine/AudioClipPlayer;", "_lock", "Ljava/util/concurrent/locks/ReentrantLock;", "load", "", "path", "", "name", "play", "stop", "loop", "times", "", "unload", "TankWarsKotlin"})
public final class AudioHelper {
    @NotNull
    public static final AudioHelper INSTANCE = new AudioHelper();
    @NotNull
    private static final AudioClipPlayer clipPlayer = new AudioClipPlayer();
    @NotNull
    private static final ReentrantLock _lock = new ReentrantLock();

    private AudioHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@NotNull String path, @NotNull String name) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(name, "name");
        URL url = INSTANCE.getClass().getClassLoader().getResource(path);
        if (url != null) {
            Lock lock = _lock;
            lock.lock();
            try {
                boolean bl = false;
                clipPlayer.loadSound(url, name);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Lock lock = _lock;
        lock.lock();
        try {
            boolean bl = false;
            clipPlayer.playSound(name);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Lock lock = _lock;
        lock.lock();
        try {
            boolean bl = false;
            clipPlayer.stopSound(name);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loop(@NotNull String name, int times) {
        Intrinsics.checkNotNullParameter(name, "name");
        Lock lock = _lock;
        lock.lock();
        try {
            boolean bl = false;
            clipPlayer.loopSound(name, times);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void loop$default(AudioHelper audioHelper, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        audioHelper.loop(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unload() {
        Lock lock = _lock;
        lock.lock();
        try {
            boolean bl = false;
            clipPlayer.unload();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }
}

