/*
 * Decompiled with CFR 0.152.
 */
package Game.particles;

import Engine.GameObject2;
import Engine.GameRunner;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u0001:\u00014BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002002\u0006\u00102\u001a\u000203H\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001c\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0012\"\u0004\b-\u0010.\u00a8\u00065"}, d2={"LGame/particles/Particle;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "pos", "LEngine/Pos2D;", "startVelocity", "LEngine/Vec2D;", "gravity", "lifeInSeconds", "", "colors", "", "Ljava/awt/Color;", "sizes", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;LEngine/Vec2D;LEngine/Vec2D;D[Ljava/awt/Color;[Ljava/lang/Double;)V", "getGravity", "()LEngine/Vec2D;", "getColors", "()[Ljava/awt/Color;", "[Ljava/awt/Color;", "getSizes", "()[Ljava/lang/Double;", "[Ljava/lang/Double;", "lifeInTicks", "", "getLifeInTicks", "()I", "ticksLeft", "getTicksLeft", "setTicksLeft", "(I)V", "color", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "size", "getSize", "()D", "setSize", "(D)V", "velocity", "getVelocity", "setVelocity", "(LEngine/Vec2D;)V", "update", "", "draw", "g", "Ljava/awt/Graphics2D;", "Companion", "TankWarsKotlin"})
public final class Particle
extends GameObject2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vec2D gravity;
    @NotNull
    private final Color[] colors;
    @NotNull
    private final Double[] sizes;
    private final int lifeInTicks;
    private int ticksLeft;
    @NotNull
    private Color color;
    private double size;
    @NotNull
    private Vec2D velocity;
    @NotNull
    private static Map<Double, Stroke> strokes = new LinkedHashMap();

    public Particle(@NotNull IGameScene parent, @NotNull Pos2D pos, @NotNull Vec2D startVelocity, @NotNull Vec2D gravity, double lifeInSeconds, @NotNull Color[] colors, @NotNull Double[] sizes) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(startVelocity, "startVelocity");
        Intrinsics.checkNotNullParameter(gravity, "gravity");
        Intrinsics.checkNotNullParameter(colors, "colors");
        Intrinsics.checkNotNullParameter(sizes, "sizes");
        super(parent, pos);
        this.gravity = gravity;
        this.colors = colors;
        this.sizes = sizes;
        this.ticksLeft = this.lifeInTicks = (int)(GameRunner.Companion.getFps() * lifeInSeconds);
        this.color = ArraysKt.first(this.colors);
        this.size = ((Number)ArraysKt.first(this.sizes)).doubleValue();
        this.velocity = startVelocity.copy();
    }

    @NotNull
    public final Vec2D getGravity() {
        return this.gravity;
    }

    @NotNull
    public final Color[] getColors() {
        return this.colors;
    }

    @NotNull
    public final Double[] getSizes() {
        return this.sizes;
    }

    public final int getLifeInTicks() {
        return this.lifeInTicks;
    }

    public final int getTicksLeft() {
        return this.ticksLeft;
    }

    public final void setTicksLeft(int n) {
        this.ticksLeft = n;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.color = color;
    }

    public final double getSize() {
        return this.size;
    }

    public final void setSize(double d) {
        this.size = d;
    }

    @NotNull
    public final Vec2D getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(@NotNull Vec2D vec2D) {
        Intrinsics.checkNotNullParameter(vec2D, "<set-?>");
        this.velocity = vec2D;
    }

    @Override
    public void update() {
        --this.ticksLeft;
        if (this.ticksLeft <= 0) {
            this.getParent().remove(this);
            return;
        }
        double progress = (double)(this.lifeInTicks - this.ticksLeft) / (double)this.lifeInTicks;
        int colIdx = (int)((double)this.colors.length * progress);
        this.color = this.colors[colIdx];
        Object object = this.getPosition();
        ((Pos2D)object).setX(((Pos2D)object).getX() + this.velocity.getX());
        object = this.getPosition();
        ((Pos2D)object).setY(((Pos2D)object).getY() + this.velocity.getY());
        object = this.velocity;
        ((Vec2D)object).setX(((Vec2D)object).getX() + this.gravity.getX());
        object = this.velocity;
        ((Vec2D)object).setY(((Vec2D)object).getY() + this.gravity.getY());
        int sizeIdx = (int)((double)this.sizes.length * progress);
        this.size = this.sizes[sizeIdx];
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(this.color);
        Pos2D nextPos = this.getPosition().plus(this.velocity);
        if (!strokes.containsKey(this.size)) {
            strokes.put(this.size, new BasicStroke((float)this.size, 1, 1));
        }
        g.setStroke(strokes.get(this.size));
        g.drawLine((int)this.getPosition().getX(), (int)this.getPosition().getY(), (int)nextPos.getX(), (int)nextPos.getY());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"LGame/particles/Particle$Companion;", "", "<init>", "()V", "strokes", "", "", "Ljava/awt/Stroke;", "getStrokes", "()Ljava/util/Map;", "setStrokes", "(Ljava/util/Map;)V", "TankWarsKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Double, Stroke> getStrokes() {
            return strokes;
        }

        public final void setStrokes(@NotNull Map<Double, Stroke> map) {
            Intrinsics.checkNotNullParameter(map, "<set-?>");
            strokes = map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

