/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.GameObject2;
import Engine.GameSceneKt;
import Engine.IGameScene;
import Engine.Pos2D;
import Game.GameController;
import Game.Menu.MenuSceneKt;
import Game.TerrainScene.BattleScene;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Weapon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\fH\u0002J \u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J(\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"LGame/TerrainScene/WeaponBar;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;)V", "thinStroke", "Ljava/awt/BasicStroke;", "thickStroke", "nightBorderColor", "Ljava/awt/Color;", "dayBorderColor", "eveningBorderColor", "parentAsBattleScene", "LGame/TerrainScene/BattleScene;", "skyType", "", "getSkyType", "()I", "update", "", "draw", "g", "Ljava/awt/Graphics2D;", "getBorderColor", "drawWeaponIcon", "weapon", "LGame/TerrainScene/Weapon;", "i", "drawWeaponBorder", "isSelected", "", "currentPlayer", "LGame/TerrainScene/Player/Player;", "TankWarsKotlin"})
public final class WeaponBar
extends GameObject2 {
    @NotNull
    private final BasicStroke thinStroke;
    @NotNull
    private final BasicStroke thickStroke;
    @NotNull
    private final Color nightBorderColor;
    @NotNull
    private final Color dayBorderColor;
    @NotNull
    private final Color eveningBorderColor;
    @Nullable
    private final BattleScene parentAsBattleScene;

    public WeaponBar(@NotNull IGameScene parent, @NotNull Pos2D position) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        super(parent, position);
        this.thinStroke = new BasicStroke(1.0f, 0, 1);
        this.thickStroke = new BasicStroke(3.0f, 0, 1);
        this.nightBorderColor = new Color(128, 128, 255);
        this.dayBorderColor = new Color(192, 192, 255);
        this.eveningBorderColor = new Color(110, 8, 0);
        this.parentAsBattleScene = parent instanceof BattleScene ? (BattleScene)parent : null;
        this.setDrawOrder(100);
    }

    private final int getSkyType() {
        BattleScene battleScene = this.parentAsBattleScene;
        return battleScene != null ? battleScene.getSkyType() : MenuSceneKt.getOPTION_SKY_BLUE();
    }

    @Override
    public void update() {
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        GameSceneKt.drawAsHud(g, arg_0 -> WeaponBar.draw$lambda$0(g, this, arg_0));
    }

    private final Color getBorderColor() {
        Color color;
        int n = this.getSkyType();
        if (n == MenuSceneKt.getOPTION_SKY_BLUE()) {
            color = this.dayBorderColor;
        } else if (n == MenuSceneKt.getOPTION_SKY_EVENING()) {
            color = this.eveningBorderColor;
        } else if (n == MenuSceneKt.getOPTION_SKY_STARRY()) {
            color = this.nightBorderColor;
        } else {
            Color color2 = Color.BLACK;
            color = color2;
            Intrinsics.checkNotNullExpressionValue(color2, "BLACK");
        }
        return color;
    }

    private final void drawWeaponIcon(Graphics2D g, Weapon weapon, int i) {
        g.setColor(this.getBorderColor());
        g.setStroke(this.thickStroke);
        weapon.drawIcon(g, (int)(this.getPosition().getX() + (double)i), (int)this.getPosition().getY());
    }

    private final void drawWeaponBorder(boolean isSelected, Graphics2D g, Player currentPlayer, int i) {
        if (isSelected) {
            g.setStroke(this.thickStroke);
            g.setColor(currentPlayer.getColor());
        } else {
            g.setStroke(this.thinStroke);
            g.setColor(this.getBorderColor());
        }
        g.drawRect((int)(this.getPosition().getX() + (double)i), (int)this.getPosition().getY(), 30, 30);
    }

    private static final Unit draw$lambda$0(Graphics2D $g, WeaponBar this$0, Graphics2D it) {
        Weapon selectedWeapon;
        Intrinsics.checkNotNullParameter(it, "it");
        $g.setStroke(this$0.thinStroke);
        int i = 8;
        Player player = GameController.INSTANCE.getCurrentPlayer();
        if (player == null) {
            return Unit.INSTANCE;
        }
        Player currentPlayer = player;
        int currentWeaponId = currentPlayer.getCurrentWeaponId();
        for (Weapon weapon : Weapon.Companion.getAllWeapons().values()) {
            Integer n = currentPlayer.getWeaponry().get(weapon.getId());
            boolean hasThisWeapon = (n != null ? n : 0) > 0;
            if (!hasThisWeapon) continue;
            boolean isSelected = currentPlayer.getCurrentWeaponId() == weapon.getId();
            this$0.drawWeaponBorder(isSelected, $g, currentPlayer, i);
            this$0.drawWeaponIcon($g, weapon, i);
            i += 35;
        }
        i += 3;
        Weapon weapon = selectedWeapon = Weapon.Companion.getAllWeapons().get(currentWeaponId);
        String selectedWeaponName = weapon != null ? weapon.getName() : null;
        Weapon weapon2 = selectedWeapon;
        Integer n = currentPlayer.getWeaponry().get(weapon2 != null ? Integer.valueOf(weapon2.getId()) : null);
        int selectedWeaponAmmo = n != null ? n : 0;
        $g.drawString(selectedWeaponName + " (" + selectedWeaponAmmo + ')', (int)(this$0.getPosition().getX() + (double)i), 50);
        return Unit.INSTANCE;
    }
}

