/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.GameController;
import Game.TerrainScene.EarthquakeWeapon;
import Game.TerrainScene.ExplosionWeapon;
import Game.TerrainScene.FrogBombWeapon;
import Game.TerrainScene.MirvWeapon;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Projectile;
import Game.TerrainScene.RasterTerrain;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 $2\u00020\u0001:\u0001$B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H&J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0019H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006%"}, d2={"LGame/TerrainScene/Weapon;", "", "id", "", "name", "", "purchasePrice", "", "purchaseQuantity", "<init>", "(ILjava/lang/String;DI)V", "getId", "()I", "getName", "()Ljava/lang/String;", "getPurchasePrice", "()D", "getPurchaseQuantity", "drawIcon", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "getProjectile", "LGame/TerrainScene/Projectile;", "gameScene", "LEngine/IGameScene;", "pos", "LEngine/Pos2D;", "velocity", "LEngine/Vec2D;", "onExplode", "terrain", "LGame/TerrainScene/RasterTerrain;", "projectile", "Companion", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nWeapon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Weapon.kt\nGame/TerrainScene/Weapon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n1187#2,2:165\n1261#2,4:167\n1#3:171\n*S KotlinDebug\n*F\n+ 1 Weapon.kt\nGame/TerrainScene/Weapon\n*L\n29#1:165,2\n29#1:167,4\n*E\n"})
public abstract class Weapon {
    @NotNull
    public static final Companion Companion;
    private final int id;
    @NotNull
    private final String name;
    private final double purchasePrice;
    private final int purchaseQuantity;
    @NotNull
    private static final Map<Integer, Weapon> allWeapons;
    private static final int minWeaponId;
    private static final int maxWeaponId;

    public Weapon(int id, @NotNull String name, double purchasePrice, int purchaseQuantity) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.id = id;
        this.name = name;
        this.purchasePrice = purchasePrice;
        this.purchaseQuantity = purchaseQuantity;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final double getPurchasePrice() {
        return this.purchasePrice;
    }

    public final int getPurchaseQuantity() {
        return this.purchaseQuantity;
    }

    public abstract void drawIcon(@NotNull Graphics2D var1, int var2, int var3);

    @NotNull
    public Projectile getProjectile(@NotNull IGameScene gameScene, @NotNull Pos2D pos, @NotNull Vec2D velocity) {
        Intrinsics.checkNotNullParameter(gameScene, "gameScene");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(velocity, "velocity");
        Object object = GameController.INSTANCE.getCurrentPlayer();
        if (object == null || (object = ((Player)object).getColor()) == null) {
            object = Color.WHITE;
        }
        Object object2 = object;
        Intrinsics.checkNotNull(object2);
        return new Projectile(gameScene, pos, velocity, this.id, (Color)object2, false, null, 96, null);
    }

    public abstract void onExplode(@NotNull RasterTerrain var1, @NotNull IGameScene var2, @NotNull Projectile var3);

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateTo$iv$iv;
        Companion = new Companion(null);
        Weapon[] weaponArray = new Weapon[]{new ExplosionWeapon(1, "Knaldperle", 50.0, 50, 20), new ExplosionWeapon(2, "Kanonslaw", 100.0, 10, 40), new ExplosionWeapon(3, "Granat", 100.0, 10, 80), new ExplosionWeapon(4, "Klumpedumpebombe", 120.0, 1, 160), new EarthquakeWeapon(5, "Jordsk\u00e6lv", 150.0, 2), new FrogBombWeapon(6, "Fr\u00f8bombe", 200.0, 3), new MirvWeapon(7, "MIRV-3", 200.0, 2, 3), new MirvWeapon(8, "MIRV-5", 300.0, 2, 5), new MirvWeapon(9, "MIRV-7", 400.0, 2, 7)};
        Iterable $this$associate$iv = CollectionsKt.listOf(weaponArray);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Weapon it = (Weapon)element$iv$iv;
            boolean bl = false;
            Pair<Integer, Weapon> pair = TuplesKt.to(it.id, it);
            map.put(pair.getFirst(), pair.getSecond());
        }
        allWeapons = destination$iv$iv;
        Iterator iterator2 = ((Iterable)allWeapons.entrySet()).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Map.Entry it22 = (Map.Entry)iterator2.next();
        boolean bl = false;
        int it22 = ((Number)it22.getKey()).intValue();
        while (iterator2.hasNext()) {
            Map.Entry it32 = (Map.Entry)iterator2.next();
            $i$a$-minOf-Weapon$Companion$minWeaponId$1 = false;
            int it32 = ((Number)it32.getKey()).intValue();
            if (it22 <= it32) continue;
            it22 = it32;
        }
        minWeaponId = it22;
        iterator2 = ((Iterable)allWeapons.entrySet()).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Map.Entry it = (Map.Entry)iterator2.next();
        boolean bl2 = false;
        int n = ((Number)it.getKey()).intValue();
        while (iterator2.hasNext()) {
            Map.Entry it3 = (Map.Entry)iterator2.next();
            $i$a$-maxOf-Weapon$Companion$maxWeaponId$1 = false;
            int n2 = ((Number)it3.getKey()).intValue();
            if (n >= n2) continue;
            n = n2;
        }
        maxWeaponId = n;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"LGame/TerrainScene/Weapon$Companion;", "", "<init>", "()V", "allWeapons", "", "", "LGame/TerrainScene/Weapon;", "getAllWeapons", "()Ljava/util/Map;", "minWeaponId", "getMinWeaponId", "()I", "maxWeaponId", "getMaxWeaponId", "TankWarsKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Integer, Weapon> getAllWeapons() {
            return allWeapons;
        }

        public final int getMinWeaponId() {
            return minWeaponId;
        }

        public final int getMaxWeaponId() {
            return maxWeaponId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

