/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.GameObject2;
import Engine.GameRunner;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0019\u0010\u001f\u001a\n  *\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"LGame/TerrainScene/ProjectileTrail;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "color", "Ljava/awt/Color;", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;Ljava/awt/Color;)V", "size", "", "getSize", "()D", "setSize", "(D)V", "ticksLeft", "", "getTicksLeft", "()I", "setTicksLeft", "(I)V", "movement", "getMovement", "setMovement", "velocity", "LEngine/Vec2D;", "getVelocity", "()LEngine/Vec2D;", "setVelocity", "(LEngine/Vec2D;)V", "baseColor", "kotlin.jvm.PlatformType", "getBaseColor", "()Ljava/awt/Color;", "update", "", "draw", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
public final class ProjectileTrail
extends GameObject2 {
    private double size;
    private int ticksLeft;
    private double movement;
    @NotNull
    private Vec2D velocity;
    private final Color baseColor;

    public ProjectileTrail(@NotNull IGameScene parent, @NotNull Pos2D position, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(color, "color");
        super(parent, position);
        this.size = 5.0;
        this.ticksLeft = (int)(GameRunner.Companion.getFps() + (double)((int)(Math.random() * (double)10)));
        this.movement = 0.2 * GameRunner.Companion.getTick();
        this.velocity = new Vec2D(-this.movement / (double)2 + Math.random() * this.movement, -this.movement / (double)2 + Math.random() * this.movement);
        this.baseColor = color;
    }

    public final double getSize() {
        return this.size;
    }

    public final void setSize(double d) {
        this.size = d;
    }

    public final int getTicksLeft() {
        return this.ticksLeft;
    }

    public final void setTicksLeft(int n) {
        this.ticksLeft = n;
    }

    public final double getMovement() {
        return this.movement;
    }

    public final void setMovement(double d) {
        this.movement = d;
    }

    @NotNull
    public final Vec2D getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(@NotNull Vec2D vec2D) {
        Intrinsics.checkNotNullParameter(vec2D, "<set-?>");
        this.velocity = vec2D;
    }

    public final Color getBaseColor() {
        return this.baseColor;
    }

    @Override
    public void update() {
        if (this.ticksLeft <= 0) {
            this.getParent().remove(this);
            return;
        }
        Pos2D pos2D = this.getPosition();
        pos2D.setX(pos2D.getX() + this.velocity.getX() * (double)60);
        pos2D = this.getPosition();
        pos2D.setY(pos2D.getY() + this.velocity.getY() * (double)60);
        this.size -= (double)5 * GameRunner.Companion.getTick();
        --this.ticksLeft;
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(new Color(this.baseColor.getRed(), this.baseColor.getGreen(), this.baseColor.getBlue(), Math.min(this.ticksLeft * 2, 255)));
        g.fillOval((int)(this.getPosition().getX() - this.size / (double)2), (int)(this.getPosition().getY() - this.size / (double)2), (int)this.size, (int)this.size);
    }
}

