/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene.Player;

import Engine.Audio.AudioHelper;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.GameController;
import Game.Team;
import Game.TerrainScene.Player.PlayerType;
import Game.TerrainScene.Projectile;
import Game.TerrainScene.Tank;
import Game.TerrainScene.Weapon;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u00105\u001a\u00020\u001cJ\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000207J\u0006\u00109\u001a\u000207R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006:"}, d2={"LGame/TerrainScene/Player/Player;", "", "name", "", "playerType", "LGame/TerrainScene/Player/PlayerType;", "<init>", "(Ljava/lang/String;LGame/TerrainScene/Player/PlayerType;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getPlayerType", "()LGame/TerrainScene/Player/PlayerType;", "tank", "LGame/TerrainScene/Tank;", "getTank", "()LGame/TerrainScene/Tank;", "setTank", "(LGame/TerrainScene/Tank;)V", "playing", "", "getPlaying", "()Z", "setPlaying", "(Z)V", "weaponry", "", "", "getWeaponry", "()Ljava/util/Map;", "setWeaponry", "(Ljava/util/Map;)V", "fuel", "", "getFuel", "()D", "setFuel", "(D)V", "money", "getMoney", "setMoney", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "currentWeaponId", "getCurrentWeaponId", "()I", "setCurrentWeaponId", "(I)V", "victories", "decreaseAmmoAndCycleIfZero", "", "cycleWeapon", "fire", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Player.kt\nGame/TerrainScene/Player/Player\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class Player {
    @NotNull
    private String name;
    @NotNull
    private final PlayerType playerType;
    @Nullable
    private Tank tank;
    private boolean playing;
    @NotNull
    private Map<Integer, Integer> weaponry;
    private double fuel;
    private double money;
    @NotNull
    private Color color;
    private int currentWeaponId;

    public Player(@NotNull String name, @NotNull PlayerType playerType) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)playerType, "playerType");
        this.name = name;
        this.playerType = playerType;
        this.playing = true;
        this.weaponry = new LinkedHashMap();
        this.money = 200.0;
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        this.color = color;
        this.currentWeaponId = 1;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    @NotNull
    public final PlayerType getPlayerType() {
        return this.playerType;
    }

    @Nullable
    public final Tank getTank() {
        return this.tank;
    }

    public final void setTank(@Nullable Tank tank) {
        this.tank = tank;
    }

    public final boolean getPlaying() {
        return this.playing;
    }

    public final void setPlaying(boolean bl) {
        this.playing = bl;
    }

    @NotNull
    public final Map<Integer, Integer> getWeaponry() {
        return this.weaponry;
    }

    public final void setWeaponry(@NotNull Map<Integer, Integer> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.weaponry = map;
    }

    public final double getFuel() {
        return this.fuel;
    }

    public final void setFuel(double d) {
        this.fuel = d;
    }

    public final double getMoney() {
        return this.money;
    }

    public final void setMoney(double d) {
        this.money = d;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.color = color;
    }

    public final int getCurrentWeaponId() {
        return this.currentWeaponId;
    }

    public final void setCurrentWeaponId(int n) {
        this.currentWeaponId = n;
    }

    public final int victories() {
        Object v0;
        block1: {
            Iterable iterable = GameController.INSTANCE.getTeams();
            for (Object t : iterable) {
                Team it = (Team)t;
                boolean bl = false;
                if (!it.getPlayers().contains(this)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Team team = v0;
        return team != null ? team.getVictories() : 0;
    }

    public final void decreaseAmmoAndCycleIfZero() {
        Map<Integer, Integer> map = this.weaponry;
        Integer n = this.currentWeaponId;
        Integer n2 = this.weaponry.get(this.currentWeaponId);
        Integer n3 = (n2 != null ? n2 : 1) - 1;
        map.put(n, n3);
        Integer n4 = this.weaponry.get(this.currentWeaponId);
        if ((n4 != null ? n4 : 0) == 0) {
            this.cycleWeapon();
        }
    }

    public final void cycleWeapon() {
        int oldWeaponId = this.currentWeaponId;
        Tank tank = this.tank;
        if ((tank != null ? tank.getId() : 0) % 3 == 0) {
            AudioHelper.INSTANCE.play("click");
        } else {
            Tank tank2 = this.tank;
            if ((tank2 != null ? tank2.getId() : 0) % 2 == 0) {
                AudioHelper.INSTANCE.play("swoosh");
            } else {
                AudioHelper.INSTANCE.play("swoosh2");
            }
        }
        do {
            ++this.currentWeaponId;
            if (this.currentWeaponId > Weapon.Companion.getMaxWeaponId()) {
                this.currentWeaponId = Weapon.Companion.getMinWeaponId();
            }
            if (!this.weaponry.containsKey(this.currentWeaponId)) continue;
            Integer n = this.weaponry.get(this.currentWeaponId);
            if ((n != null ? n : 0) > 0) break;
        } while (this.currentWeaponId != oldWeaponId);
    }

    public final void fire() {
        block6: {
            Projectile projectile;
            Player player;
            block7: {
                switch (Random.Default.nextInt(3)) {
                    case 0: {
                        AudioHelper.INSTANCE.play("fire");
                        break;
                    }
                    case 1: {
                        AudioHelper.INSTANCE.play("fire2");
                        break;
                    }
                    case 2: {
                        AudioHelper.INSTANCE.play("fire3");
                    }
                }
                Player player2 = GameController.INSTANCE.getCurrentPlayer();
                if (player2 == null) break block6;
                player = player2;
                boolean bl = false;
                Integer n = player.weaponry.get(player.currentWeaponId);
                if ((n != null ? n : 0) != 0) break block7;
                AudioHelper.INSTANCE.play("fizzle");
                break block6;
            }
            Tank tank = this.tank;
            if (tank == null) break block6;
            Tank it = tank;
            boolean bl = false;
            Vec2D velocity = Tank.getFireVelocity$default(it, 0, 1, null);
            Pos2D position = new Pos2D((double)it.getCanonX(), (double)it.getCanonY());
            Weapon weapon = Weapon.Companion.getAllWeapons().get(player.currentWeaponId);
            Projectile projectile2 = projectile = weapon != null ? weapon.getProjectile(it.getParent(), position, velocity) : null;
            if (projectile != null) {
                it.getParent().add(projectile);
            }
            player.decreaseAmmoAndCycleIfZero();
        }
    }
}

