/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.GameController;
import Game.TerrainScene.Explosion;
import Game.TerrainScene.Projectile;
import Game.TerrainScene.RasterTerrain;
import Game.TerrainScene.Weapon;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J \u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"LGame/TerrainScene/FrogBombWeapon;", "LGame/TerrainScene/Weapon;", "id", "", "name", "", "purchasePrice", "", "purchaseQuantity", "<init>", "(ILjava/lang/String;DI)V", "drawIcon", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "onExplode", "terrain", "LGame/TerrainScene/RasterTerrain;", "gameScene", "LEngine/IGameScene;", "projectile", "LGame/TerrainScene/Projectile;", "TankWarsKotlin"})
public final class FrogBombWeapon
extends Weapon {
    public FrogBombWeapon(int id, @NotNull String name, double purchasePrice, int purchaseQuantity) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(id, name, purchasePrice, purchaseQuantity);
    }

    @Override
    public void drawIcon(@NotNull Graphics2D g, int x, int y) {
        Intrinsics.checkNotNullParameter(g, "g");
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f, 1, 1));
        g.drawArc(x, y + 12, 16, 24, 0, 90);
        g.drawArc(x + 16, y + 16, 8, 16, 0, 180);
        g.setStroke(oldStroke);
    }

    @Override
    public void onExplode(@NotNull RasterTerrain terrain, @NotNull IGameScene gameScene, @NotNull Projectile projectile) {
        Intrinsics.checkNotNullParameter(terrain, "terrain");
        Intrinsics.checkNotNullParameter(gameScene, "gameScene");
        Intrinsics.checkNotNullParameter(projectile, "projectile");
        projectile.setJumps(projectile.getJumps() + 1);
        Vec2D possibleNextVelocity = new Vec2D(projectile.getVelocity().getX(), -projectile.getVelocity().getY());
        Pos2D nextPossiblePos = projectile.getPosition().plus(possibleNextVelocity);
        if (nextPossiblePos.getX() >= 0.0 && nextPossiblePos.getX() < (double)terrain.getRasterImage().getWidth() && nextPossiblePos.getY() < (double)terrain.getRasterImage().getHeight()) {
            Vec2D vec2D;
            if (terrain.getRasterImage().getRGB((int)nextPossiblePos.getX(), (int)nextPossiblePos.getY()) != 0) {
                vec2D = projectile.getVelocity();
                vec2D.setX(vec2D.getX() * -0.5);
                vec2D = projectile.getVelocity();
                vec2D.setY(vec2D.getY() * -0.5);
            } else {
                vec2D = projectile.getVelocity();
                vec2D.setY(vec2D.getY() * -0.5);
            }
        }
        Explosion exp = new Explosion(gameScene, projectile.getPosition(), 30, 15, () -> FrogBombWeapon.onExplode$lambda$0(terrain));
        gameScene.add(exp);
        if (projectile.getJumps() >= 3) {
            gameScene.remove(projectile);
            GameController.INSTANCE.setProjectilesFlying(GameController.INSTANCE.getProjectilesFlying() - 1);
            Projectile.Companion.getActiveProjectiles().remove(projectile);
        }
    }

    private static final Unit onExplode$lambda$0(RasterTerrain $terrain) {
        $terrain.setCrumble(true);
        return Unit.INSTANCE;
    }
}

