/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.Audio.AudioHelper;
import Engine.GameObject2;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.GameController;
import Game.TerrainScene.BattleScene;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.RasterTerrain;
import Game.TerrainScene.Tank;
import Game.particles.DirtFragmentEmitter;
import Game.particles.FireEmitter;
import Game.particles.SmokeEmitter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011\u00a8\u0006\u001d"}, d2={"LGame/TerrainScene/Explosion;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "size", "", "duration", "onDone", "Lkotlin/Function0;", "", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;IILkotlin/jvm/functions/Function0;)V", "getSize", "()I", "setSize", "(I)V", "getDuration", "getOnDone", "()Lkotlin/jvm/functions/Function0;", "tick", "getTick", "setTick", "update", "draw", "g", "Ljava/awt/Graphics2D;", "Companion", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nExplosion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Explosion.kt\nGame/TerrainScene/Explosion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1863#2,2:93\n*S KotlinDebug\n*F\n+ 1 Explosion.kt\nGame/TerrainScene/Explosion\n*L\n46#1:93,2\n*E\n"})
public final class Explosion
extends GameObject2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size;
    private final int duration;
    @NotNull
    private final Function0<Unit> onDone;
    private int tick;
    @NotNull
    private static final Set<Explosion> currentExplosions = new LinkedHashSet();

    public Explosion(@NotNull IGameScene parent, @NotNull Pos2D position, int size, int duration, @NotNull Function0<Unit> onDone) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(onDone, "onDone");
        super(parent, position);
        this.size = size;
        this.duration = duration;
        this.onDone = onDone;
        GameController.INSTANCE.setExplosionsActive(GameController.INSTANCE.getExplosionsActive() + 1);
        GameController.INSTANCE.setGlowUp(10);
        RasterTerrain terrain = ((BattleScene)parent).getRasterTerrain();
        terrain.pokeHole((int)position.getX(), (int)position.getY(), this.size);
        terrain.addScorchFromExplosion((int)position.getX() - this.size / 2, (int)position.getX() + this.size / 2);
        if (this.size >= 100) {
            AudioHelper.INSTANCE.play("big-boom");
        } else {
            AudioHelper.INSTANCE.play("small-boom");
        }
        currentExplosions.add(this);
        ((BattleScene)parent).add(new SmokeEmitter(parent, position, this.size / 2, 0.5));
        ((BattleScene)parent).add(new FireEmitter(parent, position, this.size / 2, 0.5));
        ((BattleScene)parent).add(new DirtFragmentEmitter(parent, position, this.size / 2, 0, 8, null));
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final int getDuration() {
        return this.duration;
    }

    @NotNull
    public final Function0<Unit> getOnDone() {
        return this.onDone;
    }

    public final int getTick() {
        return this.tick;
    }

    public final void setTick(int n) {
        this.tick = n;
    }

    @Override
    public void update() {
        ++this.tick;
        if (this.tick == 1) {
            Iterable $this$forEach$iv = GameController.INSTANCE.getPlayers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player p;
                Tank tank;
                Player it = (Player)element$iv;
                boolean bl = false;
                if (!it.getPlaying() || (tank = it.getTank()) == null) continue;
                double distance = new Vec2D(this.getPosition(), tank.getPosition()).mag();
                if (distance < (double)(tank.getSize() / 2)) {
                    tank.setEnergy(0);
                    if (Intrinsics.areEqual(GameController.INSTANCE.getCurrentPlayersTank(), it.getTank())) continue;
                    if (GameController.INSTANCE.getCurrentPlayer() != null) {
                        Player p2;
                        boolean bl2 = false;
                        p2.setMoney(p2.getMoney() + (double)100);
                    }
                    continue;
                }
                if (!(distance < (double)this.size * 1.3)) continue;
                int delta = Math.abs(20 * (int)((double)this.size / distance));
                Tank tank2 = tank;
                tank2.setEnergy(tank2.getEnergy() - delta / 10);
                if (!Intrinsics.areEqual(GameController.INSTANCE.getCurrentPlayersTank(), it.getTank())) {
                    if (GameController.INSTANCE.getCurrentPlayer() != null) {
                        Player p3;
                        boolean bl3 = false;
                        p3.setMoney(p3.getMoney() + (double)Math.min(200, delta));
                    }
                }
                if (tank.getEnergy() >= 0) continue;
                tank.setEnergy(0);
                if (Intrinsics.areEqual(GameController.INSTANCE.getCurrentPlayersTank(), it.getTank())) continue;
                if (GameController.INSTANCE.getCurrentPlayer() == null) continue;
                boolean bl4 = false;
                p.setMoney(p.getMoney() + (double)100);
            }
        }
        if (this.duration - this.tick < 10) {
            this.size = (int)((double)this.size * 0.8);
        }
        if (this.tick >= this.duration) {
            this.getParent().remove(this);
            currentExplosions.remove(this);
            GameController.INSTANCE.setExplosionsActive(GameController.INSTANCE.getExplosionsActive() - 1);
            this.onDone.invoke();
        }
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(Color.RED);
        g.fillOval((int)(this.getPosition().getX() - (double)(this.size / 2)), (int)(this.getPosition().getY() - (double)(this.size / 2)), this.size, this.size);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"LGame/TerrainScene/Explosion$Companion;", "", "<init>", "()V", "currentExplosions", "", "LGame/TerrainScene/Explosion;", "getCurrentExplosions", "()Ljava/util/Set;", "TankWarsKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Explosion> getCurrentExplosions() {
            return currentExplosions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

