/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.IGameScene;
import Game.GameController;
import Game.TerrainScene.Projectile;
import Game.TerrainScene.RasterTerrain;
import Game.TerrainScene.Weapon;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J \u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"LGame/TerrainScene/EarthquakeWeapon;", "LGame/TerrainScene/Weapon;", "id", "", "name", "", "purchasePrice", "", "purchaseQuantity", "<init>", "(ILjava/lang/String;DI)V", "drawIcon", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "onExplode", "terrain", "LGame/TerrainScene/RasterTerrain;", "gameScene", "LEngine/IGameScene;", "projectile", "LGame/TerrainScene/Projectile;", "TankWarsKotlin"})
public final class EarthquakeWeapon
extends Weapon {
    public EarthquakeWeapon(int id, @NotNull String name, double purchasePrice, int purchaseQuantity) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(id, name, purchasePrice, purchaseQuantity);
    }

    @Override
    public void drawIcon(@NotNull Graphics2D g, int x, int y) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.fillOval(x + 10, y + 10, 3, 3);
        g.fillOval(x + 15, y + 10, 3, 3);
        g.fillOval(x + 20, y + 10, 3, 3);
        g.fillOval(x + 9, y + 15, 3, 3);
        g.fillOval(x + 14, y + 15, 3, 3);
        g.fillOval(x + 19, y + 15, 3, 3);
        g.fillOval(x + 10, y + 20, 3, 3);
        g.fillOval(x + 15, y + 20, 3, 3);
        g.fillOval(x + 20, y + 20, 3, 3);
    }

    @Override
    public void onExplode(@NotNull RasterTerrain terrain, @NotNull IGameScene gameScene, @NotNull Projectile projectile) {
        Intrinsics.checkNotNullParameter(terrain, "terrain");
        Intrinsics.checkNotNullParameter(gameScene, "gameScene");
        Intrinsics.checkNotNullParameter(projectile, "projectile");
        terrain.startEarthquake((int)projectile.getPosition().getX(), (int)projectile.getPosition().getY());
        gameScene.remove(projectile);
        GameController.INSTANCE.setProjectilesFlying(GameController.INSTANCE.getProjectilesFlying() - 1);
        Projectile.Companion.getActiveProjectiles().remove(projectile);
    }
}

