/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.GameRunner;
import Engine.Vec2D;
import Game.TerrainScene.BattleSceneKt;
import Game.TerrainScene.EarthquakeCrack;
import Game.TerrainScene.RasterTerrain;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"LGame/TerrainScene/Earthquake;", "", "x", "", "y", "numCracks", "size", "branchProbability", "", "<init>", "(IIIID)V", "getX", "()I", "getY", "getSize", "getBranchProbability", "()D", "cracks", "", "LGame/TerrainScene/EarthquakeCrack;", "getCracks", "()Ljava/util/List;", "setCracks", "(Ljava/util/List;)V", "createCrack", "growDuration", "update", "", "terrain", "LGame/TerrainScene/RasterTerrain;", "remove", "", "TankWarsKotlin"})
public final class Earthquake {
    private final int x;
    private final int y;
    private final int size;
    private final double branchProbability;
    @NotNull
    private List<EarthquakeCrack> cracks;

    public Earthquake(int x, int y, int numCracks, int size, double branchProbability) {
        this.x = x;
        this.y = y;
        this.size = size;
        this.branchProbability = branchProbability;
        this.cracks = new ArrayList();
        int i = 0;
        int n = numCracks - 1;
        if (i <= n) {
            while (true) {
                this.cracks.add(this.createCrack(this.x, this.y, this.size));
                if (i == n) break;
                ++i;
            }
        }
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getSize() {
        return this.size;
    }

    public final double getBranchProbability() {
        return this.branchProbability;
    }

    @NotNull
    public final List<EarthquakeCrack> getCracks() {
        return this.cracks;
    }

    public final void setCracks(@NotNull List<EarthquakeCrack> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.cracks = list;
    }

    @NotNull
    public final EarthquakeCrack createCrack(double x, double y, int growDuration) {
        return new EarthquakeCrack(x, y, new Vec2D(BattleSceneKt.getRandom().nextDouble(-5.0, 5.0), BattleSceneKt.getRandom().nextDouble(-5.0, 5.0)), growDuration);
    }

    public final boolean update(@NotNull RasterTerrain terrain) {
        Intrinsics.checkNotNullParameter(terrain, "terrain");
        boolean didChangeTerrain = false;
        List newCracks = new ArrayList();
        for (EarthquakeCrack crack : this.cracks) {
            if (crack.getGrowDuration() <= 0) continue;
            crack.setGrowDuration(crack.getGrowDuration() - 1);
            int holeSize = Math.min(4, crack.getGrowDuration() / 10);
            double oldX = crack.getX();
            double oldY = crack.getY();
            if (BattleSceneKt.getRandom().nextDouble() < 0.1 || crack.getGrowDuration() % 6 == 0) {
                crack.setX(crack.getX() - crack.getDirection().getY() * 60.0 / GameRunner.Companion.getFps());
                crack.setY(crack.getY() + crack.getDirection().getX() * 60.0 / GameRunner.Companion.getFps());
            } else {
                crack.setX(crack.getX() + crack.getDirection().getX() * 60.0 / GameRunner.Companion.getFps());
                crack.setY(crack.getY() + crack.getDirection().getY() * 60.0 / GameRunner.Companion.getFps());
                double futureX = crack.getX() + crack.getDirection().getX() * 10.0;
                double futureY = crack.getY() + crack.getDirection().getY() * 10.0;
                if (futureX < 0.0 || futureX > (double)terrain.getRasterImage().getWidth() || futureY < 0.0 || futureY > (double)terrain.getRasterImage().getHeight() || terrain.getRasterImage().getRGB((int)futureX, (int)futureY) == 0) {
                    crack.setGrowDuration(0);
                    continue;
                }
            }
            terrain.pokeLine((int)oldX, (int)oldY, (int)crack.getX(), (int)crack.getY(), holeSize);
            if (BattleSceneKt.getRandom().nextDouble() < 0.9) {
                terrain.pokeLine((int)oldX, (int)oldY, (int)crack.getX() - 10 + BattleSceneKt.getRandom().nextInt(20), (int)crack.getY() - 10 + BattleSceneKt.getRandom().nextInt(20), 2.0f);
            }
            if (BattleSceneKt.getRandom().nextDouble() < this.branchProbability / (double)30) {
                boolean bl = BattleSceneKt.getRandom().nextDouble() < 0.1 ? newCracks.add(this.createCrack(crack.getX(), crack.getY(), this.size)) : newCracks.add(this.createCrack(crack.getX(), crack.getY(), (int)((double)crack.getGrowDuration() * 1.0)));
            }
            Vec2D vec2D = crack.getDirection();
            vec2D.setX(vec2D.getX() + BattleSceneKt.getRandom().nextDouble(-0.1, 0.1));
            vec2D = crack.getDirection();
            vec2D.setY(vec2D.getY() + BattleSceneKt.getRandom().nextDouble(-0.1, 0.1));
            didChangeTerrain = true;
        }
        this.cracks.addAll(newCracks);
        return didChangeTerrain;
    }

    public final void remove() {
        this.cracks.clear();
    }
}

