/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.GameObject2;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.GameController;
import Game.TerrainScene.BattleScene;
import Game.TerrainScene.Projectile;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"LGame/TerrainScene/CloudPart;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "size", "", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;I)V", "getSize", "()I", "setSize", "(I)V", "velocity", "LEngine/Vec2D;", "getVelocity", "()LEngine/Vec2D;", "setVelocity", "(LEngine/Vec2D;)V", "dying", "", "life", "update", "", "split", "projectilePosition", "draw", "g", "Ljava/awt/Graphics2D;", "Companion", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nCloud.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cloud.kt\nGame/TerrainScene/CloudPart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1863#2,2:110\n*S KotlinDebug\n*F\n+ 1 Cloud.kt\nGame/TerrainScene/CloudPart\n*L\n70#1:110,2\n*E\n"})
public final class CloudPart
extends GameObject2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size;
    @NotNull
    private Vec2D velocity;
    private boolean dying;
    private int life;
    @NotNull
    private static BasicStroke cloudOutlineStroke = new BasicStroke(4.0f, 1, 1);

    public CloudPart(@NotNull IGameScene parent, @NotNull Pos2D position, int size) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        super(parent, position);
        this.size = size;
        this.velocity = new Vec2D(GameController.INSTANCE.getWind() / 10.0, 0.0);
        this.life = -1;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    @NotNull
    public final Vec2D getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(@NotNull Vec2D vec2D) {
        Intrinsics.checkNotNullParameter(vec2D, "<set-?>");
        this.velocity = vec2D;
    }

    @Override
    public void update() {
        if (this.dying) {
            --this.size;
        }
        if (this.dying && this.life <= 0 || this.size <= 0) {
            this.getParent().remove(this);
            return;
        }
        Pos2D pos2D = this.getPosition();
        pos2D.setX(pos2D.getX() + this.velocity.getX());
        pos2D = this.getPosition();
        pos2D.setY(pos2D.getY() + this.velocity.getY());
        this.velocity.setX(GameController.INSTANCE.getWind() / 10.0);
        if (this.getPosition().getX() < -300.0) {
            Pos2D pos2D2 = this.getPosition();
            IGameScene iGameScene = this.getParent();
            Intrinsics.checkNotNull(iGameScene, "null cannot be cast to non-null type Game.TerrainScene.BattleScene");
            pos2D2.setX((double)((BattleScene)iGameScene).getTerrainWidth() + 300.0);
        } else {
            double d = this.getPosition().getX();
            IGameScene iGameScene = this.getParent();
            Intrinsics.checkNotNull(iGameScene, "null cannot be cast to non-null type Game.TerrainScene.BattleScene");
            if (d > (double)(((BattleScene)iGameScene).getTerrainWidth() + 300)) {
                this.getPosition().setX(-300.0);
            }
        }
        if (!this.dying) {
            Iterable $this$forEach$iv = Projectile.Companion.getActiveProjectiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Projectile p = (Projectile)element$iv;
                boolean bl = false;
                double dist = this.getPosition().distance(p.getPosition());
                if (!(dist < (double)this.size)) continue;
                if (this.size < 20) {
                    this.dying = true;
                    this.life = 200;
                    this.velocity = new Vec2D(p.getPosition(), this.getPosition()).plus(p.getVelocity()).times(0.1);
                } else if (!this.dying) {
                    this.split(p.getPosition());
                }
                Vec2D vec2D = p.getVelocity();
                vec2D.setY(vec2D.getY() * 0.95);
                vec2D = p.getVelocity();
                vec2D.setX(vec2D.getX() * 0.98);
            }
        }
    }

    private final void split(Pos2D projectilePosition) {
        int n = 4;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            CloudPart cloud1 = new CloudPart(this.getParent(), Pos2D.copy$default(this.getPosition(), 0.0, 0.0, 3, null).plus(new Vec2D(Random.Default.nextInt(-this.size / 2, this.size / 2), Random.Default.nextInt(-this.size / 2, this.size / 2))), this.size / 2);
            if (!(cloud1.getPosition().distance(projectilePosition) > (double)(this.size / 2))) continue;
            this.getParent().add(cloud1);
        }
        this.getParent().remove(this);
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(Color.WHITE);
        g.fillArc((int)(this.getPosition().getX() - (double)(this.size / 2)), (int)(this.getPosition().getY() - (double)(this.size / 2)), this.size, this.size, 0, 360);
        g.setColor(Color.LIGHT_GRAY);
        g.setStroke(cloudOutlineStroke);
        g.drawArc((int)(this.getPosition().getX() - (double)(this.size / 2)), (int)(this.getPosition().getY() - (double)(this.size / 2)), this.size, this.size, 20, -160);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"LGame/TerrainScene/CloudPart$Companion;", "", "<init>", "()V", "cloudOutlineStroke", "Ljava/awt/BasicStroke;", "getCloudOutlineStroke", "()Ljava/awt/BasicStroke;", "setCloudOutlineStroke", "(Ljava/awt/BasicStroke;)V", "TankWarsKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BasicStroke getCloudOutlineStroke() {
            return cloudOutlineStroke;
        }

        public final void setCloudOutlineStroke(@NotNull BasicStroke basicStroke) {
            Intrinsics.checkNotNullParameter(basicStroke, "<set-?>");
            cloudOutlineStroke = basicStroke;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

