/*
 * Decompiled with CFR 0.152.
 */
package Game.Status;

import Engine.GameRunner;
import Engine.GameScene;
import Engine.GameWindow;
import Game.GameController;
import Game.Menu.MenuScene;
import Game.Purchase.PurchaseScene;
import Game.Status.StatusLine;
import Game.TerrainScene.BattleScene;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Weapon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"LGame/Status/StatusScene;", "LEngine/GameScene;", "lines", "", "LGame/Status/StatusLine;", "<init>", "(Ljava/util/List;)V", "getLines", "()Ljava/util/List;", "headerFont", "Ljava/awt/Font;", "getHeaderFont", "()Ljava/awt/Font;", "load", "", "keyPressed", "e", "Ljava/awt/event/KeyEvent;", "draw", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nStatusScene.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatusScene.kt\nGame/Status/StatusScene\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1#2:66\n774#3:67\n865#3,2:68\n774#3:70\n865#3,2:71\n*S KotlinDebug\n*F\n+ 1 StatusScene.kt\nGame/Status/StatusScene\n*L\n32#1:67\n32#1:68,2\n35#1:70\n35#1:71,2\n*E\n"})
public final class StatusScene
extends GameScene {
    @NotNull
    private final List<StatusLine> lines;
    @NotNull
    private final Font headerFont;

    public StatusScene(@NotNull List<StatusLine> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        super(new Color(182, 179, 173), MainKt.getGameResX(), MainKt.getGameResY());
        this.lines = lines;
        this.headerFont = new Font("Helvetica", 1, 22);
    }

    @NotNull
    public final List<StatusLine> getLines() {
        return this.lines;
    }

    @NotNull
    public final Font getHeaderFont() {
        return this.headerFont;
    }

    @Override
    public void load() {
        System.out.println((Object)"Loaded status screen");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void keyPressed(@NotNull KeyEvent e) {
        block5: {
            block6: {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable $this$filterTo$iv$iv2;
                block4: {
                    Intrinsics.checkNotNullParameter(e, "e");
                    super.keyPressed(e);
                    if (GameController.INSTANCE.getGamesPlayed() != GameController.INSTANCE.getGamesToPlay()) break block4;
                    this.unload();
                    Object object = MainKt.getGameWindow();
                    if (object == null || (object = ((GameWindow)object).getGameRunner()) == null) break block5;
                    ((GameRunner)object).setCurrentGameScene(new MenuScene());
                    break block5;
                }
                Iterator iterator2 = ((Iterable)Weapon.Companion.getAllWeapons().entrySet()).iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry it = (Map.Entry)iterator2.next();
                boolean $i$a$-minOf-StatusScene$keyPressed$cheapestWeaponPrice$22 = false;
                double d = ((Weapon)it.getValue()).getPurchasePrice();
                while (iterator2.hasNext()) {
                    Map.Entry it2 = (Map.Entry)iterator2.next();
                    $i$a$-minOf-StatusScene$keyPressed$cheapestWeaponPrice$1 = false;
                    double d2 = ((Weapon)it2.getValue()).getPurchasePrice();
                    d = Math.min(d, d2);
                }
                double cheapestWeaponPrice = d;
                Iterable $this$filter$iv2 = GameController.INSTANCE.getPlayers();
                boolean $i$f$filter = false;
                Iterable $i$a$-minOf-StatusScene$keyPressed$cheapestWeaponPrice$22 = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo22 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    Player it3 = (Player)element$iv$iv;
                    boolean bl = false;
                    if (!(it3.getMoney() > cheapestWeaponPrice)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List playersAbleToPurchase = (List)destination$iv$iv;
                if (playersAbleToPurchase.size() <= 0) break block6;
                Object object = MainKt.getGameWindow();
                if (object == null || (object = ((GameWindow)object).getGameRunner()) == null) break block5;
                $this$filterTo$iv$iv2 = GameController.INSTANCE.getPlayers();
                Object object2 = object;
                boolean $i$f$filter2 = false;
                void $i$f$filterTo22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Player it4 = (Player)element$iv$iv;
                    boolean bl = false;
                    if (!(it4.getMoney() > cheapestWeaponPrice)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                int n = 0;
                List list = (List)destination$iv$iv2;
                ((GameRunner)object2).setCurrentGameScene(new PurchaseScene(list, n));
                break block5;
            }
            Object object = MainKt.getGameWindow();
            if (object == null || (object = ((GameWindow)object).getGameRunner()) == null) break block5;
            ((GameRunner)object).setCurrentGameScene(new BattleScene(GameController.INSTANCE.getGroundSize(), null, false, 6, null));
        }
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        super.draw(g);
        g.setColor(Color.BLACK);
        g.setFont(this.headerFont);
        g.drawString("Round " + GameController.INSTANCE.getGamesPlayed() + " of " + GameController.INSTANCE.getGamesToPlay(), 250, 40);
        int y = 60;
        for (StatusLine l : this.lines) {
            l.draw(g, 100, y);
            y += 20;
        }
    }
}

