/*
 * Decompiled with CFR 0.152.
 */
package Game.Menu;

import Engine.GameObject2;
import Engine.GameRunner;
import Engine.GameSceneKt;
import Engine.GameWindow;
import Engine.IGameScene;
import Engine.Pos2D;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"LGame/Menu/Transition;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "length", "", "<init>", "(LEngine/IGameScene;D)V", "getLength", "()D", "transitionTicksLeft", "", "getTransitionTicksLeft", "()I", "setTransitionTicksLeft", "(I)V", "image", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "update", "", "offsets", "", "transitionTick", "", "transitionAlpha", "draw", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
public final class Transition
extends GameObject2 {
    private final double length;
    private int transitionTicksLeft;
    @Nullable
    private final BufferedImage image;
    @NotNull
    private final float[] offsets;
    private float transitionTick;
    private float transitionAlpha;

    public Transition(@NotNull IGameScene parent, double length) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        super(parent, new Pos2D(0.0, 0.0));
        this.length = length;
        this.transitionTicksLeft = (int)(GameRunner.Companion.getFps() * this.length);
        Object object = MainKt.getGameWindow();
        this.image = object != null && (object = ((GameWindow)object).getGameRunner()) != null && (object = ((GameRunner)object).getCurrentGameScene()) != null ? object.drawOnImage() : null;
        this.offsets = new float[4];
        this.transitionAlpha = 1.0f;
    }

    public /* synthetic */ Transition(IGameScene iGameScene, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.5;
        }
        this(iGameScene, d);
    }

    public final double getLength() {
        return this.length;
    }

    public final int getTransitionTicksLeft() {
        return this.transitionTicksLeft;
    }

    public final void setTransitionTicksLeft(int n) {
        this.transitionTicksLeft = n;
    }

    @Nullable
    public final BufferedImage getImage() {
        return this.image;
    }

    @Override
    public void update() {
        this.transitionTick += 1.0f;
        --this.transitionTicksLeft;
        if (this.transitionTicksLeft == 0) {
            this.getParent().remove(this);
        }
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        if (this.image == null) {
            return;
        }
        GameSceneKt.drawAsHud(g, arg_0 -> Transition.draw$lambda$0(this, g, arg_0));
    }

    private static final Unit draw$lambda$0(Transition this$0, Graphics2D $g, Graphics2D it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (this$0.transitionTicksLeft > 0) {
            float w = Math.max(0.9f, (float)((double)this$0.transitionTick / (this$0.length * (double)10)));
            Float[] floatArray = new Float[]{Float.valueOf(w), Float.valueOf(w), Float.valueOf(w), Float.valueOf(this$0.transitionAlpha)};
            $g.drawImage(this$0.image, new RescaleOp(ArraysKt.toFloatArray(floatArray), this$0.offsets, null), 0, 0);
            this$0.transitionAlpha = (float)this$0.transitionTicksLeft / (float)(GameRunner.Companion.getFps() * this$0.length);
        }
        return Unit.INSTANCE;
    }
}

