/*
 * Decompiled with CFR 0.152.
 */
package Game.Menu;

import Engine.GameObject2;
import Engine.GameRunner;
import Engine.GameScene;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.Helpers.FontHelper;
import Game.Menu.HersiTanksTextGameObjectKt;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0002J\b\u0010-\u001a\u00020+H\u0016J\u0010\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020+2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00102\u001a\u00020+2\u0006\u0010/\u001a\u000200H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"LGame/Menu/Letter;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "character", "", "position", "LEngine/Pos2D;", "font", "Ljava/awt/Font;", "biggerFont", "timeOffset", "", "flashPeriod", "freq", "", "<init>", "(LEngine/IGameScene;CLEngine/Pos2D;Ljava/awt/Font;Ljava/awt/Font;IIF)V", "getCharacter", "()C", "getFont", "()Ljava/awt/Font;", "getBiggerFont", "getTimeOffset", "()I", "setTimeOffset", "(I)V", "getFlashPeriod", "setFlashPeriod", "getFreq", "()F", "setFreq", "(F)V", "i", "color", "Ljava/awt/Color;", "flashColor", "goalPosition", "initialized", "", "velocity", "LEngine/Vec2D;", "initialize", "", "onFlash", "update", "drawFlash", "g", "Ljava/awt/Graphics2D;", "drawRegular", "draw", "TankWarsKotlin"})
public final class Letter
extends GameObject2 {
    private final char character;
    @Nullable
    private final Font font;
    @Nullable
    private final Font biggerFont;
    private int timeOffset;
    private int flashPeriod;
    private float freq;
    private int i;
    @NotNull
    private final Color color;
    @NotNull
    private Color flashColor;
    @NotNull
    private final Pos2D goalPosition;
    private boolean initialized;
    @NotNull
    private Vec2D velocity;

    public Letter(@NotNull IGameScene parent, char character, @NotNull Pos2D position, @Nullable Font font, @Nullable Font biggerFont, int timeOffset, int flashPeriod, float freq) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        super(parent, position);
        this.character = character;
        this.font = font;
        this.biggerFont = biggerFont;
        this.timeOffset = timeOffset;
        this.flashPeriod = flashPeriod;
        this.freq = freq;
        this.i = this.timeOffset;
        this.color = ((GameScene)parent).getColor();
        this.flashColor = new Color(40, 200, 80);
        this.goalPosition = Pos2D.copy$default(position, 0.0, 0.0, 3, null);
        this.velocity = new Vec2D(HersiTanksTextGameObjectKt.access$getRand$p().nextInt(0, 5), HersiTanksTextGameObjectKt.access$getRand$p().nextInt(-5, 5));
    }

    public /* synthetic */ Letter(IGameScene iGameScene, char c, Pos2D pos2D, Font font, Font font2, int n, int n2, float f, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            n = 0;
        }
        if ((n3 & 0x40) != 0) {
            n2 = 1;
        }
        if ((n3 & 0x80) != 0) {
            f = 1.0f;
        }
        this(iGameScene, c, pos2D, font, font2, n, n2, f);
    }

    public final char getCharacter() {
        return this.character;
    }

    @Nullable
    public final Font getFont() {
        return this.font;
    }

    @Nullable
    public final Font getBiggerFont() {
        return this.biggerFont;
    }

    public final int getTimeOffset() {
        return this.timeOffset;
    }

    public final void setTimeOffset(int n) {
        this.timeOffset = n;
    }

    public final int getFlashPeriod() {
        return this.flashPeriod;
    }

    public final void setFlashPeriod(int n) {
        this.flashPeriod = n;
    }

    public final float getFreq() {
        return this.freq;
    }

    public final void setFreq(float f) {
        this.freq = f;
    }

    private final void initialize() {
        this.getPosition().setX(0.0);
        this.getPosition().setY(HersiTanksTextGameObjectKt.access$getRand$p().nextDouble(this.getParent().getHeight()));
        this.initialized = true;
    }

    private final void onFlash() {
    }

    @Override
    public void update() {
        Vec2D diff;
        double mag;
        if (!this.initialized) {
            this.initialize();
        }
        ++this.i;
        if ((double)this.i >= GameRunner.Companion.getFps() / (double)this.freq) {
            this.i = 0;
            this.onFlash();
        }
        if ((mag = (diff = new Vec2D(this.getPosition(), this.goalPosition)).mag()) == 0.0) {
            return;
        }
        if (mag > 1.0) {
            diff = diff.normalized();
        }
        this.velocity = mag > 0.2 ? this.velocity.plus(diff) : diff;
        this.velocity = this.velocity.times(0.95);
        Pos2D pos2D = this.getPosition();
        pos2D.setX(pos2D.getX() + this.velocity.getX());
        pos2D = this.getPosition();
        pos2D.setY(pos2D.getY() + this.velocity.getY());
    }

    private final void drawFlash(Graphics2D g) {
        g.setFont(this.biggerFont);
        g.setColor(this.flashColor);
    }

    private final void drawRegular(Graphics2D g) {
        g.setFont(this.font);
        g.setColor(this.color);
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        if (g.getFont() == null) {
            return;
        }
        if (this.i <= this.flashPeriod) {
            this.drawFlash(g);
        } else {
            this.drawRegular(g);
        }
        FontHelper.INSTANCE.drawStringWithShadow(g, String.valueOf(this.character), (int)this.getPosition().getX(), (int)this.getPosition().getY());
    }
}

