/*
 * Decompiled with CFR 0.152.
 */
package Experimental.ManyBalls;

import Engine.ExtensionsKt;
import Engine.GameObject;
import Engine.IGameScene;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\fJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001fH\u0016J\b\u0010$\u001a\u00020\u001fH\u0016J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006'"}, d2={"LExperimental/ManyBalls/BallGameObject;", "LEngine/GameObject;", "parent", "LEngine/IGameScene;", "position", "Ljava/awt/geom/Point2D$Float;", "size", "", "color", "Ljava/awt/Color;", "<init>", "(LEngine/IGameScene;Ljava/awt/geom/Point2D$Float;FLjava/awt/Color;)V", "(LEngine/IGameScene;)V", "getPosition", "()Ljava/awt/geom/Point2D$Float;", "setPosition", "(Ljava/awt/geom/Point2D$Float;)V", "getSize", "()F", "getColor", "()Ljava/awt/Color;", "velocity", "getVelocity", "setVelocity", "life", "", "getLife", "()I", "setLife", "(I)V", "update", "", "draw", "g", "Ljava/awt/Graphics2D;", "unload", "onAdded", "onBeforeRemoved", "onAfterRemoved", "TankWarsKotlin"})
public final class BallGameObject
extends GameObject {
    @NotNull
    private final IGameScene parent;
    @NotNull
    private Point2D.Float position;
    private final float size;
    @NotNull
    private final Color color;
    @NotNull
    private Point2D.Float velocity;
    private int life;

    public BallGameObject(@NotNull IGameScene parent, @NotNull Point2D.Float position, float size, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(color, "color");
        super(parent, position);
        this.parent = parent;
        this.position = position;
        this.size = size;
        this.color = color;
        this.velocity = new Point2D.Float(0.0f, 0.0f);
        this.life = 10000;
    }

    @NotNull
    public final Point2D.Float getPosition() {
        return this.position;
    }

    public final void setPosition(@NotNull Point2D.Float float_) {
        Intrinsics.checkNotNullParameter(float_, "<set-?>");
        this.position = float_;
    }

    public final float getSize() {
        return this.size;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @NotNull
    public final Point2D.Float getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(@NotNull Point2D.Float float_) {
        Intrinsics.checkNotNullParameter(float_, "<set-?>");
        this.velocity = float_;
    }

    public final int getLife() {
        return this.life;
    }

    public final void setLife(int n) {
        this.life = n;
    }

    public BallGameObject(@NotNull IGameScene parent) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        this(parent, new Point2D.Float(Random.Default.nextInt(0, parent.getWidth()), Random.Default.nextInt(0, parent.getHeight())), (float)Random.Default.nextDouble(10.0, 40.0), new Color(Random.Default.nextInt(255), Random.Default.nextInt(255), Random.Default.nextInt(255)));
        this.velocity = new Point2D.Float(-10.0f + (float)20 * Random.Default.nextFloat(), -10.0f + (float)20 * Random.Default.nextFloat());
    }

    @Override
    public void update() {
        --this.life;
        if (this.life == 0) {
            this.parent.remove(this);
            return;
        }
        ExtensionsKt.translate(this.position, this.velocity);
        Point2D.Float float_ = this.velocity;
        float_.y += 1.0f;
        if (this.position.x - this.size / (float)2 < 0.0f) {
            this.position.x = this.size / (float)2;
            float_ = this.velocity;
            float_.x *= (float)-1;
        } else if (this.position.x + this.size / (float)2 > (float)this.parent.getWidth()) {
            this.position.x = (float)this.parent.getWidth() - this.size / (float)2;
            float_ = this.velocity;
            float_.x *= (float)-1;
        }
        if (this.position.y - this.size / (float)2 < 0.0f) {
            this.position.y = this.size / (float)2 + 1.0f;
            float_ = this.velocity;
            float_.y *= (float)-1;
        } else if (this.position.y + this.size / (float)2 > (float)this.parent.getHeight()) {
            this.position.y = (float)this.parent.getHeight() - this.size / (float)2;
            float_ = this.velocity;
            float_.y *= -0.8f;
            if (Math.abs(this.velocity.y) <= 3.0f) {
                this.velocity.y = 0.0f;
            }
            float_ = this.velocity;
            float_.x *= 0.8f;
        }
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(this.color);
        g.fillOval((int)(this.position.x - this.size / (float)2), (int)(this.position.y - this.size / (float)2), (int)this.size, (int)this.size);
    }

    @Override
    public void unload() {
    }

    @Override
    public void onAdded() {
    }

    @Override
    public void onBeforeRemoved() {
    }

    @Override
    public void onAfterRemoved() {
    }
}

