/*
 * Decompiled with CFR 0.152.
 */
package Experimental.CollisionBalls;

import Engine.GameObject2;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Experimental.CollisionBalls.CollisionBallsGameScene;
import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"LExperimental/CollisionBalls/CollisionBallsGameObject;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "velocity", "LEngine/Vec2D;", "size", "", "color", "Ljava/awt/Color;", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;LEngine/Vec2D;DLjava/awt/Color;)V", "getVelocity", "()LEngine/Vec2D;", "setVelocity", "(LEngine/Vec2D;)V", "getSize", "()D", "getColor", "()Ljava/awt/Color;", "update", "", "draw", "g", "Ljava/awt/Graphics2D;", "unload", "onAdded", "onBeforeRemoved", "onAfterRemoved", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nCollisionBalls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollisionBalls.kt\nExperimental/CollisionBalls/CollisionBallsGameObject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1863#2,2:116\n*S KotlinDebug\n*F\n+ 1 CollisionBalls.kt\nExperimental/CollisionBalls/CollisionBallsGameObject\n*L\n60#1:116,2\n*E\n"})
public final class CollisionBallsGameObject
extends GameObject2 {
    @NotNull
    private Vec2D velocity;
    private final double size;
    @NotNull
    private final Color color;

    public CollisionBallsGameObject(@NotNull IGameScene parent, @NotNull Pos2D position, @NotNull Vec2D velocity, double size, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(velocity, "velocity");
        Intrinsics.checkNotNullParameter(color, "color");
        super(parent, position);
        this.velocity = velocity;
        this.size = size;
        this.color = color;
    }

    @NotNull
    public final Vec2D getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(@NotNull Vec2D vec2D) {
        Intrinsics.checkNotNullParameter(vec2D, "<set-?>");
        this.velocity = vec2D;
    }

    public final double getSize() {
        return this.size;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @Override
    public void update() {
        Vec2D vec2D;
        IGameScene iGameScene = this.getParent();
        Intrinsics.checkNotNull(iGameScene, "null cannot be cast to non-null type Experimental.CollisionBalls.CollisionBallsGameScene");
        Iterable $this$forEach$iv = ((CollisionBallsGameScene)iGameScene).getBalls();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            double touchDistance;
            double distance;
            CollisionBallsGameObject it = (CollisionBallsGameObject)element$iv;
            boolean bl = false;
            if (it.getId() == this.getId() || !((distance = this.getPosition().plus(this.velocity).distance(it.getPosition().plus(it.velocity))) < (touchDistance = this.size / 2.0 + it.size / 2.0))) continue;
            Vec2D reflector = new Vec2D(this.getPosition(), it.getPosition()).hat().normalized();
            Vec2D newVelocity = this.velocity.reflect(reflector);
            this.velocity = newVelocity.plus(this.velocity.times(0.5));
            it.velocity = it.velocity.reflect(reflector).plus(it.velocity.times(0.5));
        }
        this.getPosition().translate(this.velocity);
        if (this.getPosition().getX() - this.size / (double)2 < 0.0) {
            this.getPosition().setX(this.size / (double)2);
            vec2D = this.velocity;
            vec2D.setX(vec2D.getX() * -0.9);
        } else if (this.getPosition().getX() + this.size / (double)2 > (double)this.getParent().getWidth()) {
            this.getPosition().setX((double)this.getParent().getWidth() - this.size / (double)2);
            vec2D = this.velocity;
            vec2D.setX(vec2D.getX() * -0.9);
        }
        if (this.getPosition().getY() - this.size / (double)2 < 0.0) {
            this.getPosition().setY(this.size / (double)2 + 1.0);
            vec2D = this.velocity;
            vec2D.setY(vec2D.getY() * -0.9);
        } else if (this.getPosition().getY() + this.size / (double)2 > (double)this.getParent().getHeight()) {
            this.getPosition().setY((double)this.getParent().getHeight() - this.size / (double)2);
            vec2D = this.velocity;
            vec2D.setY(vec2D.getY() * -0.9);
        } else {
            vec2D = this.velocity;
            vec2D.setY(vec2D.getY() + 0.1);
        }
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(this.color);
        g.fillOval((int)(this.getPosition().getX() - this.size / (double)2), (int)(this.getPosition().getY() - this.size / (double)2), (int)this.size, (int)this.size);
        g.setColor(Color.BLACK);
        Pos2D velocityEndpoint = this.getPosition().plus(this.velocity.times(10.0));
        g.drawLine((int)this.getPosition().getX(), (int)this.getPosition().getY(), (int)velocityEndpoint.getX(), (int)velocityEndpoint.getY());
    }

    @Override
    public void unload() {
    }

    @Override
    public void onAdded() {
    }

    @Override
    public void onBeforeRemoved() {
    }

    @Override
    public void onAfterRemoved() {
    }
}

