/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Engine.Vec2D;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0002J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0000J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u00192\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\bJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\bH\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000e\u00a8\u0006#"}, d2={"LEngine/Pos2D;", "", "x", "", "y", "<init>", "(DD)V", "xi", "", "yi", "(II)V", "getX", "()D", "setX", "(D)V", "getY", "setY", "translate", "", "vec", "LEngine/Vec2D;", "plus", "distance", "other", "stepsTo", "", "steps", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "", "TankWarsKotlin"})
public final class Pos2D {
    private double x;
    private double y;

    public Pos2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public Pos2D(int xi, int yi) {
        this((double)xi, (double)yi);
    }

    public final void translate(@NotNull Vec2D vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        this.x += vec.getX();
        this.y += vec.getY();
    }

    @NotNull
    public final Pos2D plus(@NotNull Vec2D vec) {
        Intrinsics.checkNotNullParameter(vec, "vec");
        return new Pos2D(this.x + vec.getX(), this.y + vec.getY());
    }

    public final double distance(@NotNull Pos2D other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new Vec2D(this, other).mag();
    }

    @NotNull
    public final List<Pos2D> stepsTo(@NotNull Pos2D other, int steps) {
        Intrinsics.checkNotNullParameter(other, "other");
        List result = new ArrayList();
        double dx = (other.x - this.x) / (double)steps;
        double dy = (other.y - this.y) / (double)steps;
        int i = 1;
        if (i <= steps) {
            while (true) {
                result.add(new Pos2D(this.x + (double)i * dx, this.y + (double)i * dy));
                if (i == steps) break;
                ++i;
            }
        }
        return result;
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Pos2D copy(double x, double y) {
        return new Pos2D(x, y);
    }

    public static /* synthetic */ Pos2D copy$default(Pos2D pos2D, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = pos2D.x;
        }
        if ((n & 2) != 0) {
            d2 = pos2D.y;
        }
        return pos2D.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Pos2D(x=" + this.x + ", y=" + this.y + ')';
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Pos2D)) {
            return false;
        }
        Pos2D pos2D = (Pos2D)other;
        if (Double.compare(this.x, pos2D.x) != 0) {
            return false;
        }
        return Double.compare(this.y, pos2D.y) == 0;
    }
}

