/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Engine.GameObjectDrawOrderComparator;
import Engine.IGameObject;
import Engine.IGameScene;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0012H\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0012H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J+\u0010$\u001a\u00020\u001f2!\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0004\u0012\u00020\u001f0&H\u0016J\u0006\u0010*\u001a\u00020\u001fJ\b\u0010+\u001a\u00020\u0005H\u0016J\b\u0010,\u001a\u00020\u001fH\u0016J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00105\u001a\u000206H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\f\"\u0004\b\u001c\u0010\u001dR*\u00100\u001a\u001e\u0012\f\u0012\n 3*\u0004\u0018\u00010202\u0012\f\u0012\n 3*\u0004\u0018\u0001040401X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"LEngine/GameScene;", "LEngine/IGameScene;", "color", "Ljava/awt/Color;", "width", "", "height", "<init>", "(Ljava/awt/Color;II)V", "getColor", "()Ljava/awt/Color;", "getWidth", "()I", "getHeight", "id", "getId", "gameObjects", "", "LEngine/IGameObject;", "gameObjectsByDrawOrder", "Ljava/util/SortedSet;", "getGameObjectsByDrawOrder$TankWarsKotlin", "()Ljava/util/SortedSet;", "gameObjectsToAdd", "gameObjectsToRemove", "", "i", "getI", "setI", "(I)V", "add", "", "gameObject", "remove", "hasGameObjectWithId", "", "forEachGameObject", "act", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "obj", "unload", "gameObjectsCount", "update", "draw", "g", "Ljava/awt/Graphics2D;", "renderingHints", "", "Ljava/awt/RenderingHints$Key;", "kotlin.jvm.PlatformType", "", "drawOnImage", "Ljava/awt/image/BufferedImage;", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nGameScene.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameScene.kt\nEngine/GameScene\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n216#2,2:111\n216#2,2:115\n216#2,2:117\n1863#3,2:113\n1863#3,2:119\n*S KotlinDebug\n*F\n+ 1 GameScene.kt\nEngine/GameScene\n*L\n48#1:111,2\n71#1:115,2\n77#1:117,2\n64#1:113,2\n86#1:119,2\n*E\n"})
public abstract class GameScene
implements IGameScene {
    @NotNull
    private final Color color;
    private final int width;
    private final int height;
    private final int id;
    @NotNull
    private final Map<Integer, IGameObject> gameObjects;
    @NotNull
    private final SortedSet<IGameObject> gameObjectsByDrawOrder;
    @NotNull
    private final Map<Integer, IGameObject> gameObjectsToAdd;
    @NotNull
    private final Set<Integer> gameObjectsToRemove;
    private int i;
    @NotNull
    private final Map<RenderingHints.Key, Object> renderingHints;

    public GameScene(@NotNull Color color, int width, int height) {
        Intrinsics.checkNotNullParameter(color, "color");
        this.color = color;
        this.width = width;
        this.height = height;
        this.id = MainKt.nextId();
        this.gameObjects = new LinkedHashMap();
        this.gameObjectsByDrawOrder = SetsKt.sortedSetOf(new GameObjectDrawOrderComparator(), new IGameObject[0]);
        this.gameObjectsToAdd = new LinkedHashMap();
        this.gameObjectsToRemove = new LinkedHashSet();
        this.renderingHints = MapsKt.mapOf(TuplesKt.to(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final SortedSet<IGameObject> getGameObjectsByDrawOrder$TankWarsKotlin() {
        return this.gameObjectsByDrawOrder;
    }

    public final int getI() {
        return this.i;
    }

    public final void setI(int n) {
        this.i = n;
    }

    @Override
    public void add(@NotNull IGameObject gameObject) {
        Intrinsics.checkNotNullParameter(gameObject, "gameObject");
        this.gameObjectsToAdd.put(gameObject.getId(), gameObject);
    }

    @Override
    public void remove(@NotNull IGameObject gameObject) {
        Intrinsics.checkNotNullParameter(gameObject, "gameObject");
        this.gameObjectsToRemove.add(gameObject.getId());
    }

    @Override
    public boolean hasGameObjectWithId(int id) {
        return this.gameObjects.containsKey(id) && !this.gameObjectsToRemove.contains(id);
    }

    @Override
    public void forEachGameObject(@NotNull Function1<? super IGameObject, Unit> act) {
        Intrinsics.checkNotNullParameter(act, "act");
        Map<Integer, IGameObject> $this$forEach$iv = this.gameObjects;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, IGameObject>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Integer, IGameObject> element$iv;
            Map.Entry<Integer, IGameObject> it = element$iv = iterator2.next();
            boolean bl = false;
            act.invoke(it.getValue());
        }
    }

    @Override
    public final void unload() {
        this.forEachGameObject(arg_0 -> GameScene.unload$lambda$0(this, arg_0));
        if (this.gameObjectsToRemove.size() < this.gameObjects.size()) {
            System.out.println((Object)("GameScene is unloaded, but its " + this.gameObjects.size() + " objects are not removed."));
        }
    }

    @Override
    public int gameObjectsCount() {
        return this.gameObjects.size();
    }

    @Override
    public void update() {
        Object element$iv;
        Map<Integer, IGameObject> $this$forEach$iv = this.gameObjectsToRemove;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            IGameObject iGameObject = this.gameObjects.get(it);
            if (iGameObject != null) {
                iGameObject.onBeforeRemoved();
            }
            this.gameObjectsByDrawOrder.remove(this.gameObjects.get(it));
            IGameObject iGameObject2 = this.gameObjects.remove(it);
            if (iGameObject2 == null) continue;
            iGameObject2.onAfterRemoved();
        }
        this.gameObjects.putAll(this.gameObjectsToAdd);
        this.gameObjectsByDrawOrder.addAll(this.gameObjectsToAdd.values());
        $this$forEach$iv = this.gameObjectsToAdd;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object it = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            ((IGameObject)it.getValue()).onAdded();
        }
        this.gameObjectsToRemove.clear();
        this.gameObjectsToAdd.clear();
        $this$forEach$iv = this.gameObjects;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object it = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            ((IGameObject)it.getValue()).update();
        }
        ++this.i;
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(this.color);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Iterable $this$forEach$iv = this.gameObjectsByDrawOrder;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IGameObject it = (IGameObject)element$iv;
            boolean bl = false;
            it.draw(g);
        }
    }

    @Override
    @NotNull
    public BufferedImage drawOnImage() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics graphics = image.getGraphics();
        Intrinsics.checkNotNull(graphics, "null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D graphics2 = (Graphics2D)graphics;
        graphics2.setRenderingHints(this.renderingHints);
        this.draw(graphics2);
        return image;
    }

    private static final Unit unload$lambda$0(GameScene this$0, IGameObject it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.unload();
        this$0.remove(it);
        return Unit.INSTANCE;
    }
}

