/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.GameObject2;
import Engine.GameRunner;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.GameController;
import Game.TerrainScene.BattleScene;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.ProjectileTrail;
import Game.TerrainScene.RasterTerrain;
import Game.TerrainScene.Tank;
import Game.TerrainScene.Weapon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 :2\u00020\u0001:\u0001:B`\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012%\b\u0002\u0010\u000e\u001a\u001f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\b\u0010/\u001a\u00020\u0013H\u0016J\u0010\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\u0005H\u0002J\u0010\u00102\u001a\u00020\r2\u0006\u00101\u001a\u00020\u0005H\u0002J\u0018\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005H\u0002J\u0006\u00106\u001a\u00020\u0013J\u0010\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u000209H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR.\u0010\u000e\u001a\u001f\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001b\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001b\"\u0004\b(\u0010%R\u001c\u0010)\u001a\u0004\u0018\u00010*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006;"}, d2={"LGame/TerrainScene/Projectile;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "velocity", "LEngine/Vec2D;", "weaponId", "", "trailColor", "Ljava/awt/Color;", "simulated", "", "onExplode", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "pos", "", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;LEngine/Vec2D;ILjava/awt/Color;ZLkotlin/jvm/functions/Function1;)V", "getVelocity", "()LEngine/Vec2D;", "setVelocity", "(LEngine/Vec2D;)V", "getWeaponId", "()I", "getTrailColor", "()Ljava/awt/Color;", "getSimulated", "()Z", "getOnExplode", "()Lkotlin/jvm/functions/Function1;", "jumps", "getJumps", "setJumps", "(I)V", "size", "getSize", "setSize", "terrain", "LGame/TerrainScene/RasterTerrain;", "getTerrain", "()LGame/TerrainScene/RasterTerrain;", "setTerrain", "(LGame/TerrainScene/RasterTerrain;)V", "update", "tankAt", "p", "terrainAt", "findExactTerrainIntersection", "oldPos", "newPos", "explode", "draw", "g", "Ljava/awt/Graphics2D;", "Companion", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nProjectile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Projectile.kt\nGame/TerrainScene/Projectile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n1863#3,2:158\n*S KotlinDebug\n*F\n+ 1 Projectile.kt\nGame/TerrainScene/Projectile\n*L\n67#1:158,2\n*E\n"})
public class Projectile
extends GameObject2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vec2D velocity;
    private final int weaponId;
    @NotNull
    private final Color trailColor;
    private final boolean simulated;
    @Nullable
    private final Function1<Pos2D, Unit> onExplode;
    private int jumps;
    private int size;
    @Nullable
    private RasterTerrain terrain;
    @NotNull
    private static final Set<Projectile> activeProjectiles = new LinkedHashSet();
    private static final double gravity = 0.25 * ((double)60 / GameRunner.Companion.getFps());
    @NotNull
    private static final BasicStroke fatStroke = new BasicStroke(3.0f, 1, 1);
    @NotNull
    private static final BasicStroke thinStroke = new BasicStroke(1.0f, 1, 1);

    public Projectile(@NotNull IGameScene parent, @NotNull Pos2D position, @NotNull Vec2D velocity, int weaponId, @NotNull Color trailColor, boolean simulated, @Nullable Function1<? super Pos2D, Unit> onExplode) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(velocity, "velocity");
        Intrinsics.checkNotNullParameter(trailColor, "trailColor");
        super(parent, position);
        this.velocity = velocity;
        this.weaponId = weaponId;
        this.trailColor = trailColor;
        this.simulated = simulated;
        this.onExplode = onExplode;
        this.size = 3;
        BattleScene battleScene = parent instanceof BattleScene ? (BattleScene)parent : null;
        this.terrain = battleScene != null ? battleScene.getRasterTerrain() : null;
        if (!this.simulated) {
            GameController.INSTANCE.setProjectilesFlying(GameController.INSTANCE.getProjectilesFlying() + 1);
            activeProjectiles.add(this);
        }
    }

    public /* synthetic */ Projectile(IGameScene iGameScene, Pos2D pos2D, Vec2D vec2D, int n, Color color, boolean bl, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        if ((n2 & 0x40) != 0) {
            function1 = null;
        }
        this(iGameScene, pos2D, vec2D, n, color, bl, function1);
    }

    @NotNull
    public final Vec2D getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(@NotNull Vec2D vec2D) {
        Intrinsics.checkNotNullParameter(vec2D, "<set-?>");
        this.velocity = vec2D;
    }

    public final int getWeaponId() {
        return this.weaponId;
    }

    @NotNull
    public final Color getTrailColor() {
        return this.trailColor;
    }

    public final boolean getSimulated() {
        return this.simulated;
    }

    @Nullable
    public final Function1<Pos2D, Unit> getOnExplode() {
        return this.onExplode;
    }

    public final int getJumps() {
        return this.jumps;
    }

    public final void setJumps(int n) {
        this.jumps = n;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    @Nullable
    public final RasterTerrain getTerrain() {
        return this.terrain;
    }

    public final void setTerrain(@Nullable RasterTerrain rasterTerrain) {
        this.terrain = rasterTerrain;
    }

    @Override
    public void update() {
        Pos2D oldPos = Pos2D.copy$default(this.getPosition(), 0.0, 0.0, 3, null);
        Object object = this.getPosition();
        ((Pos2D)object).setX(((Pos2D)object).getX() + this.velocity.getX() * (60.0 / GameRunner.Companion.getFps()));
        object = this.getPosition();
        ((Pos2D)object).setY(((Pos2D)object).getY() + this.velocity.getY() * (60.0 / GameRunner.Companion.getFps()));
        object = this.velocity;
        ((Vec2D)object).setX(((Vec2D)object).getX() + GameController.INSTANCE.getWind() * (1.0 / GameRunner.Companion.getFps()));
        object = this.velocity;
        ((Vec2D)object).setY(((Vec2D)object).getY() + gravity);
        if (this.getPosition().getY() > (double)this.getParent().getHeight()) {
            this.explode();
        } else {
            RasterTerrain rasterTerrain = this.terrain;
            if (rasterTerrain != null) {
                RasterTerrain terrain = rasterTerrain;
                boolean bl = false;
                if (this.getPosition().getX() >= terrain.getPosition().getX() && this.getPosition().getX() < (double)terrain.getRasterImage().getWidth() && this.getPosition().getY() >= 0.0) {
                    Object v1;
                    block11: {
                        Iterable iterable = oldPos.stepsTo(this.getPosition(), 10);
                        for (Object object2 : iterable) {
                            Pos2D p = (Pos2D)object2;
                            boolean bl2 = false;
                            if (!this.terrainAt(p)) continue;
                            v1 = object2;
                            break block11;
                        }
                        v1 = null;
                    }
                    Pos2D posWithTerrainHit = v1;
                    if (posWithTerrainHit != null) {
                        this.setPosition(this.findExactTerrainIntersection(oldPos, this.getPosition()));
                        this.explode();
                    } else {
                        Object v2;
                        block12: {
                            Object object2;
                            Iterable iterable = oldPos.stepsTo(this.getPosition(), 10);
                            object2 = iterable.iterator();
                            while (object2.hasNext()) {
                                Object e = object2.next();
                                Pos2D p = (Pos2D)e;
                                boolean bl3 = false;
                                if (!this.tankAt(p)) continue;
                                v2 = e;
                                break block12;
                            }
                            v2 = null;
                        }
                        Pos2D posWithTankHit = v2;
                        if (posWithTankHit != null) {
                            this.getPosition().setX(posWithTankHit.getX());
                            this.getPosition().setY(posWithTankHit.getY());
                            this.explode();
                        }
                    }
                }
            }
        }
        if (!this.simulated) {
            List<Pos2D> newSmokes = oldPos.stepsTo(this.getPosition(), 10);
            Iterable $this$forEach$iv = newSmokes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pos2D it = (Pos2D)element$iv;
                boolean bl = false;
                this.getParent().add(new ProjectileTrail(this.getParent(), it, this.trailColor));
            }
        }
    }

    private final boolean tankAt(Pos2D p) {
        for (Player player : GameController.INSTANCE.getPlayers()) {
            if (!player.getPlaying()) continue;
            Tank tank = player.getTank();
            Pos2D tankPos = tank != null ? tank.getPosition() : null;
            Tank tank2 = player.getTank();
            if (tankPos == null || tank2 == null || !(p.distance(tankPos) < (double)(tank2.getSize() / 2))) continue;
            return true;
        }
        return false;
    }

    private final boolean terrainAt(Pos2D p) {
        RasterTerrain rasterTerrain = this.terrain;
        if (rasterTerrain != null) {
            RasterTerrain terrain = rasterTerrain;
            boolean bl = false;
            if (p.getX() < 0.0 || p.getX() >= (double)terrain.getRasterImage().getWidth()) {
                return false;
            }
            if (p.getY() < 0.0 || p.getY() >= (double)terrain.getRasterImage().getHeight()) {
                return false;
            }
            return terrain.getRasterImage().getRGB((int)p.getX(), (int)p.getY()) != 0;
        }
        return false;
    }

    private final Pos2D findExactTerrainIntersection(Pos2D oldPos, Pos2D newPos) {
        boolean done = false;
        Pos2D p0 = Pos2D.copy$default(oldPos, 0.0, 0.0, 3, null);
        Pos2D p1 = Pos2D.copy$default(newPos, 0.0, 0.0, 3, null);
        Pos2D pHalf = Pos2D.copy$default(newPos, 0.0, 0.0, 3, null);
        pHalf.setX(p0.getX() + (p1.getX() - p0.getX()) / 2.0);
        pHalf.setY(p0.getY() + (p1.getY() - p0.getY()) / 2.0);
        while (!done) {
            if (this.terrainAt(pHalf)) {
                p1.setX(pHalf.getX());
                p1.setY(pHalf.getY());
                pHalf.setX(p0.getX() + (p1.getX() - p0.getX()) / 2.0);
                pHalf.setY(p0.getY() + (p1.getY() - p0.getY()) / 2.0);
            } else {
                p0.setX(pHalf.getX());
                p0.setY(pHalf.getY());
                pHalf.setX(p0.getX() + (p1.getX() - p0.getX()) / 2.0);
                pHalf.setY(p0.getY() + (p1.getY() - p0.getY()) / 2.0);
            }
            double dist = p0.distance(p1);
            done = dist < 2.0;
        }
        return p0;
    }

    public final void explode() {
        if (this.onExplode == null) {
            RasterTerrain rasterTerrain = this.terrain;
            if (rasterTerrain != null) {
                RasterTerrain terrain = rasterTerrain;
                boolean bl = false;
                Weapon weapon = Weapon.Companion.getAllWeapons().get(this.weaponId);
                if (weapon != null) {
                    weapon.onExplode(terrain, this.getParent(), this);
                }
            }
        } else {
            this.onExplode.invoke(this.getPosition());
        }
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        Pos2D p0 = this.getPosition().plus(this.velocity);
        Pos2D p1 = this.getPosition().plus(this.velocity.times(-1.0));
        g.setStroke(fatStroke);
        g.setColor(Color.BLACK);
        g.drawLine((int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY());
        g.setStroke(thinStroke);
        g.setColor(Color.LIGHT_GRAY);
        g.drawLine((int)p0.getX(), (int)p0.getY(), (int)p1.getX(), (int)p1.getY());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"LGame/TerrainScene/Projectile$Companion;", "", "<init>", "()V", "activeProjectiles", "", "LGame/TerrainScene/Projectile;", "getActiveProjectiles", "()Ljava/util/Set;", "gravity", "", "getGravity", "()D", "fatStroke", "Ljava/awt/BasicStroke;", "thinStroke", "TankWarsKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Projectile> getActiveProjectiles() {
            return activeProjectiles;
        }

        public final double getGravity() {
            return gravity;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

