/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene.Player;

import Engine.GameRunner;
import Engine.GameWindow;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Projectile;
import Game.TerrainScene.Tank;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011\u00a8\u0006\u001c"}, d2={"LGame/TerrainScene/Player/PlayerDecision;", "", "player", "LGame/TerrainScene/Player/Player;", "angle", "", "power", "weaponId", "<init>", "(LGame/TerrainScene/Player/Player;III)V", "getPlayer", "()LGame/TerrainScene/Player/Player;", "setPlayer", "(LGame/TerrainScene/Player/Player;)V", "getAngle", "()I", "setAngle", "(I)V", "getPower", "setPower", "getWeaponId", "setWeaponId", "isValid", "", "getSimulatedExplosionLocation", "LEngine/Pos2D;", "tank", "LGame/TerrainScene/Tank;", "TankWarsKotlin"})
public final class PlayerDecision {
    @NotNull
    private Player player;
    private int angle;
    private int power;
    private int weaponId;

    public PlayerDecision(@NotNull Player player, int angle, int power, int weaponId) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.player = player;
        this.angle = angle;
        this.power = power;
        this.weaponId = weaponId;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final void setPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "<set-?>");
        this.player = player;
    }

    public final int getAngle() {
        return this.angle;
    }

    public final void setAngle(int n) {
        this.angle = n;
    }

    public final int getPower() {
        return this.power;
    }

    public final void setPower(int n) {
        this.power = n;
    }

    public final int getWeaponId() {
        return this.weaponId;
    }

    public final void setWeaponId(int n) {
        this.weaponId = n;
    }

    public final boolean isValid() {
        Integer n = this.player.getWeaponry().get(this.weaponId);
        return (n != null ? n : 0) > 0;
    }

    @NotNull
    public final Pos2D getSimulatedExplosionLocation(@NotNull Tank tank) {
        Pos2D explosionPosition;
        block1: {
            Intrinsics.checkNotNullParameter(tank, "tank");
            Pos2D pos = Pos2D.copy$default(tank.getPosition(), 0.0, 0.0, 3, null);
            Ref.BooleanRef done = new Ref.BooleanRef();
            explosionPosition = new Pos2D(0.0, 0.0);
            Object object = MainKt.getGameWindow();
            if (object == null || (object = ((GameWindow)object).getGameRunner()) == null || (object = ((GameRunner)object).getCurrentGameScene()) == null) break block1;
            Object gameScene = object;
            boolean bl = false;
            int canonX = (int)(tank.getPosition().getX() + (double)tank.getSize() * Math.cos(Math.PI * (double)this.angle / 180.0));
            int canonY = (int)(tank.getPosition().getY() - (double)tank.getSize() * Math.sin(Math.PI * (double)this.angle / 180.0));
            Vec2D velocity = new Vec2D(Pos2D.copy$default(pos, 0.0, 0.0, 3, null), new Pos2D((double)canonX, (double)canonY)).times((double)this.power / 400.0);
            Pos2D pos2D = new Pos2D((double)canonX, (double)canonY);
            Color color = Color.BLACK;
            Intrinsics.checkNotNullExpressionValue(color, "BLACK");
            Projectile projectile = new Projectile((IGameScene)gameScene, pos2D, velocity, 0, color, true, arg_0 -> PlayerDecision.getSimulatedExplosionLocation$lambda$1$lambda$0(explosionPosition, done, arg_0));
            while (!done.element) {
                projectile.update();
            }
        }
        return explosionPosition;
    }

    private static final Unit getSimulatedExplosionLocation$lambda$1$lambda$0(Pos2D $explosionPosition, Ref.BooleanRef $done, Pos2D position) {
        Intrinsics.checkNotNullParameter(position, "position");
        $explosionPosition.setX(position.getX());
        $explosionPosition.setY(position.getY());
        $done.element = true;
        return Unit.INSTANCE;
    }
}

