/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.GameController;
import Game.TerrainScene.Explosion;
import Game.TerrainScene.MidairExplodingProjectile;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Projectile;
import Game.TerrainScene.RasterTerrain;
import Game.TerrainScene.Weapon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"LGame/TerrainScene/MirvWeapon;", "LGame/TerrainScene/Weapon;", "id", "", "name", "", "purchasePrice", "", "purchaseQuantity", "subProjectiles", "<init>", "(ILjava/lang/String;DII)V", "getSubProjectiles", "()I", "drawIcon", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "onExplode", "terrain", "LGame/TerrainScene/RasterTerrain;", "gameScene", "LEngine/IGameScene;", "projectile", "LGame/TerrainScene/Projectile;", "getProjectile", "pos", "LEngine/Pos2D;", "velocity", "LEngine/Vec2D;", "TankWarsKotlin"})
public final class MirvWeapon
extends Weapon {
    private final int subProjectiles;

    public MirvWeapon(int id, @NotNull String name, double purchasePrice, int purchaseQuantity, int subProjectiles) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(id, name, purchasePrice, purchaseQuantity);
        this.subProjectiles = subProjectiles;
    }

    public final int getSubProjectiles() {
        return this.subProjectiles;
    }

    @Override
    public void drawIcon(@NotNull Graphics2D g, int x, int y) {
        Intrinsics.checkNotNullParameter(g, "g");
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f, 1, 1));
        g.drawArc(x + 10, y + 16, 12, 20, -180, -90);
        g.drawArc(x + 6, y + 10, 8, 12, 0, 180);
        g.drawArc(x + 16, y + 10, 8, 12, 180, -180);
        g.drawArc(x + 6, y + 6, 8, 16, 90, -90);
        if (this.subProjectiles > 3) {
            g.drawArc(x + 16, y + 6, 8, 16, 180, -90);
            g.drawArc(x + 14, y + 16, 8, 8, 90, -90);
        }
        if (this.subProjectiles > 5) {
            g.drawArc(x + 8, y + 16, 6, 4, 180, -180);
            g.drawArc(x + 14, y + 18, 4, 12, 90, -90);
        }
        g.setStroke(oldStroke);
    }

    @Override
    public void onExplode(@NotNull RasterTerrain terrain, @NotNull IGameScene gameScene, @NotNull Projectile projectile) {
        Intrinsics.checkNotNullParameter(terrain, "terrain");
        Intrinsics.checkNotNullParameter(gameScene, "gameScene");
        Intrinsics.checkNotNullParameter(projectile, "projectile");
        gameScene.add(new Explosion(gameScene, projectile.getPosition(), 30, 15, () -> MirvWeapon.onExplode$lambda$0(terrain)));
        gameScene.remove(projectile);
        GameController.INSTANCE.setProjectilesFlying(GameController.INSTANCE.getProjectilesFlying() - 1);
        Projectile.Companion.getActiveProjectiles().remove(projectile);
        int i = 1;
        int n = this.subProjectiles;
        if (i <= n) {
            while (true) {
                Vec2D velocity = new Vec2D(Random.Default.nextDouble(-5.0, 5.0), -3.0);
                Pos2D pos2D = Pos2D.copy$default(projectile.getPosition(), 0.0, 0.0, 3, null);
                Object object = GameController.INSTANCE.getCurrentPlayer();
                if (object == null || (object = ((Player)object).getColor()) == null) {
                    object = Color.WHITE;
                }
                Object object2 = object;
                Intrinsics.checkNotNull(object2);
                Projectile p = new Projectile(gameScene, pos2D, velocity, 3, (Color)object2, false, null, 96, null);
                gameScene.add(p);
                if (i == n) break;
                ++i;
            }
        }
    }

    @Override
    @NotNull
    public Projectile getProjectile(@NotNull IGameScene gameScene, @NotNull Pos2D pos, @NotNull Vec2D velocity) {
        Intrinsics.checkNotNullParameter(gameScene, "gameScene");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(velocity, "velocity");
        int n = this.getId();
        Object object = GameController.INSTANCE.getCurrentPlayer();
        if (object == null || (object = ((Player)object).getColor()) == null) {
            object = Color.WHITE;
        }
        Object object2 = object;
        Intrinsics.checkNotNull(object2);
        return new MidairExplodingProjectile(gameScene, pos, velocity, n, (Color)object2);
    }

    private static final Unit onExplode$lambda$0(RasterTerrain $terrain) {
        $terrain.setCrumble(true);
        return Unit.INSTANCE;
    }
}

