/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.GameRunner;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.TerrainScene.Projectile;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"LGame/TerrainScene/MidairExplodingProjectile;", "LGame/TerrainScene/Projectile;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "velocity", "LEngine/Vec2D;", "weaponId", "", "trailColor", "Ljava/awt/Color;", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;LEngine/Vec2D;ILjava/awt/Color;)V", "ticks", "getTicks", "()I", "setTicks", "(I)V", "minTicks", "", "getMinTicks", "()D", "update", "", "TankWarsKotlin"})
public final class MidairExplodingProjectile
extends Projectile {
    private int ticks;
    private final double minTicks;

    public MidairExplodingProjectile(@NotNull IGameScene parent, @NotNull Pos2D position, @NotNull Vec2D velocity, int weaponId, @NotNull Color trailColor) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(velocity, "velocity");
        Intrinsics.checkNotNullParameter(trailColor, "trailColor");
        super(parent, position, velocity, weaponId, trailColor, false, null, 96, null);
        this.minTicks = 0.5 * GameRunner.Companion.getFps();
    }

    public final int getTicks() {
        return this.ticks;
    }

    public final void setTicks(int n) {
        this.ticks = n;
    }

    public final double getMinTicks() {
        return this.minTicks;
    }

    @Override
    public void update() {
        super.update();
        ++this.ticks;
        if ((double)this.ticks > this.minTicks && this.getVelocity().getY() >= 0.0) {
            this.getParent().remove(this);
            this.explode();
        }
    }
}

