/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.Audio.AudioHelper;
import Engine.ExtensionsKt;
import Engine.GameObject2;
import Engine.IGameScene;
import Engine.Pos2D;
import Game.GameController;
import Game.TerrainScene.BattleScene;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Tank;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020)H\u0016J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u0019H\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u0019H\u0002J\u0010\u0010/\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"LGame/TerrainScene/ChargeIndicator;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "tank", "LGame/TerrainScene/Tank;", "destinationPower", "", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;LGame/TerrainScene/Tank;Ljava/lang/Integer;)V", "getTank", "()LGame/TerrainScene/Tank;", "getDestinationPower", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "lighterColor", "charge", "", "getCharge", "()D", "setCharge", "(D)V", "endpointX", "endpointY", "stroke", "Ljava/awt/BasicStroke;", "sound", "", "playFizzleSound", "", "tick", "modulus", "onAdded", "", "onAfterRemoved", "update", "getEndpointX", "angle", "getEndpointY", "draw", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
public final class ChargeIndicator
extends GameObject2 {
    @NotNull
    private final Tank tank;
    @Nullable
    private final Integer destinationPower;
    @NotNull
    private Color color;
    @NotNull
    private Color lighterColor;
    private double charge;
    private int endpointX;
    private int endpointY;
    @NotNull
    private final BasicStroke stroke;
    @NotNull
    private String sound;
    private boolean playFizzleSound;
    private int tick;
    private int modulus;

    public ChargeIndicator(@NotNull IGameScene parent, @NotNull Pos2D position, @NotNull Tank tank, @Nullable Integer destinationPower) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(tank, "tank");
        super(parent, position);
        this.tank = tank;
        this.destinationPower = destinationPower;
        this.color = this.tank.getColor();
        this.lighterColor = ExtensionsKt.lighter(this.color, 100);
        this.stroke = new BasicStroke(1.0f, 1, 1);
        this.sound = "charge";
        this.modulus = 20;
    }

    public /* synthetic */ ChargeIndicator(IGameScene iGameScene, Pos2D pos2D, Tank tank, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        this(iGameScene, pos2D, tank, n);
    }

    @NotNull
    public final Tank getTank() {
        return this.tank;
    }

    @Nullable
    public final Integer getDestinationPower() {
        return this.destinationPower;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.color = color;
    }

    public final double getCharge() {
        return this.charge;
    }

    public final void setCharge(double d) {
        this.charge = d;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        AudioHelper.INSTANCE.play(this.sound);
    }

    @Override
    public void onAfterRemoved() {
        super.onAfterRemoved();
        this.tank.setPower((int)this.charge);
        Player player = GameController.INSTANCE.getCurrentPlayer();
        if (player != null) {
            player.fire();
        }
        IGameScene iGameScene = this.getParent();
        BattleScene battleScene = iGameScene instanceof BattleScene ? (BattleScene)iGameScene : null;
        if (battleScene != null) {
            BattleScene it = battleScene;
            boolean bl = false;
            it.setUpdatePlayersTurnOnNextPossibleOccasion(true);
        }
        AudioHelper.INSTANCE.stop(this.sound);
    }

    @Override
    public void update() {
        this.charge = Math.min(this.charge + 2.6, 1000.0);
        this.tank.setPower((int)this.charge);
        this.endpointX = (int)this.getEndpointX(this.tank.getAngle());
        this.endpointY = (int)this.getEndpointY(this.tank.getAngle());
        if (this.playFizzleSound) {
            if (this.tick % this.modulus == 0) {
                AudioHelper.INSTANCE.stop("fizzle");
                AudioHelper.INSTANCE.play("fizzle");
                if (this.modulus > 5) {
                    --this.modulus;
                }
            }
            ++this.tick;
        }
    }

    private final double getEndpointX(double angle) {
        return this.getPosition().getX() + this.charge * 0.2 * Math.cos(Math.PI * angle / 180.0);
    }

    private final double getEndpointY(double angle) {
        return this.getPosition().getY() - this.charge * 0.2 * Math.sin(Math.PI * angle / 180.0);
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(this.lighterColor);
        g.setStroke(this.stroke);
        Integer[] integerArray = new Integer[]{(int)this.getPosition().getX(), (int)this.getEndpointX(this.tank.getAngle() - (double)10), (int)this.getEndpointX(this.tank.getAngle() + (double)10)};
        int[] xs = ArraysKt.toIntArray(integerArray);
        Integer[] integerArray2 = new Integer[]{(int)this.getPosition().getY(), (int)this.getEndpointY(this.tank.getAngle() - (double)10), (int)this.getEndpointY(this.tank.getAngle() + (double)10)};
        int[] ys = ArraysKt.toIntArray(integerArray2);
        g.fillPolygon(xs, ys, 3);
        g.setColor(this.color);
        g.drawPolygon(xs, ys, 3);
    }
}

