/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Engine.GameRunner;
import Engine.GameWindowKt;
import Engine.IGameScene;
import Engine.IGameWindow;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.VolatileImage;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010%\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010)\u001a\u00020&J\b\u0010*\u001a\u00020\u000bH\u0002J\u0010\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u000bH\u0002J\b\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020&2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u00100\u001a\u00020&H\u0016J\u0018\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\tH\u0016J\b\u00104\u001a\u00020.H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"LEngine/GameWindow;", "Ljava/lang/Runnable;", "LEngine/IGameWindow;", "width", "", "height", "title", "", "gameScene", "LEngine/IGameScene;", "fullScreen", "", "<init>", "(IILjava/lang/String;LEngine/IGameScene;Z)V", "getWidth", "()I", "getHeight", "panel", "Ljavax/swing/JPanel;", "frame", "Ljavax/swing/JFrame;", "getFrame", "()Ljavax/swing/JFrame;", "setFrame", "(Ljavax/swing/JFrame;)V", "renderingHints", "", "Ljava/awt/RenderingHints$Key;", "", "gameRunner", "LEngine/GameRunner;", "getGameRunner", "()LEngine/GameRunner;", "setGameRunner", "(LEngine/GameRunner;)V", "scale", "", "initFrameAndPanel", "", "image", "Ljava/awt/image/VolatileImage;", "toggleFullScreen", "isImageValid", "createNewImage", "isFullScreen", "createGraphics", "Ljava/awt/Graphics2D;", "render", "run", "onGameSceneChanged", "oldGameScene", "newGameScene", "getGraphics2D", "TankWarsKotlin"})
public class GameWindow
implements Runnable,
IGameWindow {
    private final int width;
    private final int height;
    @NotNull
    private final IGameScene gameScene;
    private boolean fullScreen;
    @NotNull
    private JPanel panel;
    @NotNull
    private JFrame frame;
    @NotNull
    private final Map<RenderingHints.Key, Object> renderingHints;
    @NotNull
    private GameRunner gameRunner;
    private double scale;
    @NotNull
    private VolatileImage image;

    public GameWindow(int width, int height, @NotNull String title, @NotNull IGameScene gameScene, boolean fullScreen) {
        Intrinsics.checkNotNullParameter(title, "title");
        Intrinsics.checkNotNullParameter(gameScene, "gameScene");
        this.width = width;
        this.height = height;
        this.gameScene = gameScene;
        this.fullScreen = fullScreen;
        this.panel = new JPanel();
        this.frame = new JFrame();
        this.renderingHints = MapsKt.mapOf(TuplesKt.to(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        this.gameRunner = new GameRunner(this, this.gameScene);
        this.scale = 1.0;
        this.initFrameAndPanel(this.fullScreen);
        VolatileImage volatileImage = this.panel.createVolatileImage((int)GameWindowKt.getScreenWidth(), (int)GameWindowKt.getScreenHeight());
        Intrinsics.checkNotNullExpressionValue(volatileImage, "createVolatileImage(...)");
        this.image = volatileImage;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final JFrame getFrame() {
        return this.frame;
    }

    public final void setFrame(@NotNull JFrame jFrame) {
        Intrinsics.checkNotNullParameter(jFrame, "<set-?>");
        this.frame = jFrame;
    }

    @NotNull
    public final GameRunner getGameRunner() {
        return this.gameRunner;
    }

    public final void setGameRunner(@NotNull GameRunner gameRunner) {
        Intrinsics.checkNotNullParameter(gameRunner, "<set-?>");
        this.gameRunner = gameRunner;
    }

    private final void initFrameAndPanel(boolean fullScreen) {
        this.panel.setPreferredSize(new Dimension(this.width, this.height));
        this.panel.setSize(new Dimension(this.width, this.height));
        this.panel.setFocusable(true);
        this.panel.requestFocusInWindow();
        this.frame.setDefaultCloseOperation(3);
        if (fullScreen) {
            this.frame.setUndecorated(true);
            GraphicsEnvironment graphicsEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = graphicsEnv.getDefaultScreenDevice();
            if (device.isFullScreenSupported()) {
                device.setFullScreenWindow(this.frame);
                GameWindowKt.setScreenWidth(device.getFullScreenWindow().getWidth());
                GameWindowKt.setScreenHeight(device.getFullScreenWindow().getHeight());
            }
        } else {
            GameWindowKt.setScreenWidth(this.width);
            GameWindowKt.setScreenHeight(this.height);
        }
        this.frame.add(this.panel);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.panel.addKeyListener(this.gameRunner);
        this.panel.addMouseListener(this.gameRunner);
        this.panel.addMouseMotionListener(this.gameRunner);
        this.panel.setFocusTraversalKeysEnabled(false);
    }

    public final void toggleFullScreen() {
        this.frame.dispose();
        this.frame = new JFrame();
        this.panel = new JPanel();
        if (this.fullScreen) {
            this.fullScreen = false;
            GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().setFullScreenWindow(null);
            this.initFrameAndPanel(false);
            VolatileImage volatileImage = this.panel.createVolatileImage(this.width, this.height);
            Intrinsics.checkNotNullExpressionValue(volatileImage, "createVolatileImage(...)");
            this.image = volatileImage;
        } else {
            this.fullScreen = true;
            this.initFrameAndPanel(true);
            VolatileImage volatileImage = this.panel.createVolatileImage((int)GameWindowKt.getScreenWidth(), (int)GameWindowKt.getScreenHeight());
            Intrinsics.checkNotNullExpressionValue(volatileImage, "createVolatileImage(...)");
            this.image = volatileImage;
        }
    }

    private final boolean isImageValid() {
        return this.image.validate(this.panel.getGraphicsConfiguration()) == 2;
    }

    private final void createNewImage(boolean isFullScreen) {
        if (isFullScreen) {
            VolatileImage volatileImage = this.panel.createVolatileImage((int)GameWindowKt.getScreenWidth(), (int)GameWindowKt.getScreenHeight());
            Intrinsics.checkNotNullExpressionValue(volatileImage, "createVolatileImage(...)");
            this.image = volatileImage;
        } else {
            VolatileImage volatileImage = this.panel.createVolatileImage(this.width, this.height);
            Intrinsics.checkNotNullExpressionValue(volatileImage, "createVolatileImage(...)");
            this.image = volatileImage;
        }
    }

    private final Graphics2D createGraphics() {
        Graphics2D g = this.image.createGraphics();
        g.setRenderingHints(this.renderingHints);
        Intrinsics.checkNotNull(g);
        return g;
    }

    @Override
    public void render(int width, int height) {
        if (this.panel.getGraphics() == null) {
            return;
        }
        Graphics graphics = this.panel.getGraphics();
        Intrinsics.checkNotNull(graphics, "null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        double scaleX = GameWindowKt.getScreenWidth() / (double)width;
        double scaleY = GameWindowKt.getScreenHeight() / (double)height;
        this.scale = Math.min(scaleX, scaleY);
        g2d.scale(this.scale, this.scale);
        g2d.translate((GameWindowKt.getScreenWidth() / this.scale - (double)width) / (double)2, (GameWindowKt.getScreenHeight() / this.scale - (double)height) / (double)2);
        g2d.drawImage(this.image, 0, 0, null);
        Toolkit.getDefaultToolkit().sync();
    }

    @Override
    public void run() {
        this.gameRunner.run();
    }

    @Override
    public void onGameSceneChanged(@NotNull IGameScene oldGameScene, @NotNull IGameScene newGameScene) {
        Intrinsics.checkNotNullParameter(oldGameScene, "oldGameScene");
        Intrinsics.checkNotNullParameter(newGameScene, "newGameScene");
    }

    @Override
    @NotNull
    public Graphics2D getGraphics2D() {
        if (this.isImageValid()) {
            this.createNewImage(this.fullScreen);
        }
        Graphics2D g = this.createGraphics();
        return g;
    }
}

