/*
 * Decompiled with CFR 0.152.
 */
package Game.particles;

import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.TerrainScene.BattleScene;
import Game.TerrainScene.RasterTerrain;
import Game.particles.Emitter;
import Game.particles.Particle;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019\u00a8\u0006\""}, d2={"LGame/particles/DirtFragmentEmitter;", "LGame/particles/Emitter;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "width", "", "particlesToCreatePerUpdate", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;II)V", "fragmentDarkColor", "Ljava/awt/Color;", "getFragmentDarkColor", "()Ljava/awt/Color;", "setFragmentDarkColor", "(Ljava/awt/Color;)V", "fragmentLightColor", "getFragmentLightColor", "setFragmentLightColor", "darkerColors", "", "getDarkerColors", "()[Ljava/awt/Color;", "setDarkerColors", "([Ljava/awt/Color;)V", "[Ljava/awt/Color;", "lighterColors", "getLighterColors", "setLighterColors", "makeParticle", "LGame/particles/Particle;", "emitTicksLeft", "Companion", "TankWarsKotlin"})
public final class DirtFragmentEmitter
extends Emitter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public Color fragmentDarkColor;
    public Color fragmentLightColor;
    public Color[] darkerColors;
    public Color[] lighterColors;
    @NotNull
    private static final Double[] sizes;

    public DirtFragmentEmitter(@NotNull IGameScene parent, @NotNull Pos2D position, int width, int particlesToCreatePerUpdate) {
        block0: {
            Intrinsics.checkNotNullParameter(parent, "parent");
            Intrinsics.checkNotNullParameter(position, "position");
            super(parent, position, width, 0.1, particlesToCreatePerUpdate);
            Object object = parent instanceof BattleScene ? (BattleScene)parent : null;
            if (object == null || (object = ((BattleScene)object).getRasterTerrain()) == null) break block0;
            Object it = object;
            boolean bl = false;
            this.setFragmentDarkColor(((RasterTerrain)it).getDarkOutlineColor());
            this.setFragmentLightColor(((RasterTerrain)it).getPrimaryColor());
            Color[] colorArray = new Color[]{this.getFragmentDarkColor()};
            this.setDarkerColors(colorArray);
            colorArray = new Color[]{this.getFragmentLightColor()};
            this.setLighterColors(colorArray);
        }
    }

    public /* synthetic */ DirtFragmentEmitter(IGameScene iGameScene, Pos2D pos2D, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            n2 = 10;
        }
        this(iGameScene, pos2D, n, n2);
    }

    @NotNull
    public final Color getFragmentDarkColor() {
        Color color = this.fragmentDarkColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException("fragmentDarkColor");
        return null;
    }

    public final void setFragmentDarkColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.fragmentDarkColor = color;
    }

    @NotNull
    public final Color getFragmentLightColor() {
        Color color = this.fragmentLightColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException("fragmentLightColor");
        return null;
    }

    public final void setFragmentLightColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.fragmentLightColor = color;
    }

    @NotNull
    public final Color[] getDarkerColors() {
        if (this.darkerColors != null) {
            return this.darkerColors;
        }
        Intrinsics.throwUninitializedPropertyAccessException("darkerColors");
        return null;
    }

    public final void setDarkerColors(@NotNull Color[] colorArray) {
        Intrinsics.checkNotNullParameter(colorArray, "<set-?>");
        this.darkerColors = colorArray;
    }

    @NotNull
    public final Color[] getLighterColors() {
        if (this.lighterColors != null) {
            return this.lighterColors;
        }
        Intrinsics.throwUninitializedPropertyAccessException("lighterColors");
        return null;
    }

    public final void setLighterColors(@NotNull Color[] colorArray) {
        Intrinsics.checkNotNullParameter(colorArray, "<set-?>");
        this.lighterColors = colorArray;
    }

    @Override
    @NotNull
    public Particle makeParticle(int emitTicksLeft) {
        double xOffset = Random.Default.nextDouble(-((double)this.getWidth()), this.getWidth());
        double xVelocity = Random.Default.nextDouble(2.0) * (xOffset / Math.abs(xOffset));
        double yVelocity = Random.Default.nextDouble(-5.0, -3.0);
        Particle p = new Particle(this.getParent(), new Pos2D(this.getPosition().getX() + xOffset, this.getPosition().getY()), new Vec2D(xVelocity, yVelocity), new Vec2D(0.0, 0.2), 0.5, Random.Default.nextDouble() <= 0.5 ? this.getLighterColors() : this.getDarkerColors(), sizes);
        return p;
    }

    static {
        Double[] doubleArray = new Double[]{1.0};
        sizes = doubleArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"LGame/particles/DirtFragmentEmitter$Companion;", "", "<init>", "()V", "sizes", "", "", "getSizes", "()[Ljava/lang/Double;", "[Ljava/lang/Double;", "TankWarsKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Double[] getSizes() {
            return sizes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

