/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.GameObject2;
import Engine.GameRunner;
import Engine.GameScene;
import Engine.Pos2D;
import Game.TerrainScene.CloudPart;
import Game.TerrainScene.Tank;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010(\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010\b\u001a\u00020*J\u000e\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020#J\u0016\u0010,\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020*2\u0006\u0010\b\u001a\u00020*J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0010\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0014R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0010\"\u0004\b\u001c\u0010\u0014R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0014R\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\u0014R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00061"}, d2={"LGame/TerrainScene/Viewport;", "", "gameScene", "LEngine/GameScene;", "width", "", "height", "x", "y", "minX", "maxX", "minY", "maxY", "<init>", "(LEngine/GameScene;IIIIIIII)V", "getWidth", "()I", "getHeight", "getX", "setX", "(I)V", "getY", "setY", "getMinX", "setMinX", "getMaxX", "setMaxX", "getMinY", "setMinY", "getMaxY", "setMaxY", "ticksLeft", "getTicksLeft", "setTicksLeft", "target", "LEngine/Pos2D;", "getTarget", "()LEngine/Pos2D;", "setTarget", "(LEngine/Pos2D;)V", "setFocus", "", "", "pos", "inside", "", "gameObject", "LEngine/GameObject2;", "update", "TankWarsKotlin"})
public final class Viewport {
    @NotNull
    private final GameScene gameScene;
    private final int width;
    private final int height;
    private int x;
    private int y;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int ticksLeft;
    @NotNull
    private Pos2D target;

    public Viewport(@NotNull GameScene gameScene, int width, int height, int x, int y, int minX, int maxX, int minY, int maxY) {
        Intrinsics.checkNotNullParameter(gameScene, "gameScene");
        this.gameScene = gameScene;
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.target = new Pos2D(0.0, 0.0);
    }

    public /* synthetic */ Viewport(GameScene gameScene, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n9 & 0x20) != 0) {
            n5 = Integer.MIN_VALUE;
        }
        if ((n9 & 0x40) != 0) {
            n6 = Integer.MAX_VALUE;
        }
        if ((n9 & 0x80) != 0) {
            n7 = Integer.MIN_VALUE;
        }
        if ((n9 & 0x100) != 0) {
            n8 = Integer.MAX_VALUE;
        }
        this(gameScene, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    public final int getMinX() {
        return this.minX;
    }

    public final void setMinX(int n) {
        this.minX = n;
    }

    public final int getMaxX() {
        return this.maxX;
    }

    public final void setMaxX(int n) {
        this.maxX = n;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final void setMinY(int n) {
        this.minY = n;
    }

    public final int getMaxY() {
        return this.maxY;
    }

    public final void setMaxY(int n) {
        this.maxY = n;
    }

    public final int getTicksLeft() {
        return this.ticksLeft;
    }

    public final void setTicksLeft(int n) {
        this.ticksLeft = n;
    }

    @NotNull
    public final Pos2D getTarget() {
        return this.target;
    }

    public final void setTarget(@NotNull Pos2D pos2D) {
        Intrinsics.checkNotNullParameter(pos2D, "<set-?>");
        this.target = pos2D;
    }

    public final void setFocus(double x, double y) {
        this.target.setX(x);
        this.target.setY(y);
        this.ticksLeft = (int)(0.5 * GameRunner.Companion.getFps());
    }

    public final void setFocus(@NotNull Pos2D pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        this.setFocus(pos.getX(), pos.getY());
    }

    public final boolean inside(double x, double y) {
        if (x < (double)this.x) {
            return false;
        }
        if (y < (double)this.y) {
            return false;
        }
        if (x > (double)(this.x + this.width)) {
            return false;
        }
        return !(y > (double)(this.y + this.height));
    }

    public final boolean inside(@NotNull GameObject2 gameObject) {
        Intrinsics.checkNotNullParameter(gameObject, "gameObject");
        int size = 0;
        if (gameObject instanceof Tank) {
            size = ((Tank)gameObject).getSize();
        } else if (gameObject instanceof CloudPart) {
            size = ((CloudPart)gameObject).getSize();
        }
        if (size > 0) {
            if (this.inside(gameObject.getPosition().getX() - (double)size, gameObject.getPosition().getY() - (double)size)) {
                return true;
            }
            if (this.inside(gameObject.getPosition().getX() - (double)size, gameObject.getPosition().getY() + (double)size)) {
                return true;
            }
            if (this.inside(gameObject.getPosition().getX() + (double)size, gameObject.getPosition().getY() - (double)size)) {
                return true;
            }
            return this.inside(gameObject.getPosition().getX() + (double)size, gameObject.getPosition().getY() + (double)size);
        }
        return this.inside(gameObject.getPosition().getX(), gameObject.getPosition().getY());
    }

    public final void update() {
        if (this.ticksLeft > 0) {
            this.x = Math.min(this.maxX, (int)((double)this.x * 0.9 + 0.1 * (this.target.getX() - (double)(MainKt.getGameResX() / 2))));
            if (this.x < this.minX) {
                this.x = this.minX;
            }
            this.y = Math.min(this.maxY, (int)((double)this.y * 0.9 + 0.1 * (this.target.getY() - (double)(MainKt.getGameResY() / 2))));
            if (this.y < this.minY) {
                this.y = this.minY;
            }
            this.ticksLeft = this.inside(this.target.getX(), this.target.getY()) ? (int)((double)this.ticksLeft * 0.6) : --this.ticksLeft;
        }
    }
}

