/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.GameObject2;
import Engine.GameRunner;
import Engine.GameSceneKt;
import Engine.IGameScene;
import Engine.Pos2D;
import Game.GameController;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Tank;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001d"}, d2={"LGame/TerrainScene/TankInfoBar;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;)V", "stroke", "Ljava/awt/BasicStroke;", "getStroke", "()Ljava/awt/BasicStroke;", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "debugFont", "getDebugFont", "purple", "Ljava/awt/Color;", "getPurple", "()Ljava/awt/Color;", "darkPurple", "getDarkPurple", "update", "", "draw", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
public final class TankInfoBar
extends GameObject2 {
    @NotNull
    private final BasicStroke stroke;
    @NotNull
    private final Font font;
    @NotNull
    private final Font debugFont;
    @NotNull
    private final Color purple;
    @NotNull
    private final Color darkPurple;

    public TankInfoBar(@NotNull IGameScene parent, @NotNull Pos2D position) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        super(parent, position);
        this.stroke = new BasicStroke(3.0f, 0, 1);
        this.font = new Font("Helvetica", 0, 18);
        this.debugFont = new Font("Helvetica", 0, 10);
        this.purple = new Color(30, 30, 80);
        this.darkPurple = new Color(20, 20, 40);
        this.setDrawOrder(100);
    }

    @NotNull
    public final BasicStroke getStroke() {
        return this.stroke;
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    @NotNull
    public final Font getDebugFont() {
        return this.debugFont;
    }

    @NotNull
    public final Color getPurple() {
        return this.purple;
    }

    @NotNull
    public final Color getDarkPurple() {
        return this.darkPurple;
    }

    @Override
    public void update() {
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        GameSceneKt.drawAsHud(g, arg_0 -> TankInfoBar.draw$lambda$0(g, this, arg_0));
    }

    private static final Unit draw$lambda$0(Graphics2D $g, TankInfoBar this$0, Graphics2D it) {
        Tank currentTank;
        Player currentPlayer;
        Intrinsics.checkNotNullParameter(it, "it");
        $g.setStroke(this$0.stroke);
        $g.setColor(Color.WHITE);
        $g.setFont(this$0.font);
        Player player = currentPlayer = GameController.INSTANCE.getCurrentPlayer();
        Tank tank = currentTank = player != null ? player.getTank() : null;
        if (currentPlayer != null && currentTank != null) {
            $g.drawString("Power: " + currentTank.getPower(), (int)this$0.getPosition().getX() + 16, (int)this$0.getPosition().getY() + 22);
            $g.drawString("Fuel: " + MathKt.roundToInt(currentTank.getFuel()) + " L", (int)this$0.getPosition().getX() + 120, (int)this$0.getPosition().getY() + 22);
            $g.drawString("" + '$' + currentPlayer.getMoney(), (int)this$0.getPosition().getX() + 420, (int)this$0.getPosition().getY() + 22);
            $g.drawString("Energy: " + currentTank.getEnergy(), (int)this$0.getPosition().getX() + 516, (int)this$0.getPosition().getY() + 22);
            int nameWidth = $g.getFontMetrics().stringWidth(currentPlayer.getName());
            $g.setColor(Color.BLACK);
            $g.drawString(currentPlayer.getName(), MainKt.getGameResX() / 2 - nameWidth / 2 + 1, (int)this$0.getPosition().getY() + 22 + 1);
            $g.setColor(currentPlayer.getColor());
            $g.drawString(currentPlayer.getName(), MainKt.getGameResX() / 2 - nameWidth / 2, (int)this$0.getPosition().getY() + 22);
            if (GameRunner.Companion.getDebug()) {
                $g.setColor(Color.RED);
                $g.setFont(this$0.debugFont);
                $g.drawString("GameObjects: " + this$0.getParent().gameObjectsCount() + ", wind: " + (double)((int)(GameController.INSTANCE.getWind() * (double)100)) / 100.0, 0, MainKt.getGameResY() - 10);
                $g.drawString("RenderBuffer [ms]: " + GameController.INSTANCE.getRenderBufferTime(), 250, MainKt.getGameResY() - 10);
                $g.drawString("RenderScreen [ms]: " + GameController.INSTANCE.getRenderScreenTime(), 400, MainKt.getGameResY() - 10);
                $g.drawString("Update [ms]: " + GameController.INSTANCE.getUpdateTime(), 520, MainKt.getGameResY() - 10);
            }
        }
        return Unit.INSTANCE;
    }
}

