/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.AudioHelper;
import Engine.ExtensionsKt;
import Engine.GameObject2;
import Engine.GameRunner;
import Engine.IGameObject;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.GameController;
import Game.Menu.MenuSceneKt;
import Game.TerrainScene.ChargeIndicator;
import Game.TerrainScene.Direction;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.RasterTerrain;
import Game.particles.Emitter;
import Game.particles.FireEmitter;
import Game.particles.SmokeEmitter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010P\u001a\u00020QH\u0016J\u0006\u0010R\u001a\u00020QJ\u0006\u0010S\u001a\u00020QJ\u0010\u0010T\u001a\u00020Q2\u0006\u0010U\u001a\u00020VH\u0016J\u000e\u0010W\u001a\u00020Q2\u0006\u0010U\u001a\u00020VJ\u000e\u0010X\u001a\u00020Q2\u0006\u0010U\u001a\u00020VJ\u0010\u0010Y\u001a\u00020Q2\b\b\u0002\u0010Z\u001a\u00020/J\u0006\u0010[\u001a\u00020QJ\u0006\u0010\\\u001a\u00020QJ\u0010\u0010]\u001a\u00020Q2\b\b\u0002\u0010Z\u001a\u00020/J\u000e\u0010^\u001a\u00020Q2\u0006\u0010_\u001a\u00020\u0019J\u000e\u0010`\u001a\u00020Q2\u0006\u0010_\u001a\u00020\u0019J\u0010\u0010a\u001a\u00020b2\b\b\u0002\u0010\u001f\u001a\u00020\u0019J\u0006\u0010d\u001a\u00020QJ\u0006\u0010e\u001a\u00020QJ\u0006\u0010f\u001a\u00020QJ\u0006\u0010g\u001a\u00020QJ\u0006\u0010h\u001a\u00020QJ\u0006\u0010i\u001a\u00020QJ\u0006\u0010j\u001a\u00020QJ\u0006\u0010k\u001a\u00020QR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001c\"\u0004\b*\u0010\u001eR\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u000e\u00104\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00101\"\u0004\b7\u00103R\u001a\u00108\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u001c\"\u0004\b:\u0010\u001eR\u001a\u0010;\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u001c\"\u0004\b=\u0010\u001eR\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001c\u0010D\u001a\u0004\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010A\"\u0004\bF\u0010CR\u001a\u0010G\u001a\u00020HX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001a\u0010M\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010%\"\u0004\bO\u0010'R\u000e\u0010c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"LGame/TerrainScene/Tank;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "rasterTerrain", "LGame/TerrainScene/RasterTerrain;", "position", "LEngine/Pos2D;", "color", "Ljava/awt/Color;", "<init>", "(LEngine/IGameScene;LGame/TerrainScene/RasterTerrain;LEngine/Pos2D;Ljava/awt/Color;)V", "getRasterTerrain", "()LGame/TerrainScene/RasterTerrain;", "setRasterTerrain", "(LGame/TerrainScene/RasterTerrain;)V", "getColor", "()Ljava/awt/Color;", "chargeIndicator", "LGame/TerrainScene/ChargeIndicator;", "getChargeIndicator", "()LGame/TerrainScene/ChargeIndicator;", "setChargeIndicator", "(LGame/TerrainScene/ChargeIndicator;)V", "value", "", "size", "getSize", "()I", "setSize", "(I)V", "power", "getPower", "setPower", "angle", "", "getAngle", "()D", "setAngle", "(D)V", "energy", "getEnergy", "setEnergy", "stroke", "Ljava/awt/BasicStroke;", "fatStroke", "falling", "", "getFalling", "()Z", "setFalling", "(Z)V", "firstFall", "playing", "getPlaying", "setPlaying", "canonX", "getCanonX", "setCanonX", "canonY", "getCanonY", "setCanonY", "smokeEmitter", "LGame/particles/Emitter;", "getSmokeEmitter", "()LGame/particles/Emitter;", "setSmokeEmitter", "(LGame/particles/Emitter;)V", "fireEmitter", "getFireEmitter", "setFireEmitter", "direction", "LGame/TerrainScene/Direction;", "getDirection", "()LGame/TerrainScene/Direction;", "setDirection", "(LGame/TerrainScene/Direction;)V", "fuel", "getFuel", "setFuel", "update", "", "addFire", "onDie", "draw", "g", "Ljava/awt/Graphics2D;", "drawChristmasHat", "drawCenter", "onTankMoved", "pokeTerrain", "onAngleChanged", "onPowerChanged", "updateCanonXY", "increaseAngle", "p", "increasePower", "getFireVelocity", "LEngine/Vec2D;", "movePressBuffer", "onLeftKeyPressed", "onRightKeyPressed", "onLeftOrRightKeyReleased", "onUpKeyPressed", "onDownKeyPressed", "onUpOrDownKeyReleased", "onSpaceKeyPressed", "onSpaceKeyReleased", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nTank.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tank.kt\nGame/TerrainScene/Tank\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n1#2:322\n*E\n"})
public final class Tank
extends GameObject2 {
    @NotNull
    private RasterTerrain rasterTerrain;
    @NotNull
    private final Color color;
    @Nullable
    private ChargeIndicator chargeIndicator;
    private int size;
    private int power;
    private double angle;
    private int energy;
    @NotNull
    private BasicStroke stroke;
    @NotNull
    private BasicStroke fatStroke;
    private boolean falling;
    private boolean firstFall;
    private boolean playing;
    private int canonX;
    private int canonY;
    @Nullable
    private Emitter smokeEmitter;
    @Nullable
    private Emitter fireEmitter;
    @NotNull
    private Direction direction;
    private double fuel;
    private int movePressBuffer;

    public Tank(@NotNull IGameScene parent, @NotNull RasterTerrain rasterTerrain, @NotNull Pos2D position, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(rasterTerrain, "rasterTerrain");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(color, "color");
        super(parent, position);
        this.rasterTerrain = rasterTerrain;
        this.color = color;
        this.size = 20;
        this.power = 100;
        this.angle = 45.0;
        this.energy = 100;
        this.stroke = new BasicStroke((float)this.size / 10.0f, 0, 1);
        this.fatStroke = new BasicStroke((float)this.size / 5.0f, 0, 1);
        this.firstFall = true;
        this.playing = true;
        this.canonX = (int)(position.getX() + (double)this.size * Math.cos(Math.PI * this.angle / 180.0));
        this.canonY = (int)(position.getY() - (double)this.size * Math.sin(Math.PI * this.angle / 180.0));
        this.direction = Direction.RIGHT;
        this.movePressBuffer = 10;
    }

    @NotNull
    public final RasterTerrain getRasterTerrain() {
        return this.rasterTerrain;
    }

    public final void setRasterTerrain(@NotNull RasterTerrain rasterTerrain) {
        Intrinsics.checkNotNullParameter(rasterTerrain, "<set-?>");
        this.rasterTerrain = rasterTerrain;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @Nullable
    public final ChargeIndicator getChargeIndicator() {
        return this.chargeIndicator;
    }

    public final void setChargeIndicator(@Nullable ChargeIndicator chargeIndicator) {
        this.chargeIndicator = chargeIndicator;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int value) {
        this.size = value;
        this.stroke = new BasicStroke((float)value / 10.0f, 0, 1);
        this.fatStroke = new BasicStroke((float)value / 5.0f, 0, 1);
    }

    public final int getPower() {
        return this.power;
    }

    public final void setPower(int n) {
        this.power = n;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double d) {
        this.angle = d;
    }

    public final int getEnergy() {
        return this.energy;
    }

    public final void setEnergy(int n) {
        this.energy = n;
    }

    public final boolean getFalling() {
        return this.falling;
    }

    public final void setFalling(boolean bl) {
        this.falling = bl;
    }

    public final boolean getPlaying() {
        return this.playing;
    }

    public final void setPlaying(boolean bl) {
        this.playing = bl;
    }

    public final int getCanonX() {
        return this.canonX;
    }

    public final void setCanonX(int n) {
        this.canonX = n;
    }

    public final int getCanonY() {
        return this.canonY;
    }

    public final void setCanonY(int n) {
        this.canonY = n;
    }

    @Nullable
    public final Emitter getSmokeEmitter() {
        return this.smokeEmitter;
    }

    public final void setSmokeEmitter(@Nullable Emitter emitter) {
        this.smokeEmitter = emitter;
    }

    @Nullable
    public final Emitter getFireEmitter() {
        return this.fireEmitter;
    }

    public final void setFireEmitter(@Nullable Emitter emitter) {
        this.fireEmitter = emitter;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, "<set-?>");
        this.direction = direction;
    }

    public final double getFuel() {
        return this.fuel;
    }

    public final void setFuel(double d) {
        this.fuel = d;
    }

    @Override
    public void update() {
        if (this.falling) {
            if ((int)this.getPosition().getY() < this.rasterTerrain.getRasterImage().getHeight() - 2) {
                if (this.rasterTerrain.getRasterImage().getRGB((int)this.getPosition().getX(), (int)this.getPosition().getY() + 2) == 0 || this.rasterTerrain.getRasterImage().getRGB((int)this.getPosition().getX() - this.size / 4, (int)this.getPosition().getY() + 2) == 0 || this.rasterTerrain.getRasterImage().getRGB((int)this.getPosition().getX() + this.size / 4, (int)this.getPosition().getY() + 2) == 0) {
                    Pos2D pos2D = this.getPosition();
                    pos2D.setY(pos2D.getY() + (double)60 / GameRunner.Companion.getFps());
                    this.rasterTerrain.getRasterImage().getGraphics().setColor(new Color(0, 0, 0, 0));
                    this.rasterTerrain.pokeLine((int)(this.getPosition().getX() - (double)(this.size / 2)), (int)this.getPosition().getY() - 5, (int)(this.getPosition().getX() + (double)(this.size / 2)), (int)this.getPosition().getY() - 5, 3.0f);
                    if (!this.firstFall && this.energy > 0) {
                        --this.energy;
                        Player player = GameController.INSTANCE.getCurrentPlayer();
                        if (player != null) {
                            Player p = player;
                            boolean bl = false;
                            p.setMoney(p.getMoney() + 1.0);
                        }
                    }
                    Tank.onTankMoved$default(this, false, 1, null);
                } else {
                    this.falling = false;
                    this.firstFall = false;
                }
            } else {
                this.falling = false;
                this.firstFall = false;
            }
        }
        if (this.energy < 50 && this.fireEmitter == null) {
            this.addFire();
        }
        if (this.fireEmitter != null) {
            Emitter emitter = this.fireEmitter;
            boolean bl = emitter != null ? emitter.getEmitTicksLeft() == 0 : false;
            if (bl) {
                IGameScene iGameScene = this.getParent();
                Emitter emitter2 = this.fireEmitter;
                Intrinsics.checkNotNull(emitter2);
                iGameScene.remove(emitter2);
                this.fireEmitter = null;
            }
        }
        if (this.smokeEmitter != null) {
            Emitter emitter = this.smokeEmitter;
            boolean bl = emitter != null ? emitter.getEmitTicksLeft() == 0 : false;
            if (bl) {
                IGameScene iGameScene = this.getParent();
                Emitter emitter3 = this.smokeEmitter;
                Intrinsics.checkNotNull(emitter3);
                iGameScene.remove(emitter3);
                this.smokeEmitter = null;
            }
        }
    }

    public final void addFire() {
        Emitter emitter;
        if (this.fireEmitter == null) {
            emitter = new FireEmitter(this.getParent(), this.getPosition(), 4, 5.0);
            emitter.setDrawOrder(-10);
            this.fireEmitter = emitter;
        }
        if (this.smokeEmitter == null) {
            emitter = new SmokeEmitter(this.getParent(), this.getPosition(), 4, 10.0);
            emitter.setDrawOrder(-11);
            this.smokeEmitter = emitter;
        }
    }

    public final void onDie() {
        Emitter it;
        Emitter emitter = this.fireEmitter;
        if (emitter != null) {
            it = emitter;
            boolean bl = false;
            it.setEmitTicksLeft(0);
        }
        Emitter emitter2 = this.smokeEmitter;
        if (emitter2 != null) {
            it = emitter2;
            boolean bl = false;
            it.setEmitTicksLeft(0);
        }
        this.fireEmitter = null;
        this.smokeEmitter = null;
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        Color fillColor = GameController.INSTANCE.getGlowUp() > 0 ? ExtensionsKt.lighter(this.color, GameController.INSTANCE.getGlowUp() * 10) : ExtensionsKt.mult(this.color, (double)this.energy / 100.0);
        Color strokeColor = ExtensionsKt.darker(fillColor, 100);
        g.setColor(fillColor);
        g.setStroke(this.fatStroke);
        g.setColor(strokeColor);
        g.drawLine((int)this.getPosition().getX(), (int)this.getPosition().getY(), this.canonX, this.canonY);
        g.setStroke(this.stroke);
        g.drawArc((int)(this.getPosition().getX() - (double)(this.size / 2)), (int)(this.getPosition().getY() - (double)this.size / 2.0 + (double)2), this.size, this.size, 0, 180);
        g.setColor(fillColor);
        g.drawLine((int)this.getPosition().getX(), (int)this.getPosition().getY(), this.canonX, this.canonY);
        g.fillArc((int)(this.getPosition().getX() - (double)(this.size / 2)), (int)(this.getPosition().getY() - (double)this.size / 2.0 + (double)2), this.size, this.size, 0, 180);
        if (GameController.INSTANCE.getDecorationOption() == MenuSceneKt.getOPTION_DECO_CHRISTMAS()) {
            this.drawChristmasHat(g);
        }
    }

    public final void drawChristmasHat(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        double dir = this.angle <= 90.0 ? 1.0 : -1.0;
        g.setColor(Color.RED);
        Integer[] integerArray = new Integer[]{(int)(this.getPosition().getX() - dir * (double)this.size / (double)2), (int)this.getPosition().getX(), (int)(this.getPosition().getX() - dir * (double)this.size / (double)2)};
        int[] nArray = ArraysKt.toIntArray(integerArray);
        integerArray = new Integer[]{(int)(this.getPosition().getY() - (double)(this.size * 3 / 4)), (int)(this.getPosition().getY() - (double)this.size / 2.0), (int)(this.getPosition().getY() - (double)this.size / 7.0)};
        Polygon polygon = new Polygon(nArray, ArraysKt.toIntArray(integerArray), 3);
        g.fillPolygon(polygon);
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        g.setColor(ExtensionsKt.darker(color, 30));
        Integer[] integerArray2 = new Integer[]{(int)(this.getPosition().getX() - dir * (double)this.size / (double)2), (int)(this.getPosition().getX() - dir * (double)this.size * 2.0 / 20.0), (int)(this.getPosition().getX() - dir * (double)this.size * 7.0 / 20.0)};
        int[] nArray2 = ArraysKt.toIntArray(integerArray2);
        integerArray2 = new Integer[]{(int)(this.getPosition().getY() - (double)this.size * 15.0 / 20.0), (int)(this.getPosition().getY() - (double)this.size * 11.0 / 20.0), (int)(this.getPosition().getY() - (double)this.size * 9.0 / 20.0)};
        Polygon shadowPolygon = new Polygon(nArray2, ArraysKt.toIntArray(integerArray2), 3);
        g.fillPolygon(shadowPolygon);
        g.setColor(Color.WHITE);
        g.fillOval((int)(this.getPosition().getX() - dir * (double)this.size * 11.0 / 20.0 - (double)this.size / 8.0), (int)(this.getPosition().getY() - (double)this.size), (int)((double)this.size / 4.0), (int)((double)this.size / 4.0));
        g.setStroke(new BasicStroke((float)this.size / 7.0f, 0, 1));
        g.drawLine((int)(this.getPosition().getX() - dir * (double)this.size * 0.55), (int)(this.getPosition().getY() - (double)this.size * 0.1), (int)(this.getPosition().getX() + dir * (double)this.size * 0.1), (int)(this.getPosition().getY() - (double)this.size * 0.55));
    }

    public final void drawCenter(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(Color.WHITE);
        g.drawLine((int)this.getPosition().getX() - 1, (int)this.getPosition().getY(), (int)this.getPosition().getX() + 1, (int)this.getPosition().getY());
    }

    public final void onTankMoved(boolean pokeTerrain) {
        this.updateCanonXY(pokeTerrain);
    }

    public static /* synthetic */ void onTankMoved$default(Tank tank, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        tank.onTankMoved(bl);
    }

    public final void onAngleChanged() {
        Tank.updateCanonXY$default(this, false, 1, null);
    }

    public final void onPowerChanged() {
    }

    public final void updateCanonXY(boolean pokeTerrain) {
        block1: {
            this.canonX = (int)(this.getPosition().getX() + (double)this.size * Math.cos(Math.PI * this.angle / 180.0));
            this.canonY = (int)(this.getPosition().getY() - (double)this.size * Math.sin(Math.PI * this.angle / 180.0));
            int fromX = (int)(this.getPosition().getX() + (double)this.size * 0.9 * Math.cos(Math.PI * this.angle / 180.0));
            int fromY = (int)(this.getPosition().getY() - (double)this.size * 0.9 * Math.sin(Math.PI * this.angle / 180.0));
            if (pokeTerrain) {
                this.rasterTerrain.pokeLine(fromX, fromY, this.canonX, this.canonY, 3.0f);
            }
            ChargeIndicator chargeIndicator = this.chargeIndicator;
            if (chargeIndicator == null) break block1;
            ChargeIndicator it = chargeIndicator;
            boolean bl = false;
            it.getPosition().setX(this.canonX);
            it.getPosition().setY(this.canonY);
        }
    }

    public static /* synthetic */ void updateCanonXY$default(Tank tank, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        tank.updateCanonXY(bl);
    }

    public final void increaseAngle(int p) {
        this.angle += (double)p;
        if (this.angle < 0.0) {
            this.angle += (double)180;
        } else if (this.angle > 180.0) {
            this.angle -= (double)180;
        }
        this.onAngleChanged();
    }

    public final void increasePower(int p) {
        this.power += p;
        if (this.power < 0) {
            this.power = 0;
        } else if (this.power > 1000) {
            this.power = 1000;
        }
        this.onPowerChanged();
    }

    @NotNull
    public final Vec2D getFireVelocity(int power) {
        Vec2D velocity = new Vec2D(Pos2D.copy$default(this.getPosition(), 0.0, 0.0, 3, null), new Pos2D((double)this.canonX, (double)this.canonY)).times((double)power / 400.0);
        return velocity;
    }

    public static /* synthetic */ Vec2D getFireVelocity$default(Tank tank, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = tank.power;
        }
        return tank.getFireVelocity(n);
    }

    public final void onLeftKeyPressed() {
        if (this.direction == Direction.RIGHT) {
            this.direction = Direction.LEFT;
            this.increaseAngle((int)((double)90 - this.angle) * 2);
            this.movePressBuffer = 10;
        } else if (this.movePressBuffer > 0) {
            --this.movePressBuffer;
        } else if (this.getPosition().getX() > 1.0 && this.fuel > 0.0) {
            AudioHelper.loop$default(AudioHelper.INSTANCE, "drive", 0, 2, null);
            this.fuel -= 0.1;
            int newY = this.rasterTerrain.surfaceAt((int)this.getPosition().getX() - 1, (int)(this.getPosition().getY() - (double)5));
            double dy = (double)newY - this.getPosition().getY();
            if (dy > -5.0 && dy < 10.0) {
                Pos2D pos2D = this.getPosition();
                pos2D.setX(pos2D.getX() - 1.0);
                this.getPosition().setY(newY);
                this.onTankMoved(false);
            }
        }
    }

    public final void onRightKeyPressed() {
        if (this.direction == Direction.LEFT) {
            this.direction = Direction.RIGHT;
            this.increaseAngle(-((int)(this.angle - (double)90)) * 2);
            this.movePressBuffer = 10;
        } else if (this.movePressBuffer > 0) {
            --this.movePressBuffer;
        } else if (this.getPosition().getX() < (double)(this.getParent().getWidth() - 1) && this.fuel > 0.0) {
            AudioHelper.loop$default(AudioHelper.INSTANCE, "drive", 0, 2, null);
            this.fuel -= 0.1;
            int newY = this.rasterTerrain.surfaceAt((int)this.getPosition().getX() + 1, (int)(this.getPosition().getY() - (double)5));
            double dy = (double)newY - this.getPosition().getY();
            if (dy > -5.0 && dy < 10.0) {
                Pos2D pos2D = this.getPosition();
                pos2D.setX(pos2D.getX() + 1.0);
                this.getPosition().setY(newY);
                this.onTankMoved(false);
            }
        }
    }

    public final void onLeftOrRightKeyReleased() {
        AudioHelper.INSTANCE.stop("drive");
    }

    public final void onUpKeyPressed() {
        if (this.direction == Direction.RIGHT && this.angle < 90.0) {
            AudioHelper.INSTANCE.loop("change-angle", -1);
            this.increaseAngle(1);
        } else if (this.direction == Direction.LEFT && this.angle > 90.0) {
            AudioHelper.INSTANCE.loop("change-angle", -1);
            this.increaseAngle(-1);
        }
    }

    public final void onDownKeyPressed() {
        if (this.direction == Direction.RIGHT && this.angle > 0.0) {
            AudioHelper.INSTANCE.loop("change-angle", -1);
            this.increaseAngle(-1);
        } else if (this.direction == Direction.LEFT && this.angle < 180.0) {
            AudioHelper.INSTANCE.loop("change-angle", -1);
            this.increaseAngle(1);
        }
    }

    public final void onUpOrDownKeyReleased() {
        AudioHelper.INSTANCE.stop("change-angle");
    }

    /*
     * WARNING - void declaration
     */
    public final void onSpaceKeyPressed() {
        if (this.chargeIndicator == null) {
            void it;
            ChargeIndicator chargeIndicator;
            ChargeIndicator chargeIndicator2 = chargeIndicator = new ChargeIndicator(this.getParent(), new Pos2D((double)this.canonX, (double)this.canonY), this, null, 8, null);
            Tank tank = this;
            boolean bl = false;
            this.getParent().add((IGameObject)it);
            tank.chargeIndicator = chargeIndicator;
        }
    }

    public final void onSpaceKeyReleased() {
        ChargeIndicator chargeIndicator = this.chargeIndicator;
        if (chargeIndicator != null) {
            ChargeIndicator it = chargeIndicator;
            boolean bl = false;
            this.getParent().remove(it);
        }
        this.chargeIndicator = null;
    }
}

