/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.GameObject2;
import Engine.IGameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import Game.GameController;
import Game.TerrainScene.BattleScene;
import Game.TerrainScene.Explosion;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"LGame/TerrainScene/Snowflake;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;)V", "dy", "", "getDy", "()D", "tick", "", "getTick", "()I", "setTick", "(I)V", "update", "", "draw", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
public final class Snowflake
extends GameObject2 {
    private final double dy;
    private int tick;

    public Snowflake(@NotNull IGameScene parent, @NotNull Pos2D position) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        super(parent, position);
        this.dy = Random.Default.nextDouble(0.5, 1.0);
    }

    public final double getDy() {
        return this.dy;
    }

    public final int getTick() {
        return this.tick;
    }

    public final void setTick(int n) {
        this.tick = n;
    }

    @Override
    public void update() {
        Object explosion;
        ++this.tick;
        if (GameController.INSTANCE.getGlowUp() > 0 && Explosion.Companion.getCurrentExplosions().size() > 0) {
            explosion = (Explosion)CollectionsKt.first((Iterable)Explosion.Companion.getCurrentExplosions());
            double distance = this.getPosition().distance(((GameObject2)explosion).getPosition());
            if (distance < (double)((Explosion)explosion).getSize() * 1.5) {
                Vec2D diff = new Vec2D(((GameObject2)explosion).getPosition(), this.getPosition());
                Pos2D pos2D = this.getPosition();
                pos2D.setX(pos2D.getX() + diff.getX() / (distance / (double)10));
                pos2D = this.getPosition();
                pos2D.setY(pos2D.getY() + diff.getY() / (distance / (double)10));
                return;
            }
        }
        explosion = this.getPosition();
        ((Pos2D)explosion).setY(((Pos2D)explosion).getY() + this.dy);
        if (this.getPosition().getY() > (double)this.getParent().getHeight()) {
            this.getParent().remove(this);
            return;
        }
        explosion = this.getPosition();
        ((Pos2D)explosion).setX(((Pos2D)explosion).getX() + (GameController.INSTANCE.getWind() + Random.Default.nextDouble(-0.1, 0.1)));
        if (this.tick > 10) {
            int colAtPos;
            this.tick = 0;
            IGameScene iGameScene = this.getParent();
            Intrinsics.checkNotNull(iGameScene, "null cannot be cast to non-null type Game.TerrainScene.BattleScene");
            BufferedImage img = ((BattleScene)iGameScene).getRasterTerrain().getRasterImage();
            if (this.getPosition().getX() > 0.0 && this.getPosition().getX() < (double)img.getWidth() && this.getPosition().getY() > 0.0 && this.getPosition().getY() + 1.0 < (double)img.getHeight() && (colAtPos = img.getRGB((int)this.getPosition().getX(), (int)this.getPosition().getY() + 1)) != 0) {
                img.setRGB((int)this.getPosition().getX(), (int)this.getPosition().getY(), colAtPos);
                this.getParent().remove(this);
            }
        }
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(Color.WHITE);
        g.fillArc((int)this.getPosition().getX(), (int)this.getPosition().getY(), 2, 2, 0, 360);
    }
}

