/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.AudioHelper;
import Engine.ExtensionsKt;
import Engine.GameObject2;
import Engine.IGameScene;
import Engine.Pos2D;
import Game.GameController;
import Game.Menu.MenuSceneKt;
import Game.TerrainScene.BattleSceneKt;
import Game.TerrainScene.Earthquake;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Tank;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u00100\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u0007J&\u00103\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u000209J&\u0010:\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u000209J&\u0010;\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u000209J2\u0010<\u001a\u0002012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020%2\b\b\u0002\u0010?\u001a\u00020\u00072\b\b\u0002\u0010@\u001a\u00020\u0007J\u001a\u0010A\u001a\u0002012\b\b\u0002\u0010?\u001a\u00020\u00072\b\b\u0002\u0010@\u001a\u00020\u0007J\u0016\u0010B\u001a\u0002012\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u0007J\b\u0010C\u001a\u000201H\u0016J\u0016\u0010D\u001a\u0002012\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007J \u0010E\u001a\u0002012\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\b\b\u0002\u00108\u001a\u00020\u0007J.\u0010F\u001a\u0002012\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020KJ\b\u0010L\u001a\u000201H\u0002J\b\u0010M\u001a\u000201H\u0002J\u0016\u0010N\u001a\u0002012\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007J\u0010\u0010O\u001a\u0002012\u0006\u00104\u001a\u000205H\u0016J\u0018\u0010P\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\b\b\u0002\u0010Q\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u001a\u0010-\u001a\u00020%X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010'\"\u0004\b/\u0010)\u00a8\u0006R"}, d2={"LGame/TerrainScene/RasterTerrain;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "width", "", "height", "groundType", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;III)V", "getGroundType", "()I", "rasterImage", "Ljava/awt/image/BufferedImage;", "getRasterImage", "()Ljava/awt/image/BufferedImage;", "setRasterImage", "(Ljava/awt/image/BufferedImage;)V", "mode", "getMode", "setMode", "(I)V", "crumble", "", "getCrumble", "()Z", "setCrumble", "(Z)V", "earthquake", "LGame/TerrainScene/Earthquake;", "getEarthquake", "()LGame/TerrainScene/Earthquake;", "setEarthquake", "(LGame/TerrainScene/Earthquake;)V", "primaryColor", "Ljava/awt/Color;", "getPrimaryColor", "()Ljava/awt/Color;", "setPrimaryColor", "(Ljava/awt/Color;)V", "darkerColor", "getDarkerColor", "setDarkerColor", "darkOutlineColor", "getDarkOutlineColor", "setDarkOutlineColor", "addSnowmen", "", "amount", "addSnowman", "g", "Ljava/awt/Graphics2D;", "x", "y", "size", "", "addSnowball", "addCarrot", "addColoredTopLayer", "depth", "color", "startX", "endX", "addOutlines", "addScorchFromExplosion", "update", "mouseClicked", "pokeHole", "pokeLine", "x1", "y1", "x2", "y2", "", "maybeStartCrumble", "startCrumble", "startEarthquake", "draw", "surfaceAt", "minY", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nRasterTerrain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RasterTerrain.kt\nGame/TerrainScene/RasterTerrain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n774#2:281\n865#2,2:282\n*S KotlinDebug\n*F\n+ 1 RasterTerrain.kt\nGame/TerrainScene/RasterTerrain\n*L\n203#1:281\n203#1:282,2\n*E\n"})
public final class RasterTerrain
extends GameObject2 {
    private final int groundType;
    @NotNull
    private BufferedImage rasterImage;
    private int mode;
    private boolean crumble;
    @Nullable
    private Earthquake earthquake;
    public Color primaryColor;
    public Color darkerColor;
    public Color darkOutlineColor;

    public RasterTerrain(@NotNull IGameScene parent, @NotNull Pos2D position, int width, int height, int groundType) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        super(parent, position);
        this.groundType = groundType;
        this.rasterImage = new BufferedImage(width, height, 2);
        this.mode = 1;
        Graphics2D g = this.rasterImage.createGraphics();
        int n = this.groundType;
        if (n == MenuSceneKt.getOPTION_GROUND_GRASS()) {
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            this.setPrimaryColor(ExtensionsKt.darker(color, 40));
            this.setDarkerColor(ExtensionsKt.darker(this.getPrimaryColor(), 20));
            this.setDarkOutlineColor(ExtensionsKt.darker(this.getPrimaryColor(), 100));
        } else if (n == MenuSceneKt.getOPTION_GROUND_SNOW()) {
            this.setPrimaryColor(new Color(240, 240, 255));
            this.setDarkerColor(new Color(190, 210, 255));
            this.setDarkOutlineColor(new Color(150, 190, 255));
        } else if (n == MenuSceneKt.getOPTION_GROUND_DESERT()) {
            this.setPrimaryColor(new Color(200, 150, 100));
            this.setDarkerColor(ExtensionsKt.darker(this.getPrimaryColor(), 20));
            this.setDarkOutlineColor(ExtensionsKt.darker(this.getPrimaryColor(), 100));
        } else {
            Color color = Color.orange;
            Intrinsics.checkNotNullExpressionValue(color, "orange");
            this.setPrimaryColor(ExtensionsKt.darker(color, 50));
            this.setDarkerColor(ExtensionsKt.darker(this.getPrimaryColor(), 20));
            this.setDarkOutlineColor(ExtensionsKt.darker(this.getPrimaryColor(), 100));
        }
        g.setColor(this.getPrimaryColor());
        Random rand = RandomKt.Random(System.currentTimeMillis());
        List xs = new ArrayList();
        List ys = new ArrayList();
        int less_bumpy = 10;
        int more_bumpy = 100;
        int steps = rand.nextInt(less_bumpy, more_bumpy);
        int xstep = this.rasterImage.getWidth() / steps;
        int ystep = rand.nextInt(-10, 10);
        int tmpx = 0;
        int tmpy = rand.nextInt(60, this.rasterImage.getHeight() - 60);
        xs.add(tmpx);
        ys.add(tmpy);
        for (int i = 0; i < steps; ++i) {
            ystep = (tmpy += ystep) < 120 ? 3 : (tmpy > this.rasterImage.getHeight() - 60 ? -3 : (ystep += (int)((double)(-steps) / 10.0 + (double)steps / 5.0 * rand.nextDouble())));
            xs.add(tmpx += xstep);
            ys.add(tmpy);
        }
        xs.add(this.rasterImage.getWidth());
        ys.add(tmpy);
        xs.add(this.rasterImage.getWidth());
        ys.add(this.rasterImage.getHeight());
        xs.add(0);
        ys.add(this.rasterImage.getHeight());
        xs.add(0);
        ys.add(this.rasterImage.getHeight() / 2);
        g.fillPolygon(CollectionsKt.toIntArray(xs), CollectionsKt.toIntArray(ys), xs.size());
        RasterTerrain.addOutlines$default(this, 0, 0, 3, null);
        if (this.groundType == MenuSceneKt.getOPTION_GROUND_SNOW()) {
            this.addSnowmen(this.rasterImage, 5);
        }
    }

    public final int getGroundType() {
        return this.groundType;
    }

    @NotNull
    public final BufferedImage getRasterImage() {
        return this.rasterImage;
    }

    public final void setRasterImage(@NotNull BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter(bufferedImage, "<set-?>");
        this.rasterImage = bufferedImage;
    }

    public final int getMode() {
        return this.mode;
    }

    public final void setMode(int n) {
        this.mode = n;
    }

    public final boolean getCrumble() {
        return this.crumble;
    }

    public final void setCrumble(boolean bl) {
        this.crumble = bl;
    }

    @Nullable
    public final Earthquake getEarthquake() {
        return this.earthquake;
    }

    public final void setEarthquake(@Nullable Earthquake earthquake) {
        this.earthquake = earthquake;
    }

    @NotNull
    public final Color getPrimaryColor() {
        Color color = this.primaryColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException("primaryColor");
        return null;
    }

    public final void setPrimaryColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.primaryColor = color;
    }

    @NotNull
    public final Color getDarkerColor() {
        Color color = this.darkerColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException("darkerColor");
        return null;
    }

    public final void setDarkerColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.darkerColor = color;
    }

    @NotNull
    public final Color getDarkOutlineColor() {
        Color color = this.darkOutlineColor;
        if (color != null) {
            return color;
        }
        Intrinsics.throwUninitializedPropertyAccessException("darkOutlineColor");
        return null;
    }

    public final void setDarkOutlineColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.darkOutlineColor = color;
    }

    public final void addSnowmen(@NotNull BufferedImage rasterImage, int amount) {
        Intrinsics.checkNotNullParameter(rasterImage, "rasterImage");
        int x = (int)((double)(rasterImage.getWidth() / amount) + (double)20 * Math.random() * (double)10);
        int i = 1;
        if (i <= amount) {
            while (true) {
                int y;
                x = (int)(((double)(x + rasterImage.getWidth() / amount) + (double)20 * Math.random() * (double)10) % (double)rasterImage.getWidth());
                for (y = 0; rasterImage.getRGB(x, y) == 0 && y < rasterImage.getHeight(); ++y) {
                }
                Graphics graphics = rasterImage.getGraphics();
                Intrinsics.checkNotNull(graphics, "null cannot be cast to non-null type java.awt.Graphics2D");
                this.addSnowman((Graphics2D)graphics, x, y, Random.Default.nextDouble(8.0, 14.0));
                if (i == amount) break;
                ++i;
            }
        }
    }

    public final void addSnowman(@NotNull Graphics2D g, int x, int y, double size) {
        Intrinsics.checkNotNullParameter(g, "g");
        this.addSnowball(g, x, y, size);
        this.addSnowball(g, x, (int)((double)y - size * 0.7), size * 0.75);
        this.addCarrot(g, (int)((double)x - size * 0.1), (int)((double)y - size * 1.2), size * 0.25);
    }

    public final void addSnowball(@NotNull Graphics2D g, int x, int y, double size) {
        Intrinsics.checkNotNullParameter(g, "g");
        int tx = x;
        int ty = y;
        g.setColor(new Color(180, 180, 255));
        g.fillOval((int)((double)tx - size / 2.0), (int)((double)ty - size), (int)size, (int)size);
        g.setColor(new Color(220, 220, 255));
        g.fillOval((int)((double)tx - size / 2.0), (int)((double)ty - size), (int)(size * 0.8), (int)(size * 0.8));
    }

    public final void addCarrot(@NotNull Graphics2D g, int x, int y, double size) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(new Color(230, 130, 0));
        g.setStroke(new BasicStroke((float)(size / 5.0), 1, 1));
        g.drawLine(x, y, (int)((double)x - size), (int)((double)y + size / 10.0));
        g.drawLine(x, (int)((double)y + size / 5.0), (int)((double)x - size), (int)((double)y + size / 10.0));
    }

    public final void addColoredTopLayer(@NotNull BufferedImage rasterImage, int depth, @NotNull Color color, int startX, int endX) {
        Intrinsics.checkNotNullParameter(rasterImage, "rasterImage");
        Intrinsics.checkNotNullParameter(color, "color");
        if (startX >= endX) {
            return;
        }
        int n = rasterImage.getHeight();
        block0: for (int y = depth; y < n; ++y) {
            int n2;
            int x = Math.max(0, startX);
            if (x > (n2 = Math.min(endX, rasterImage.getWidth() - 1))) continue;
            while (true) {
                if (rasterImage.getRGB(x, y) != 0 && rasterImage.getRGB(x, y - depth) == 0) {
                    rasterImage.setRGB(x, y, color.getRGB());
                }
                if (x == n2) continue block0;
                ++x;
            }
        }
    }

    public static /* synthetic */ void addColoredTopLayer$default(RasterTerrain rasterTerrain, BufferedImage bufferedImage, int n, Color color, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x10) != 0) {
            n3 = bufferedImage.getWidth() - 1;
        }
        rasterTerrain.addColoredTopLayer(bufferedImage, n, color, n2, n3);
    }

    public final void addOutlines(int startX, int endX) {
        int n = this.groundType;
        if (n == MenuSceneKt.getOPTION_GROUND_DESERT() || n == MenuSceneKt.getOPTION_GROUND_GRASS()) {
            this.addColoredTopLayer(this.rasterImage, 10, ExtensionsKt.darker(this.getDarkerColor(), 20), startX, endX);
            this.addColoredTopLayer(this.rasterImage, 2, ExtensionsKt.darker(this.getDarkOutlineColor(), 100), startX, endX);
        } else if (n == MenuSceneKt.getOPTION_GROUND_SNOW()) {
            this.addColoredTopLayer(this.rasterImage, 10, new Color(230, 230, 255), startX, endX);
            this.addColoredTopLayer(this.rasterImage, 8, new Color(210, 220, 255), startX, endX);
            this.addColoredTopLayer(this.rasterImage, 6, new Color(190, 210, 255), startX, endX);
            this.addColoredTopLayer(this.rasterImage, 4, new Color(170, 200, 255), startX, endX);
            this.addColoredTopLayer(this.rasterImage, 2, new Color(150, 190, 255), startX, endX);
        }
    }

    public static /* synthetic */ void addOutlines$default(RasterTerrain rasterTerrain, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = rasterTerrain.rasterImage.getWidth() - 1;
        }
        rasterTerrain.addOutlines(n, n2);
    }

    public final void addScorchFromExplosion(int startX, int endX) {
        this.addColoredTopLayer(this.rasterImage, 20, this.getDarkerColor(), startX + 8, endX - 8);
        this.addColoredTopLayer(this.rasterImage, 10, this.getDarkOutlineColor(), startX + 5, endX - 5);
        Color color = Color.black;
        Intrinsics.checkNotNullExpressionValue(color, "black");
        this.addColoredTopLayer(this.rasterImage, 5, color, startX - 3, endX + 3);
        Color color2 = Color.black;
        Intrinsics.checkNotNullExpressionValue(color2, "black");
        this.addColoredTopLayer(this.rasterImage, 3, color2, startX - 2, endX + 2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update() {
        if (this.crumble) {
            int crumbleCounter = 0;
            int yFromTop = 1;
            int n = this.rasterImage.getHeight() - 10;
            if (yFromTop <= n) {
                while (true) {
                    int y = this.rasterImage.getHeight() - yFromTop;
                    int x = 0;
                    int n2 = this.rasterImage.getWidth() - 1;
                    if (x <= n2) {
                        while (true) {
                            if (this.rasterImage.getRGB(x, y) == 0 && this.rasterImage.getRGB(x, y - 1) != 0) {
                                this.rasterImage.setRGB(x, y, this.rasterImage.getRGB(x, y - 1));
                                this.rasterImage.setRGB(x, y - 1, 0);
                                ++crumbleCounter;
                            } else if (x > 0 && x < this.rasterImage.getWidth() - 1 && y < this.rasterImage.getHeight() - 1 && y > 0 && this.rasterImage.getRGB(x, y) != 0 && this.rasterImage.getRGB(x, y + 1) != 0 && this.rasterImage.getRGB(x - 1, y) == 0 && this.rasterImage.getRGB(x + 1, y) == 0 && this.rasterImage.getRGB(x - 1, y + 1) == 0 && this.rasterImage.getRGB(x + 1, y + 1) == 0) {
                                this.rasterImage.setRGB(x, y, 0);
                                ++crumbleCounter;
                            }
                            if (x == n2) break;
                            ++x;
                        }
                    }
                    if (yFromTop == n) break;
                    ++yFromTop;
                }
            }
            if (crumbleCounter == 0) {
                void $this$filterTo$iv$iv;
                this.crumble = false;
                Iterable $this$filter$iv = GameController.INSTANCE.getPlayers();
                boolean $i$f$filter = false;
                Iterable x = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Player it = (Player)element$iv$iv;
                    boolean bl = false;
                    if (!it.getPlaying()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Player t : (List)destination$iv$iv) {
                    Tank tank = t.getTank();
                    if (tank != null) {
                        tank.setFalling(true);
                    }
                }
            }
        } else if (this.earthquake != null) {
            boolean didUpdateTerrain;
            Earthquake earthquake = this.earthquake;
            boolean bl = earthquake != null ? earthquake.update(this) : (didUpdateTerrain = false);
            if (!didUpdateTerrain) {
                Earthquake earthquake2 = this.earthquake;
                if (earthquake2 != null) {
                    earthquake2.remove();
                }
                this.earthquake = null;
                AudioHelper.INSTANCE.stop("earthquake");
                this.maybeStartCrumble();
            }
        }
    }

    public final void mouseClicked(int x, int y) {
        System.out.println((Object)("Mouse was clicked at " + x + ',' + y));
        if (this.mode == 1) {
            RasterTerrain.pokeHole$default(this, x, y, 0, 4, null);
            this.maybeStartCrumble();
        } else if (this.mode == 2) {
            this.startCrumble();
        } else if (this.mode == 3) {
            this.startEarthquake(x, y);
        }
    }

    public final void pokeHole(int x, int y, int size) {
        Graphics2D gg = this.rasterImage.createGraphics();
        gg.setColor(new Color(0, 0, 0, 0));
        gg.setComposite(AlphaComposite.Clear);
        gg.fillOval(x - size / 2, y - size / 2, size, size);
    }

    public static /* synthetic */ void pokeHole$default(RasterTerrain rasterTerrain, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = 60;
        }
        rasterTerrain.pokeHole(n, n2, n3);
    }

    public final void pokeLine(int x1, int y1, int x2, int y2, float width) {
        Graphics2D gg = this.rasterImage.createGraphics();
        gg.setColor(new Color(0, 0, 0, 0));
        gg.setComposite(AlphaComposite.Clear);
        gg.setStroke(new BasicStroke(width, 1, 1));
        gg.drawLine(x1, y1, x2, y2);
    }

    private final void maybeStartCrumble() {
        if (BattleSceneKt.getRandom().nextDouble() <= 0.5) {
            this.startCrumble();
        }
    }

    private final void startCrumble() {
        this.crumble = true;
    }

    public final void startEarthquake(int x, int y) {
        this.earthquake = new Earthquake(x, y, 5, 100, 1.0);
        AudioHelper.INSTANCE.loop("earthquake", -1);
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.drawImage(this.rasterImage, null, 0, 0);
    }

    public final int surfaceAt(int x, int minY) {
        int interval;
        int y = interval + minY;
        for (interval = (this.rasterImage.getHeight() - minY) / 2; interval > 1; interval /= 2) {
            if (this.rasterImage.getRGB(x, y) == 0) {
                y += interval;
                continue;
            }
            y -= interval;
        }
        while (this.rasterImage.getRGB(x, y) != 0 && y > 0) {
            --y;
        }
        return y;
    }

    public static /* synthetic */ int surfaceAt$default(RasterTerrain rasterTerrain, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return rasterTerrain.surfaceAt(n, n2);
    }
}

