/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene.Player;

import Engine.GameRunner;
import Engine.GameWindow;
import Engine.IGameScene;
import Engine.Pos2D;
import Game.GameController;
import Game.TerrainScene.Player.Cpu;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Player.PlayerDecision;
import Game.TerrainScene.Player.RandomCpu;
import Game.TerrainScene.ProjectileTrail;
import Game.TerrainScene.Tank;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"LGame/TerrainScene/Player/MonteCarloCpu;", "LGame/TerrainScene/Player/Cpu;", "repetitions", "", "showDecisionOutcomes", "", "<init>", "(IZ)V", "getRepetitions", "()I", "getShowDecisionOutcomes", "()Z", "getDecision", "LGame/TerrainScene/Player/PlayerDecision;", "player", "LGame/TerrainScene/Player/Player;", "getDistanceToNearestAliveTankExcept", "", "exceptThisTank", "LGame/TerrainScene/Tank;", "pos", "LEngine/Pos2D;", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nMonteCarloCpu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonteCarloCpu.kt\nGame/TerrainScene/Player/MonteCarloCpu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n774#2:56\n865#2,2:57\n*S KotlinDebug\n*F\n+ 1 MonteCarloCpu.kt\nGame/TerrainScene/Player/MonteCarloCpu\n*L\n47#1:56\n47#1:57,2\n*E\n"})
public final class MonteCarloCpu
extends Cpu {
    private final int repetitions;
    private final boolean showDecisionOutcomes;

    public MonteCarloCpu(int repetitions, boolean showDecisionOutcomes) {
        this.repetitions = repetitions;
        this.showDecisionOutcomes = showDecisionOutcomes;
    }

    public final int getRepetitions() {
        return this.repetitions;
    }

    public final boolean getShowDecisionOutcomes() {
        return this.showDecisionOutcomes;
    }

    @Override
    @NotNull
    public PlayerDecision getDecision(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Tank tank = player.getTank();
        if (tank != null) {
            Tank tank2 = tank;
            boolean bl = false;
            Player target = this.getRandomTargetExcept(player);
            RandomCpu randomCpu = new RandomCpu();
            PlayerDecision bestDecision = null;
            bestDecision = randomCpu.getDecision(player);
            Pos2D bestExplosionPosition = null;
            bestExplosionPosition = bestDecision.getSimulatedExplosionLocation(tank2);
            double distance = 0.0;
            Tank tank3 = target.getTank();
            Intrinsics.checkNotNull(tank3);
            distance = bestExplosionPosition.distance(tank3.getPosition());
            int n = this.repetitions;
            for (int i = 0; i < n; ++i) {
                int it = i;
                boolean bl2 = false;
                PlayerDecision otherDecision = randomCpu.getDecision(player);
                Pos2D explosionPosition = otherDecision.getSimulatedExplosionLocation(tank2);
                Tank tank4 = target.getTank();
                Intrinsics.checkNotNull(tank4);
                double otherDistance = explosionPosition.distance(tank4.getPosition());
                if (otherDistance < distance) {
                    bestDecision = otherDecision;
                    bestExplosionPosition = Pos2D.copy$default(explosionPosition, 0.0, 0.0, 3, null);
                    distance = otherDistance;
                }
                if (!this.showDecisionOutcomes) continue;
                Object object = MainKt.getGameWindow();
                if (object == null || (object = ((GameWindow)object).getGameRunner()) == null || (object = ((GameRunner)object).getCurrentGameScene()) == null) continue;
                Object it2 = object;
                boolean bl3 = false;
                Pos2D pos2D = Pos2D.copy$default(explosionPosition, 0.0, 0.0, 3, null);
                Color color = Color.WHITE;
                Intrinsics.checkNotNullExpressionValue(color, "WHITE");
                it2.add(new ProjectileTrail((IGameScene)it2, pos2D, color));
            }
            if (this.showDecisionOutcomes) {
                Object object = MainKt.getGameWindow();
                if (object != null && (object = ((GameWindow)object).getGameRunner()) != null && (object = ((GameRunner)object).getCurrentGameScene()) != null) {
                    Object it = object;
                    boolean bl4 = false;
                    Pos2D pos2D = Pos2D.copy$default(bestExplosionPosition, 0.0, 0.0, 3, null);
                    Color color = Color.BLACK;
                    Intrinsics.checkNotNullExpressionValue(color, "BLACK");
                    it.add(new ProjectileTrail((IGameScene)it, pos2D, color));
                }
            }
            return bestDecision;
        }
        return new RandomCpu().getDecision(player);
    }

    /*
     * Unable to fully structure code
     */
    public final double getDistanceToNearestAliveTankExcept(@NotNull Tank exceptThisTank, @NotNull Pos2D pos) {
        Intrinsics.checkNotNullParameter(exceptThisTank, "exceptThisTank");
        Intrinsics.checkNotNullParameter(pos, "pos");
        minDistance = 1.7976931348623157E308;
        $this$filter$iv = GameController.INSTANCE.getPlayers();
        $i$f$filter = false;
        var8_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Player)element$iv$iv;
            $i$a$-filter-MonteCarloCpu$getDistanceToNearestAliveTankExcept$1 = false;
            if (Intrinsics.areEqual(it.getTank(), exceptThisTank) || !it.getPlaying() || it.getTank() == null) ** GOTO lbl-1000
            v0 = it.getTank();
            if ((v0 != null ? v0.getEnergy() : 0) > 0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Player player : (List)destination$iv$iv) {
            v2 = player.getTank();
            v3 = v2 != null && (v2 = v2.getPosition()) != null ? v2.distance(pos) : 1.7976931348623157E308;
            d = v3;
            if (!(d < minDistance)) continue;
            minDistance = d;
        }
        return minDistance;
    }
}

