/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.IGameScene;
import Game.GameController;
import Game.TerrainScene.Explosion;
import Game.TerrainScene.Projectile;
import Game.TerrainScene.RasterTerrain;
import Game.TerrainScene.Weapon;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"LGame/TerrainScene/ExplosionWeapon;", "LGame/TerrainScene/Weapon;", "id", "", "name", "", "purchasePrice", "", "purchaseQuantity", "size", "<init>", "(ILjava/lang/String;DII)V", "getSize", "()I", "drawIcon", "", "g", "Ljava/awt/Graphics2D;", "x", "y", "onExplode", "terrain", "LGame/TerrainScene/RasterTerrain;", "gameScene", "LEngine/IGameScene;", "projectile", "LGame/TerrainScene/Projectile;", "TankWarsKotlin"})
public final class ExplosionWeapon
extends Weapon {
    private final int size;

    public ExplosionWeapon(int id, @NotNull String name, double purchasePrice, int purchaseQuantity, int size) {
        Intrinsics.checkNotNullParameter(name, "name");
        super(id, name, purchasePrice, purchaseQuantity);
        this.size = size;
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public void drawIcon(@NotNull Graphics2D g, int x, int y) {
        Intrinsics.checkNotNullParameter(g, "g");
        int iconSize = this.size / 8 + 2;
        g.fillOval(x + 16 - iconSize / 2, y + 16 - iconSize / 2, iconSize, iconSize);
    }

    @Override
    public void onExplode(@NotNull RasterTerrain terrain, @NotNull IGameScene gameScene, @NotNull Projectile projectile) {
        Intrinsics.checkNotNullParameter(terrain, "terrain");
        Intrinsics.checkNotNullParameter(gameScene, "gameScene");
        Intrinsics.checkNotNullParameter(projectile, "projectile");
        gameScene.remove(projectile);
        GameController.INSTANCE.setProjectilesFlying(GameController.INSTANCE.getProjectilesFlying() - 1);
        Projectile.Companion.getActiveProjectiles().remove(projectile);
        Explosion exp = new Explosion(gameScene, projectile.getPosition(), this.size, 20 + this.size / 3, () -> ExplosionWeapon.onExplode$lambda$0(terrain));
        gameScene.add(exp);
    }

    private static final Unit onExplode$lambda$0(RasterTerrain $terrain) {
        $terrain.setCrumble(true);
        return Unit.INSTANCE;
    }
}

