/*
 * Decompiled with CFR 0.152.
 */
package Game.TerrainScene;

import Engine.AudioHelper;
import Engine.DelayedAction;
import Engine.ExtensionsKt;
import Engine.GameObject2;
import Engine.GameRunner;
import Engine.GameScene;
import Engine.GameWindow;
import Engine.IGameObject;
import Engine.IGameScene;
import Engine.Pos2D;
import Game.BattleState;
import Game.GameController;
import Game.IState;
import Game.Menu.MenuScene;
import Game.Menu.MenuSceneKt;
import Game.Menu.Transition;
import Game.Status.StatusLine;
import Game.Status.StatusScene;
import Game.TerrainScene.BattleSceneKt;
import Game.TerrainScene.ChargeIndicator;
import Game.TerrainScene.CloudMaker;
import Game.TerrainScene.Explosion;
import Game.TerrainScene.Player.MonteCarloCpu;
import Game.TerrainScene.Player.Player;
import Game.TerrainScene.Player.PlayerDecision;
import Game.TerrainScene.Player.PlayerType;
import Game.TerrainScene.Projectile;
import Game.TerrainScene.ProjectileTrail;
import Game.TerrainScene.RasterTerrain;
import Game.TerrainScene.SnowMaker;
import Game.TerrainScene.Tank;
import Game.TerrainScene.TankInfoBar;
import Game.TerrainScene.Viewport;
import Game.TerrainScene.WeaponBar;
import Game.particles.Emitter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B>\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012#\b\u0002\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010V\u001a\u00020WH\u0016J\b\u0010X\u001a\u00020WH\u0002J\b\u0010Y\u001a\u00020WH\u0002J\b\u0010Z\u001a\u00020WH\u0002J\b\u0010[\u001a\u00020\fH\u0002J\u0006\u0010\\\u001a\u00020WJ\b\u0010]\u001a\u00020WH\u0002J\u0010\u0010>\u001a\u00020W2\u0006\u0010^\u001a\u00020_H\u0016J\u0010\u0010`\u001a\u00020W2\u0006\u0010^\u001a\u00020_H\u0016J\u0010\u0010a\u001a\u00020W2\u0006\u0010^\u001a\u00020bH\u0016J\b\u0010c\u001a\u00020WH\u0016J\b\u0010g\u001a\u00020WH\u0002J\b\u0010h\u001a\u00020WH\u0002J\b\u0010i\u001a\u00020WH\u0002J\b\u0010j\u001a\u00020WH\u0002J\u000e\u0010k\u001a\u00020W2\u0006\u0010l\u001a\u00020\fJ\u0010\u0010m\u001a\u00020W2\u0006\u0010n\u001a\u00020oH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R,\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0010\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0010\"\u0004\b:\u0010\u0018R\u001a\u0010;\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0010\"\u0004\b=\u0010\u0018R\u001e\u0010>\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010C\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010D\u001a\u00020EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u0014\"\u0004\bL\u0010%R\u001a\u0010M\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u0014\"\u0004\bO\u0010%R\u001c\u0010P\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u000e\u0010U\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010d\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010\u0010\"\u0004\bf\u0010\u0018\u00a8\u0006p"}, d2={"LGame/TerrainScene/BattleScene;", "LEngine/GameScene;", "terrainWidth", "", "getNextDecision", "Lkotlin/Function1;", "LGame/TerrainScene/Player/Player;", "Lkotlin/ParameterName;", "name", "currentPlayer", "LGame/TerrainScene/Player/PlayerDecision;", "tanksFallFromSky", "", "<init>", "(ILkotlin/jvm/functions/Function1;Z)V", "getTerrainWidth", "()I", "getGetNextDecision", "()Lkotlin/jvm/functions/Function1;", "getTanksFallFromSky", "()Z", "groundType", "getGroundType", "setGroundType", "(I)V", "skyType", "getSkyType", "setSkyType", "rasterTerrain", "LGame/TerrainScene/RasterTerrain;", "getRasterTerrain", "()LGame/TerrainScene/RasterTerrain;", "setRasterTerrain", "(LGame/TerrainScene/RasterTerrain;)V", "updatePlayersTurnOnNextPossibleOccasion", "getUpdatePlayersTurnOnNextPossibleOccasion", "setUpdatePlayersTurnOnNextPossibleOccasion", "(Z)V", "tankInfoBar", "LGame/TerrainScene/TankInfoBar;", "getTankInfoBar", "()LGame/TerrainScene/TankInfoBar;", "setTankInfoBar", "(LGame/TerrainScene/TankInfoBar;)V", "weaponBar", "LGame/TerrainScene/WeaponBar;", "getWeaponBar", "()LGame/TerrainScene/WeaponBar;", "setWeaponBar", "(LGame/TerrainScene/WeaponBar;)V", "skyImage", "Ljava/awt/image/BufferedImage;", "getSkyImage", "()Ljava/awt/image/BufferedImage;", "setSkyImage", "(Ljava/awt/image/BufferedImage;)V", "translationX", "getTranslationX", "setTranslationX", "translationY", "getTranslationY", "setTranslationY", "keyPressed", "getKeyPressed", "()Ljava/lang/Integer;", "setKeyPressed", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "viewport", "LGame/TerrainScene/Viewport;", "getViewport", "()LGame/TerrainScene/Viewport;", "setViewport", "(LGame/TerrainScene/Viewport;)V", "randomizeFirstTurn", "getRandomizeFirstTurn", "setRandomizeFirstTurn", "mouseWasMoved", "getMouseWasMoved", "setMouseWasMoved", "decision", "getDecision", "()LGame/TerrainScene/Player/PlayerDecision;", "setDecision", "(LGame/TerrainScene/Player/PlayerDecision;)V", "movePressBuffer", "load", "", "initializePlayers", "initializeGround", "initializeSky", "busy", "showDecisionOutcome", "handleKeyPressed", "e", "Ljava/awt/event/KeyEvent;", "keyReleased", "mouseMoved", "Ljava/awt/event/MouseEvent;", "update", "cpuCooldown", "getCpuCooldown", "setCpuCooldown", "carryOutDecision", "handleNextPlayersTurn", "handleBattleOver", "explodeDeadPlayers", "updateWind", "first", "draw", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nBattleScene.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleScene.kt\nGame/TerrainScene/BattleScene\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,530:1\n1755#2,3:531\n1863#2,2:534\n1755#2,3:536\n230#2,2:539\n774#2:542\n865#2,2:543\n1557#2:545\n1628#2,3:546\n295#2,2:549\n1863#2,2:551\n1#3:541\n*S KotlinDebug\n*F\n+ 1 BattleScene.kt\nGame/TerrainScene/BattleScene\n*L\n200#1:531,3\n275#1:534,2\n373#1:536,3\n374#1:539,2\n463#1:542\n463#1:543,2\n472#1:545\n472#1:546,3\n481#1:549,2\n514#1:551,2\n*E\n"})
public final class BattleScene
extends GameScene {
    private final int terrainWidth;
    @NotNull
    private final Function1<Player, PlayerDecision> getNextDecision;
    private final boolean tanksFallFromSky;
    private int groundType;
    private int skyType;
    @NotNull
    private RasterTerrain rasterTerrain;
    private boolean updatePlayersTurnOnNextPossibleOccasion;
    @NotNull
    private TankInfoBar tankInfoBar;
    @NotNull
    private WeaponBar weaponBar;
    @NotNull
    private BufferedImage skyImage;
    private int translationX;
    private int translationY;
    @Nullable
    private Integer keyPressed;
    @NotNull
    private Viewport viewport;
    private boolean randomizeFirstTurn;
    private boolean mouseWasMoved;
    @Nullable
    private PlayerDecision decision;
    private int movePressBuffer;
    private int cpuCooldown;

    public BattleScene(int terrainWidth, @NotNull Function1<? super Player, PlayerDecision> getNextDecision, boolean tanksFallFromSky) {
        int n;
        int n2;
        Integer[] integerArray;
        Intrinsics.checkNotNullParameter(getNextDecision, "getNextDecision");
        super(new Color(113, 136, 248), MainKt.getGameResX(), MainKt.getGameResY());
        this.terrainWidth = terrainWidth;
        this.getNextDecision = getNextDecision;
        this.tanksFallFromSky = tanksFallFromSky;
        if (GameController.INSTANCE.getGroundOption() == MenuSceneKt.getOPTION_GROUND_RANDOM()) {
            integerArray = new Integer[]{MenuSceneKt.getOPTION_GROUND_GRASS(), MenuSceneKt.getOPTION_GROUND_SNOW(), MenuSceneKt.getOPTION_GROUND_DESERT()};
            n2 = ((Number)ArraysKt.random(integerArray, (Random)Random.Default)).intValue();
        } else {
            n2 = this.groundType = GameController.INSTANCE.getGroundOption();
        }
        if (GameController.INSTANCE.getSkyOption() == MenuSceneKt.getOPTION_SKY_RANDOM()) {
            integerArray = new Integer[]{MenuSceneKt.getOPTION_SKY_BLUE(), MenuSceneKt.getOPTION_SKY_STARRY(), MenuSceneKt.getOPTION_SKY_EVENING()};
            n = ((Number)ArraysKt.random(integerArray, (Random)Random.Default)).intValue();
        } else {
            n = GameController.INSTANCE.getSkyOption();
        }
        this.skyType = n;
        this.rasterTerrain = new RasterTerrain(this, new Pos2D(0.0, 0.0), this.terrainWidth, this.getHeight(), this.groundType);
        this.tankInfoBar = new TankInfoBar(this, new Pos2D(0.0, 0.0));
        this.weaponBar = new WeaponBar(this, new Pos2D(0.0, 32.0));
        this.skyImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = GameController.INSTANCE.getGroundSizeOption() == MenuSceneKt.getOPTION_GROUNDSIZE_SMALL() ? 0 : Integer.MIN_VALUE;
        int n6 = GameController.INSTANCE.getGroundSizeOption() == MenuSceneKt.getOPTION_GROUNDSIZE_SMALL() ? 0 : Integer.MAX_VALUE;
        this.viewport = new Viewport(this, n3, n4, 0, 0, n5, n6, -400, 0);
        this.randomizeFirstTurn = true;
        this.movePressBuffer = 10;
    }

    public /* synthetic */ BattleScene(int n, Function1 function1, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            function1 = BattleScene::_init_$lambda$0;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(n, function1, bl);
    }

    public final int getTerrainWidth() {
        return this.terrainWidth;
    }

    @NotNull
    public final Function1<Player, PlayerDecision> getGetNextDecision() {
        return this.getNextDecision;
    }

    public final boolean getTanksFallFromSky() {
        return this.tanksFallFromSky;
    }

    public final int getGroundType() {
        return this.groundType;
    }

    public final void setGroundType(int n) {
        this.groundType = n;
    }

    public final int getSkyType() {
        return this.skyType;
    }

    public final void setSkyType(int n) {
        this.skyType = n;
    }

    @NotNull
    public final RasterTerrain getRasterTerrain() {
        return this.rasterTerrain;
    }

    public final void setRasterTerrain(@NotNull RasterTerrain rasterTerrain) {
        Intrinsics.checkNotNullParameter(rasterTerrain, "<set-?>");
        this.rasterTerrain = rasterTerrain;
    }

    public final boolean getUpdatePlayersTurnOnNextPossibleOccasion() {
        return this.updatePlayersTurnOnNextPossibleOccasion;
    }

    public final void setUpdatePlayersTurnOnNextPossibleOccasion(boolean bl) {
        this.updatePlayersTurnOnNextPossibleOccasion = bl;
    }

    @NotNull
    public final TankInfoBar getTankInfoBar() {
        return this.tankInfoBar;
    }

    public final void setTankInfoBar(@NotNull TankInfoBar tankInfoBar) {
        Intrinsics.checkNotNullParameter(tankInfoBar, "<set-?>");
        this.tankInfoBar = tankInfoBar;
    }

    @NotNull
    public final WeaponBar getWeaponBar() {
        return this.weaponBar;
    }

    public final void setWeaponBar(@NotNull WeaponBar weaponBar) {
        Intrinsics.checkNotNullParameter(weaponBar, "<set-?>");
        this.weaponBar = weaponBar;
    }

    @NotNull
    public final BufferedImage getSkyImage() {
        return this.skyImage;
    }

    public final void setSkyImage(@NotNull BufferedImage bufferedImage) {
        Intrinsics.checkNotNullParameter(bufferedImage, "<set-?>");
        this.skyImage = bufferedImage;
    }

    public final int getTranslationX() {
        return this.translationX;
    }

    public final void setTranslationX(int n) {
        this.translationX = n;
    }

    public final int getTranslationY() {
        return this.translationY;
    }

    public final void setTranslationY(int n) {
        this.translationY = n;
    }

    @Nullable
    public final Integer getKeyPressed() {
        return this.keyPressed;
    }

    public final void setKeyPressed(@Nullable Integer n) {
        this.keyPressed = n;
    }

    @NotNull
    public final Viewport getViewport() {
        return this.viewport;
    }

    public final void setViewport(@NotNull Viewport viewport) {
        Intrinsics.checkNotNullParameter(viewport, "<set-?>");
        this.viewport = viewport;
    }

    public final boolean getRandomizeFirstTurn() {
        return this.randomizeFirstTurn;
    }

    public final void setRandomizeFirstTurn(boolean bl) {
        this.randomizeFirstTurn = bl;
    }

    public final boolean getMouseWasMoved() {
        return this.mouseWasMoved;
    }

    public final void setMouseWasMoved(boolean bl) {
        this.mouseWasMoved = bl;
    }

    @Nullable
    public final PlayerDecision getDecision() {
        return this.decision;
    }

    public final void setDecision(@Nullable PlayerDecision playerDecision) {
        this.decision = playerDecision;
    }

    @Override
    public void load() {
        int it;
        GameController.INSTANCE.setState(new BattleState());
        this.add(new Transition(this, 0.0, 2, null));
        this.add(this.rasterTerrain);
        this.add(this.tankInfoBar);
        this.add(this.weaponBar);
        this.initializeSky();
        this.initializeGround();
        this.initializePlayers();
        this.updateWind(true);
        int n = Random.Default.nextInt(3);
        int n2 = 0;
        while (n2 < n) {
            it = n2++;
            boolean bl = false;
            CloudMaker.INSTANCE.make(this, new Pos2D(Random.Default.nextInt(0, this.terrainWidth), Random.Default.nextInt(0, 100)), Random.Default.nextInt(200, 400));
        }
        if (this.randomizeFirstTurn && GameController.INSTANCE.getPlayers().size() > 0) {
            n = Random.Default.nextInt(GameController.INSTANCE.getPlayers().size());
            n2 = 0;
            while (n2 < n) {
                it = n2++;
                boolean bl = false;
                GameController.INSTANCE.nextPlayersTurn();
            }
        }
        this.updatePlayersTurnOnNextPossibleOccasion = true;
    }

    private final void initializePlayers() {
        double margin = 40.0;
        int numPlayers = GameController.INSTANCE.getPlayers().size();
        double spaceBetweenTanks = numPlayers == 1 ? ((double)this.terrainWidth - margin) / 2.0 : ((double)this.terrainWidth - 2.0 * margin) / (double)(numPlayers - 1);
        double x = 0.0;
        x = margin;
        List randomIndices = CollectionsKt.shuffled(RangesKt.until(0, numPlayers));
        for (int i = 0; i < numPlayers; ++i) {
            int it = i;
            boolean bl = false;
            Player p = GameController.INSTANCE.getPlayers().get(((Number)randomIndices.get(it)).intValue());
            double y = 30.0;
            if (!this.tanksFallFromSky) {
                y = RasterTerrain.surfaceAt$default(this.rasterTerrain, (int)x, 0, 2, null);
            }
            Tank tank = new Tank(this, this.rasterTerrain, new Pos2D(x, y), p.getColor());
            tank.setFalling(true);
            p.setTank(tank);
            p.setPlaying(true);
            double f = Math.min(100.0, p.getFuel());
            tank.setFuel(f);
            p.setFuel(p.getFuel() - f);
            this.add(tank);
            x += spaceBetweenTanks;
        }
    }

    private final void initializeGround() {
        if (this.groundType == MenuSceneKt.getOPTION_GROUND_SNOW()) {
            this.add(new SnowMaker(this, new Pos2D(0.0, 0.0), this.terrainWidth));
        }
    }

    private final void initializeSky() {
        block9: {
            int n = this.skyType;
            if (n == MenuSceneKt.getOPTION_SKY_BLUE()) {
                Graphics2D g = this.skyImage.createGraphics();
                Color c = new Color(12, 138, 255);
                g.setColor(c);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                int bands = 60;
                int i = 1;
                while (true) {
                    c = ExtensionsKt.lighter(c, 150 / bands);
                    g.setColor(c);
                    g.fillRect(0, i * this.getHeight() / bands, this.getWidth(), this.getHeight() / bands);
                    if (i != bands) {
                        ++i;
                        continue;
                    }
                    break block9;
                    break;
                }
            }
            if (n == MenuSceneKt.getOPTION_SKY_STARRY()) {
                Graphics2D g = this.skyImage.createGraphics();
                Color c = new Color(0, 0, 50);
                g.setColor(c);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                int bands = 60;
                int i = 1;
                while (true) {
                    c = ExtensionsKt.lighter(c, 150 / bands);
                    g.setColor(c);
                    g.fillRect(0, i * this.getHeight() / bands, this.getWidth(), this.getHeight() / bands);
                    if (i == bands) break;
                    ++i;
                }
                g.setColor(new Color(128, 128, 255));
                for (i = 1; i < 101; ++i) {
                    int size = BattleSceneKt.getRandom().nextInt(2, 4);
                    g.fillArc(BattleSceneKt.getRandom().nextInt(0, this.getWidth()), BattleSceneKt.getRandom().nextInt(0, this.getHeight()), size, size, 0, 360);
                }
            } else if (n == MenuSceneKt.getOPTION_SKY_EVENING()) {
                Graphics2D g = this.skyImage.createGraphics();
                Color c = new Color(255, 155, 0);
                g.setColor(c);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                int bands = 60;
                int i = 1;
                while (true) {
                    c = ExtensionsKt.darker(c, 200 / bands);
                    g.setColor(c);
                    g.fillRect(0, i * this.getHeight() / bands, this.getWidth(), this.getHeight() / bands);
                    if (i == bands) break;
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean busy() {
        boolean bl;
        if (this.rasterTerrain.getCrumble()) return true;
        if (this.rasterTerrain.getEarthquake() != null) {
            return true;
        }
        Iterable $this$any$iv = GameController.INSTANCE.getPlayers();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                Player it = (Player)element$iv;
                boolean bl2 = false;
                if (it.getPlaying()) {
                    boolean bl3;
                    Tank tank = it.getTank();
                    if (tank != null) {
                        if (tank.getFalling()) {
                            return true;
                        }
                        bl3 = false;
                    } else {
                        bl3 = false;
                    }
                    if (bl3) {
                        return true;
                    }
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return true;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        if (GameController.INSTANCE.getProjectilesFlying() > 0) {
            return true;
        }
        if (GameController.INSTANCE.getExplosionsActive() > 0) {
            return true;
        }
        if (this.decision == null) return false;
        return true;
    }

    public final void showDecisionOutcome() {
        block0: {
            Object object;
            Player player;
            Player player2 = player = GameController.INSTANCE.getCurrentPlayer();
            boolean bl = false;
            Object object2 = player2;
            if (object2 == null || (object2 = ((Player)object2).getTank()) == null) break block0;
            Object tank = object = object2;
            boolean bl2 = false;
            Pos2D p = new PlayerDecision(player2, (int)((Tank)tank).getAngle(), ((Tank)tank).getPower(), 1).getSimulatedExplosionLocation((Tank)tank);
            IGameScene iGameScene = this;
            Pos2D pos2D = Pos2D.copy$default(p, 0.0, 0.0, 3, null);
            Color color = Color.BLACK;
            Intrinsics.checkNotNullExpressionValue(color, "BLACK");
            this.add(new ProjectileTrail(iGameScene, pos2D, color));
        }
    }

    private final void handleKeyPressed() {
        block13: {
            int n;
            Integer n2;
            Tank tank;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            Player player;
                                            block18: {
                                                block17: {
                                                    block16: {
                                                        block15: {
                                                            block14: {
                                                                block12: {
                                                                    Integer n3 = this.keyPressed;
                                                                    int n4 = 27;
                                                                    if (n3 != null && n3 == n4) {
                                                                        this.keyPressed = null;
                                                                        this.unload();
                                                                        Object object = MainKt.getGameWindow();
                                                                        if (object != null && (object = ((GameWindow)object).getGameRunner()) != null) {
                                                                            ((GameRunner)object).setCurrentGameScene(new MenuScene());
                                                                        }
                                                                        GameController.INSTANCE.onGoingToMenu();
                                                                        return;
                                                                    }
                                                                    if (this.busy()) {
                                                                        return;
                                                                    }
                                                                    if (this.updatePlayersTurnOnNextPossibleOccasion) {
                                                                        return;
                                                                    }
                                                                    Player player2 = player = GameController.INSTANCE.getCurrentPlayer();
                                                                    if ((player2 != null ? player2.getPlayerType() : null) != PlayerType.LocalHuman) {
                                                                        return;
                                                                    }
                                                                    tank = GameController.INSTANCE.getCurrentPlayersTank();
                                                                    Integer n5 = n2 = this.keyPressed;
                                                                    n = 37;
                                                                    if (n5 == null || n5 != n) break block12;
                                                                    Tank tank2 = tank;
                                                                    if (tank2 == null) break block13;
                                                                    tank2.onLeftKeyPressed();
                                                                    break block13;
                                                                }
                                                                Integer n6 = n2;
                                                                n = 39;
                                                                if (n6 == null || n6 != n) break block14;
                                                                Tank tank3 = tank;
                                                                if (tank3 == null) break block13;
                                                                tank3.onRightKeyPressed();
                                                                break block13;
                                                            }
                                                            Integer n7 = n2;
                                                            n = 38;
                                                            if (n7 == null || n7 != n) break block15;
                                                            Tank tank4 = tank;
                                                            if (tank4 == null) break block13;
                                                            Tank it = tank4;
                                                            boolean bl = false;
                                                            it.onUpKeyPressed();
                                                            if (!this.viewport.inside(it)) {
                                                                this.viewport.setFocus(it.getPosition());
                                                            }
                                                            break block13;
                                                        }
                                                        Integer n8 = n2;
                                                        n = 40;
                                                        if (n8 == null || n8 != n) break block16;
                                                        Tank tank5 = tank;
                                                        if (tank5 == null) break block13;
                                                        Tank it = tank5;
                                                        boolean bl = false;
                                                        it.onDownKeyPressed();
                                                        if (!this.viewport.inside(it)) {
                                                            this.viewport.setFocus(it.getPosition());
                                                        }
                                                        break block13;
                                                    }
                                                    Integer n9 = n2;
                                                    n = 10;
                                                    if (n9 != null && n9 == n) break block17;
                                                    Integer n10 = n2;
                                                    n = 32;
                                                    if (n10 == null || n10 != n) break block18;
                                                }
                                                this.keyPressed = null;
                                                Tank tank6 = tank;
                                                if (tank6 == null) break block13;
                                                tank6.onSpaceKeyPressed();
                                                break block13;
                                            }
                                            Integer n11 = n2;
                                            n = 9;
                                            if (n11 == null || n11 != n) break block19;
                                            this.keyPressed = null;
                                            player.cycleWeapon();
                                            break block13;
                                        }
                                        Integer n12 = n2;
                                        n = 69;
                                        if (n12 == null || n12 != n) break block20;
                                        Tank tank7 = tank;
                                        if (tank7 == null) break block13;
                                        tank7.addFire();
                                        break block13;
                                    }
                                    Integer n13 = n2;
                                    n = 85;
                                    if (n13 == null || n13 != n) break block21;
                                    Iterable $this$forEach$iv = GameController.INSTANCE.getPlayers();
                                    boolean $i$f$forEach = false;
                                    for (Object element$iv : $this$forEach$iv) {
                                        GameObject2 gameObject2;
                                        GameObject2 emitter;
                                        Player it = (Player)element$iv;
                                        boolean bl = false;
                                        GameObject2 gameObject22 = it.getTank();
                                        if (gameObject22 != null && (gameObject22 = ((Tank)gameObject22).getFireEmitter()) != null) {
                                            emitter = gameObject22;
                                            boolean bl2 = false;
                                            ((Emitter)emitter).setEmitTicksLeft(0);
                                        }
                                        Tank tank8 = it.getTank();
                                        if (tank8 != null) {
                                            tank8.setFireEmitter(null);
                                        }
                                        if ((gameObject2 = it.getTank()) != null && (gameObject2 = gameObject2.getSmokeEmitter()) != null) {
                                            emitter = gameObject2;
                                            boolean bl3 = false;
                                            ((Emitter)emitter).setEmitTicksLeft(0);
                                        }
                                        Tank tank9 = it.getTank();
                                        if (tank9 == null) continue;
                                        tank9.setSmokeEmitter(null);
                                    }
                                    break block13;
                                }
                                Integer n14 = n2;
                                n = 79;
                                if (n14 == null || n14 != n) break block22;
                                this.add(new Transition(this, 0.0, 2, null));
                                break block13;
                            }
                            Integer n15 = n2;
                            n = 83;
                            if (n15 == null || n15 != n) break block23;
                            this.keyPressed = null;
                            GameController.INSTANCE.setSkyOption((GameController.INSTANCE.getSkyOption() + 1) % 3);
                            this.skyType = GameController.INSTANCE.getSkyOption();
                            this.initializeSky();
                            break block13;
                        }
                        Integer n16 = n2;
                        n = 48;
                        if (n16 == null || n16 != n) break block24;
                        Tank tank10 = tank;
                        if (tank10 == null) break block13;
                        Tank it = tank10;
                        boolean bl = false;
                        it.setSize(it.getSize() + 1);
                        Tank.updateCanonXY$default(it, false, 1, null);
                        System.out.println((Object)("Tank size: " + it.getSize()));
                        break block13;
                    }
                    Integer n17 = n2;
                    n = 49;
                    if (n17 == null || n17 != n) break block25;
                    BufferedImage bufferedImage = this.rasterTerrain.getRasterImage();
                    Color color = Color.BLACK;
                    Intrinsics.checkNotNullExpressionValue(color, "BLACK");
                    RasterTerrain.addColoredTopLayer$default(this.rasterTerrain, bufferedImage, 2, color, 0, 0, 24, null);
                    break block13;
                }
                Integer n18 = n2;
                n = 50;
                if (n18 == null || n18 != n) break block26;
                CloudMaker.INSTANCE.make(this, new Pos2D(Random.Default.nextInt(0, this.terrainWidth), Random.Default.nextInt(0, 100)), Random.Default.nextInt(200, 400));
                break block13;
            }
            Integer n19 = n2;
            n = 57;
            if (n19 == null || n19 != n) break block13;
            Tank tank11 = tank;
            if (tank11 != null) {
                Tank it = tank11;
                boolean bl = false;
                it.setSize(it.getSize() - 1);
                Tank.updateCanonXY$default(it, false, 1, null);
                System.out.println((Object)("Tank size: " + it.getSize()));
            }
        }
    }

    @Override
    public void keyPressed(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.keyPressed = e.getKeyCode();
    }

    @Override
    public void keyReleased(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player = GameController.INSTANCE.getCurrentPlayer();
        if ((player != null ? player.getPlayerType() : null) != PlayerType.LocalHuman) {
            return;
        }
        Tank tank = GameController.INSTANCE.getCurrentPlayersTank();
        switch (e.getKeyCode()) {
            case 38: 
            case 40: {
                Tank tank2 = tank;
                if (tank2 != null) {
                    tank2.onUpOrDownKeyReleased();
                }
                break;
            }
            case 37: 
            case 39: {
                Tank tank3 = tank;
                if (tank3 != null) {
                    tank3.onLeftOrRightKeyReleased();
                }
                break;
            }
            case 10: 
            case 32: {
                Tank tank4 = tank;
                if (tank4 == null) break;
                tank4.onSpaceKeyReleased();
                break;
            }
        }
        this.keyPressed = null;
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        super.mouseMoved(e);
        this.mouseWasMoved = true;
        this.translationY = Math.min(180, e.getY() * 2 / MainKt.getScale() - 300);
        if (GameController.INSTANCE.getGroundSizeOption() == MenuSceneKt.getOPTION_GROUNDSIZE_SMALL()) {
            return;
        }
        if (GameController.INSTANCE.getGroundSizeOption() == MenuSceneKt.getOPTION_GROUNDSIZE_MEDIUM()) {
            this.translationX = e.getX() * 2 / MainKt.getScale();
        } else if (GameController.INSTANCE.getGroundSizeOption() == MenuSceneKt.getOPTION_GROUNDSIZE_LARGE()) {
            this.translationX = e.getX() * 4 / MainKt.getScale();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update() {
        block17: {
            block15: {
                block14: {
                    block19: {
                        block18: {
                            block16: {
                                this.handleKeyPressed();
                                if (!this.busy() && this.updatePlayersTurnOnNextPossibleOccasion) {
                                    this.handleNextPlayersTurn();
                                }
                                if (!this.mouseWasMoved) break block16;
                                this.mouseWasMoved = false;
                                this.viewport.setFocus(this.translationX, this.translationY);
                                break block17;
                            }
                            if (Projectile.Companion.getActiveProjectiles().size() <= 0) break block18;
                            p = (Projectile)CollectionsKt.first((Iterable)Projectile.Companion.getActiveProjectiles());
                            this.viewport.setFocus(p.getPosition());
                            break block17;
                        }
                        $this$any$iv = GameController.INSTANCE.getPlayers();
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block19;
                        v0 = false;
                        break block14;
                    }
                    for (Object element$iv : $this$any$iv) {
                        it = (Player)element$iv;
                        $i$a$-any-BattleScene$update$1 = false;
                        if (!it.getPlaying()) ** GOTO lbl-1000
                        v1 = it.getTank();
                        v2 = v1 != null ? v1.getFalling() : false;
                        if (v2) {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        v0 = true;
                        break block14;
                    }
                    v0 = false;
                }
                if (!v0) break block17;
                $this$first$iv = GameController.INSTANCE.getPlayers();
                $i$f$first = false;
                for (E element$iv : $this$first$iv) {
                    it = (Player)element$iv;
                    $i$a$-first-BattleScene$update$2 = false;
                    if (!it.getPlaying()) ** GOTO lbl-1000
                    v4 = it.getTank();
                    v5 = v4 != null ? v4.getFalling() : false;
                    if (v5) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    break block15;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            v7 = ((Player)element$iv).getTank();
            if (v7 != null && (v7 = v7.getPosition()) != null) {
                it = v7;
                $i$a$-let-BattleScene$update$3 = false;
                this.viewport.setFocus((Pos2D)it);
            }
        }
        this.viewport.update();
        if (GameController.INSTANCE.getGlowUp() > 0) {
            GameController.INSTANCE.setGlowUp(GameController.INSTANCE.getGlowUp() - 1);
        }
        if (GameController.INSTANCE.getPlayers().size() > 0) {
            v8 = GameController.INSTANCE.getCurrentPlayer();
            if ((v8 != null ? v8.getPlayerType() : null) == PlayerType.LocalCpu) {
                v9 = GameController.INSTANCE.getCurrentPlayersTank();
                v10 = v9 != null ? v9.getPlaying() : false;
                if (v10) {
                    if (this.cpuCooldown > 0) {
                        --this.cpuCooldown;
                    } else {
                        this.carryOutDecision();
                    }
                }
            }
        }
        super.update();
    }

    public final int getCpuCooldown() {
        return this.cpuCooldown;
    }

    public final void setCpuCooldown(int n) {
        this.cpuCooldown = n;
    }

    private final void carryOutDecision() {
        block3: {
            Object tank;
            PlayerDecision it;
            block6: {
                block5: {
                    block4: {
                        PlayerDecision playerDecision = this.decision;
                        if (playerDecision == null) break block3;
                        it = playerDecision;
                        boolean bl = false;
                        Player player = GameController.INSTANCE.getCurrentPlayer();
                        Object object = player;
                        if (object == null || (object = ((Player)object).getTank()) == null) {
                            return;
                        }
                        tank = object;
                        Integer n = player.getWeaponry().get(it.getWeaponId());
                        if ((n != null ? n : 0) <= 0 || player.getCurrentWeaponId() == it.getWeaponId()) break block4;
                        player.cycleWeapon();
                        this.cpuCooldown += (int)(BattleSceneKt.getRandom().nextDouble(GameRunner.Companion.getFps()) + GameRunner.Companion.getFps() / (double)4);
                        break block3;
                    }
                    if ((int)((Tank)tank).getAngle() >= it.getAngle()) break block5;
                    ((Tank)tank).increaseAngle(1);
                    AudioHelper.loop$default(AudioHelper.INSTANCE, "change-angle", 0, 2, null);
                    break block3;
                }
                if ((int)((Tank)tank).getAngle() <= it.getAngle()) break block6;
                ((Tank)tank).increaseAngle(-1);
                AudioHelper.loop$default(AudioHelper.INSTANCE, "change-angle", 0, 2, null);
                break block3;
            }
            AudioHelper.INSTANCE.stop("change-angle");
            if (((Tank)tank).getChargeIndicator() == null) {
                ChargeIndicator chargeIndicator = new ChargeIndicator(this, new Pos2D((double)((Tank)tank).getCanonX(), (double)((Tank)tank).getCanonY()), (Tank)tank, it.getPower());
                this.add(chargeIndicator);
                ((Tank)tank).setChargeIndicator(chargeIndicator);
            }
            ChargeIndicator chargeIndicator = ((Tank)tank).getChargeIndicator();
            if (chargeIndicator == null) break block3;
            ChargeIndicator chargeIndicator2 = chargeIndicator;
            boolean bl = false;
            if (chargeIndicator2.getCharge() > (double)it.getPower()) {
                chargeIndicator2.setCharge(it.getPower());
                this.remove(chargeIndicator2);
                ((Tank)tank).setChargeIndicator(null);
                this.decision = null;
            }
        }
    }

    private final void handleNextPlayersTurn() {
        if (GameController.INSTANCE.getPlayers().size() == 0) {
            return;
        }
        this.explodeDeadPlayers();
        if (!this.busy()) {
            this.updatePlayersTurnOnNextPossibleOccasion = false;
            GameController.INSTANCE.nextPlayersTurn();
            IState iState = GameController.INSTANCE.getState();
            Intrinsics.checkNotNull(iState, "null cannot be cast to non-null type Game.BattleState");
            if (((BattleState)iState).isBattleOver()) {
                this.handleBattleOver();
            } else {
                this.updateWind(false);
                Tank tank = GameController.INSTANCE.getCurrentPlayersTank();
                if (tank != null) {
                    Tank it = tank;
                    boolean bl = false;
                    this.viewport.setFocus(it.getPosition());
                }
            }
            Player player = GameController.INSTANCE.getCurrentPlayer();
            if (player == null) {
                return;
            }
            Player currentPlayer = player;
            if (currentPlayer.getPlayerType() == PlayerType.LocalCpu && this.decision == null) {
                new DelayedAction(this, 1.0, () -> BattleScene.handleNextPlayersTurn$lambda$20(this, currentPlayer));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void handleBattleOver() {
        block5: {
            team = GameController.INSTANCE.getCurrentPlayersTeam();
            $this$filter$iv = team.getPlayers();
            $i$f$filter = false;
            var4_5 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Player)element$iv$iv;
                $i$a$-filter-BattleScene$handleBattleOver$1 = false;
                if (!it.getPlaying()) ** GOTO lbl-1000
                v0 = it.getTank();
                if ((v0 != null ? v0.getEnergy() : 0) > 0) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            survivors = (List)destination$iv$iv;
            $i$a$-let-BattleScene$handleBattleOver$2 = false;
            for (Player player : survivors) {
                player.setMoney(player.getMoney() + (double)100);
                v2 = player.getTank();
                player.setFuel(player.getFuel() + (v2 != null ? v2.getFuel() : 0.0));
            }
            team.setVictories(team.getVictories() + 1);
            GameController.INSTANCE.setGamesPlayed(GameController.INSTANCE.getGamesPlayed() + 1);
            $this$map$iv = GameController.INSTANCE.getPlayers();
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                $i$a$-filter-BattleScene$handleBattleOver$1 = (Player)item$iv$iv;
                var12_18 = destination$iv$iv;
                $i$a$-map-BattleScene$handleBattleOver$statusLines$1 = false;
                var12_18.add(new StatusLine(it.getName(), it.victories(), it.getMoney(), it.getColor()));
            }
            statusLines = (List)destination$iv$iv;
            this.unload();
            v3 = MainKt.getGameWindow();
            if (v3 == null || (v3 = v3.getGameRunner()) == null) break block5;
            v3.setCurrentGameScene(new StatusScene(statusLines));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void explodeDeadPlayers() {
        block4: {
            $this$firstOrNull$iv = GameController.INSTANCE.getPlayers();
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (Player)element$iv;
                $i$a$-firstOrNull-BattleScene$explodeDeadPlayers$deadPlayer$1 = false;
                if (!it.getPlaying()) ** GOTO lbl-1000
                v0 = it.getTank();
                v1 = v0 != null ? v0.getEnergy() == 0 : false;
                if (v1) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        v4 = deadPlayer = (Player)v3;
        v5 = deadTank = v4 != null ? v4.getTank() : null;
        if (deadPlayer != null && deadTank != null) {
            deadTank.onDie();
            this.remove(deadTank);
            deadTank.setPlaying(false);
            deadPlayer.setPlaying(false);
            this.viewport.setFocus(deadTank.getPosition());
            this.add(new Explosion(this, deadTank.getPosition(), 100, 40, (Function0<Unit>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, explodeDeadPlayers$lambda$25(), ()Lkotlin/Unit;)()));
        }
    }

    public final void updateWind(boolean first) {
        if (first) {
            int n = GameController.INSTANCE.getWindOption();
            GameController.INSTANCE.setWind(n == MenuSceneKt.getOPTION_WIND_NONE() ? 0.0 : (n == MenuSceneKt.getOPTION_WIND_LIGHT() ? -1.0 + BattleSceneKt.getRandom().nextDouble() * 2.0 : (n == MenuSceneKt.getOPTION_WIND_MEDIUM() ? -2.0 + BattleSceneKt.getRandom().nextDouble() * 4.0 : (n == MenuSceneKt.getOPTION_WIND_STRONG() ? -8.0 + BattleSceneKt.getRandom().nextDouble() * 16.0 : 0.0))));
        } else {
            GameController.INSTANCE.setWind(GameController.INSTANCE.getWindOption() == MenuSceneKt.getOPTION_WIND_NONE() ? 0.0 : GameController.INSTANCE.getWind() + BattleSceneKt.getRandom().nextDouble(-Math.abs(GameController.INSTANCE.getWind() * 0.05), Math.abs(GameController.INSTANCE.getWind() * 0.05)));
        }
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.drawImage(this.skyImage, null, 0, 0);
        g.translate(-this.viewport.getX(), -this.viewport.getY());
        Iterable $this$forEach$iv = this.getGameObjectsByDrawOrder$TankWarsKotlin();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IGameObject it = (IGameObject)element$iv;
            boolean bl = false;
            if (it instanceof RasterTerrain) {
                ((RasterTerrain)it).draw(g);
                continue;
            }
            if (it instanceof WeaponBar) {
                ((WeaponBar)it).draw(g);
                continue;
            }
            if (it instanceof TankInfoBar) {
                ((TankInfoBar)it).draw(g);
                continue;
            }
            if (!(it instanceof GameObject2) || !this.viewport.inside((GameObject2)it)) continue;
            ((GameObject2)it).draw(g);
        }
    }

    private static final PlayerDecision _init_$lambda$0(Player it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new MonteCarloCpu(10, false).getDecision(it);
    }

    private static final Unit handleNextPlayersTurn$lambda$20(BattleScene this$0, Player $currentPlayer) {
        this$0.decision = this$0.getNextDecision.invoke($currentPlayer);
        return Unit.INSTANCE;
    }

    private static final Unit explodeDeadPlayers$lambda$25() {
        return Unit.INSTANCE;
    }
}

