/*
 * Decompiled with CFR 0.152.
 */
package Game.Menu;

import Engine.AudioHelper;
import Engine.ExtensionsKt;
import Engine.GameObject2;
import Engine.GameScene;
import Engine.IGameScene;
import Engine.Pos2D;
import Game.Menu.MenuPoints.MenuPointGameObject;
import Game.Menu.MenuPoints.NumberSelectorMenuPoint;
import Game.Menu.MenuPoints.OptionSelectorMenuPoint;
import Game.Menu.MenuPoints.TextInputMenuPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0006\u0010>\u001a\u00020\u0005J\u0010\u0010F\u001a\u00020\u00112\b\u0010G\u001a\u0004\u0018\u00010HJ\u0006\u0010I\u001a\u00020\u0011J\u0006\u0010J\u001a\u00020\u0011J\u0006\u0010K\u001a\u00020\u0011J\u0006\u0010L\u001a\u00020\u0011J\u0006\u0010M\u001a\u00020\u0011J\u0006\u0010N\u001a\u00020\u0011J\u0006\u0010O\u001a\u00020\u0011J\u0010\u0010P\u001a\u00020\u00112\b\u0010G\u001a\u0004\u0018\u00010HJ\u0010\u0010Q\u001a\u00020\u00112\b\u0010G\u001a\u0004\u0018\u00010HJ\b\u0010R\u001a\u00020\u0011H\u0016J\u0010\u0010S\u001a\u00020\u00112\u0006\u0010T\u001a\u00020UH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001e\"\u0004\b\"\u0010 R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010\u0014\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010*\"\u0004\b.\u0010,R\u001a\u0010/\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001e\"\u0004\b1\u0010 R\u001a\u00102\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001e\"\u0004\b4\u0010 R\u001a\u00105\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0018\"\u0004\b7\u0010\u001aR\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0011\u0010?\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR&\u0010C\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0018\"\u0004\bE\u0010\u001a\u00a8\u0006V"}, d2={"LGame/Menu/MenuGameObject;", "LEngine/GameObject2;", "parent", "LEngine/IGameScene;", "position", "LEngine/Pos2D;", "width", "", "height", "ySpacing", "", "leftMargin", "menuPoints", "", "LGame/Menu/MenuPoints/MenuPointGameObject;", "onEscapePressed", "Lkotlin/Function0;", "", "color", "Ljava/awt/Color;", "strokeColor", "<init>", "(LEngine/IGameScene;LEngine/Pos2D;IIDDLjava/util/List;Lkotlin/jvm/functions/Function0;Ljava/awt/Color;Ljava/awt/Color;)V", "getWidth", "()I", "setWidth", "(I)V", "getHeight", "setHeight", "getYSpacing", "()D", "setYSpacing", "(D)V", "getLeftMargin", "setLeftMargin", "getMenuPoints", "()Ljava/util/List;", "setMenuPoints", "(Ljava/util/List;)V", "getOnEscapePressed", "()Lkotlin/jvm/functions/Function0;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "getStrokeColor", "setStrokeColor", "x", "getX", "setX", "y", "getY", "setY", "drawOrder", "getDrawOrder", "setDrawOrder", "stroke", "Ljava/awt/BasicStroke;", "getStroke", "()Ljava/awt/BasicStroke;", "setStroke", "(Ljava/awt/BasicStroke;)V", "nextMenuPointPos", "selected", "getSelected", "()LGame/Menu/MenuPoints/MenuPointGameObject;", "idx", "selectedIdx", "getSelectedIdx", "setSelectedIdx", "keyTyped", "e", "Ljava/awt/event/KeyEvent;", "selectNext", "selectPrevious", "decreaseValue", "increaseValue", "deleteCharacter", "activate", "escape", "keyPressed", "keyReleased", "update", "draw", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nMenuGameObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MenuGameObject.kt\nGame/Menu/MenuGameObject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1863#2,2:153\n1863#2,2:155\n*S KotlinDebug\n*F\n+ 1 MenuGameObject.kt\nGame/Menu/MenuGameObject\n*L\n44#1:153,2\n68#1:155,2\n*E\n"})
public final class MenuGameObject
extends GameObject2 {
    private int width;
    private int height;
    private double ySpacing;
    private double leftMargin;
    @NotNull
    private List<MenuPointGameObject> menuPoints;
    @NotNull
    private final Function0<Unit> onEscapePressed;
    @NotNull
    private Color color;
    @NotNull
    private Color strokeColor;
    private double x;
    private double y;
    private int drawOrder;
    @NotNull
    private BasicStroke stroke;
    private int selectedIdx;

    public MenuGameObject(@NotNull IGameScene parent, @NotNull Pos2D position, int width, int height, double ySpacing, double leftMargin, @NotNull List<MenuPointGameObject> menuPoints, @NotNull Function0<Unit> onEscapePressed, @NotNull Color color, @NotNull Color strokeColor) {
        MenuPointGameObject it;
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(menuPoints, "menuPoints");
        Intrinsics.checkNotNullParameter(onEscapePressed, "onEscapePressed");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(strokeColor, "strokeColor");
        super(parent, position);
        this.width = width;
        this.height = height;
        this.ySpacing = ySpacing;
        this.leftMargin = leftMargin;
        this.menuPoints = menuPoints;
        this.onEscapePressed = onEscapePressed;
        this.color = color;
        this.strokeColor = strokeColor;
        this.x = position.getX() + this.leftMargin;
        this.y = position.getY();
        this.drawOrder = -1;
        this.stroke = new BasicStroke(3.0f);
        Iterable $this$forEach$iv = this.menuPoints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MenuPointGameObject)element$iv;
            boolean bl = false;
            it.setPosition(this.nextMenuPointPos());
            it.setUnselectedColor(ExtensionsKt.darker(this.strokeColor, 30));
            it.setSelectedColor(ExtensionsKt.contrast(ExtensionsKt.lighter(ExtensionsKt.redder(this.strokeColor, 150), 50), 1.5));
        }
        $this$forEach$iv = this.menuPoints;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MenuPointGameObject)element$iv;
            boolean bl = false;
            parent.add(it);
        }
        this.setSelectedIdx(0);
        this.height = (int)(((double)this.menuPoints.size() + 0.5) * this.ySpacing);
    }

    public /* synthetic */ MenuGameObject(IGameScene iGameScene, Pos2D pos2D, int n, int n2, double d, double d2, List list, Function0 function0, Color color, Color color2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            d = 40.0;
        }
        if ((n3 & 0x20) != 0) {
            d2 = 20.0;
        }
        if ((n3 & 0x100) != 0) {
            Intrinsics.checkNotNull(iGameScene, "null cannot be cast to non-null type Engine.GameScene");
            color = ExtensionsKt.lighter(((GameScene)iGameScene).getColor(), 20);
        }
        if ((n3 & 0x200) != 0) {
            Intrinsics.checkNotNull(iGameScene, "null cannot be cast to non-null type Engine.GameScene");
            color2 = ExtensionsKt.darker(((GameScene)iGameScene).getColor(), 40);
        }
        this(iGameScene, pos2D, n, n2, d, d2, list, function0, color, color2);
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final double getYSpacing() {
        return this.ySpacing;
    }

    public final void setYSpacing(double d) {
        this.ySpacing = d;
    }

    public final double getLeftMargin() {
        return this.leftMargin;
    }

    public final void setLeftMargin(double d) {
        this.leftMargin = d;
    }

    @NotNull
    public final List<MenuPointGameObject> getMenuPoints() {
        return this.menuPoints;
    }

    public final void setMenuPoints(@NotNull List<MenuPointGameObject> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.menuPoints = list;
    }

    @NotNull
    public final Function0<Unit> getOnEscapePressed() {
        return this.onEscapePressed;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.color = color;
    }

    @NotNull
    public final Color getStrokeColor() {
        return this.strokeColor;
    }

    public final void setStrokeColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.strokeColor = color;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    @Override
    public int getDrawOrder() {
        return this.drawOrder;
    }

    @Override
    public void setDrawOrder(int n) {
        this.drawOrder = n;
    }

    @NotNull
    public final BasicStroke getStroke() {
        return this.stroke;
    }

    public final void setStroke(@NotNull BasicStroke basicStroke) {
        Intrinsics.checkNotNullParameter(basicStroke, "<set-?>");
        this.stroke = basicStroke;
    }

    @NotNull
    public final Pos2D nextMenuPointPos() {
        this.y += this.ySpacing;
        return new Pos2D(this.x, this.y);
    }

    @NotNull
    public final MenuPointGameObject getSelected() {
        return this.menuPoints.get(this.getSelectedIdx());
    }

    public final int getSelectedIdx() {
        return this.selectedIdx;
    }

    public final void setSelectedIdx(int idx) {
        if (idx < 0 || idx >= this.menuPoints.size()) {
            throw new Exception("Cannot set selectedIdx menu point idx to " + idx + ", because menuPoints.size == " + this.menuPoints.size());
        }
        this.menuPoints.get(this.getSelectedIdx()).setSelected(false);
        this.selectedIdx = idx;
        this.menuPoints.get(this.selectedIdx).setSelected(true);
    }

    public final void keyTyped(@Nullable KeyEvent e) {
        block3: {
            if (e == null) break block3;
            MenuPointGameObject menuPointGameObject = this.getSelected();
            TextInputMenuPoint textInputMenuPoint = menuPointGameObject instanceof TextInputMenuPoint ? (TextInputMenuPoint)menuPointGameObject : null;
            if (textInputMenuPoint != null) {
                MenuPointGameObject $this$keyTyped_u24lambda_u242 = menuPointGameObject = textInputMenuPoint;
                boolean bl = false;
                if (e.getKeyChar() == '\b') {
                    String string = ((TextInputMenuPoint)$this$keyTyped_u24lambda_u242).getTextValue().substring(0, ((TextInputMenuPoint)$this$keyTyped_u24lambda_u242).getTextValue().length());
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    ((TextInputMenuPoint)$this$keyTyped_u24lambda_u242).setTextValue(string);
                } else {
                    ((TextInputMenuPoint)$this$keyTyped_u24lambda_u242).setTextValue(((TextInputMenuPoint)$this$keyTyped_u24lambda_u242).getTextValue() + e.getKeyChar());
                }
            }
        }
    }

    public final void selectNext() {
        AudioHelper.INSTANCE.play("swoosh");
        this.setSelectedIdx((this.getSelectedIdx() + 1) % this.menuPoints.size());
    }

    public final void selectPrevious() {
        AudioHelper.INSTANCE.play("swoosh2");
        this.setSelectedIdx(this.getSelectedIdx() == 0 ? this.menuPoints.size() - 1 : this.getSelectedIdx() - 1);
    }

    public final void decreaseValue() {
        block1: {
            MenuPointGameObject menuPointGameObject = this.getSelected();
            NumberSelectorMenuPoint numberSelectorMenuPoint = menuPointGameObject instanceof NumberSelectorMenuPoint ? (NumberSelectorMenuPoint)menuPointGameObject : null;
            if (numberSelectorMenuPoint != null) {
                numberSelectorMenuPoint.decrease();
            }
            menuPointGameObject = this.getSelected();
            OptionSelectorMenuPoint optionSelectorMenuPoint = menuPointGameObject instanceof OptionSelectorMenuPoint ? (OptionSelectorMenuPoint)menuPointGameObject : null;
            if (optionSelectorMenuPoint == null) break block1;
            optionSelectorMenuPoint.decrease();
        }
    }

    public final void increaseValue() {
        block1: {
            MenuPointGameObject menuPointGameObject = this.getSelected();
            NumberSelectorMenuPoint numberSelectorMenuPoint = menuPointGameObject instanceof NumberSelectorMenuPoint ? (NumberSelectorMenuPoint)menuPointGameObject : null;
            if (numberSelectorMenuPoint != null) {
                numberSelectorMenuPoint.increase();
            }
            menuPointGameObject = this.getSelected();
            OptionSelectorMenuPoint optionSelectorMenuPoint = menuPointGameObject instanceof OptionSelectorMenuPoint ? (OptionSelectorMenuPoint)menuPointGameObject : null;
            if (optionSelectorMenuPoint == null) break block1;
            optionSelectorMenuPoint.increase();
        }
    }

    public final void deleteCharacter() {
        block1: {
            MenuPointGameObject menuPointGameObject = this.getSelected();
            TextInputMenuPoint textInputMenuPoint = menuPointGameObject instanceof TextInputMenuPoint ? (TextInputMenuPoint)menuPointGameObject : null;
            if (textInputMenuPoint == null) break block1;
            MenuPointGameObject $this$deleteCharacter_u24lambda_u243 = menuPointGameObject = textInputMenuPoint;
            boolean bl = false;
            if (((TextInputMenuPoint)$this$deleteCharacter_u24lambda_u243).getTextValue().length() > 0) {
                String string = ((TextInputMenuPoint)$this$deleteCharacter_u24lambda_u243).getTextValue().substring(0, ((TextInputMenuPoint)$this$deleteCharacter_u24lambda_u243).getTextValue().length() - 1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                ((TextInputMenuPoint)$this$deleteCharacter_u24lambda_u243).setTextValue(string);
            }
        }
    }

    public final void activate() {
        AudioHelper.INSTANCE.play("bamboo01");
        this.getSelected().getOnActivate().invoke();
    }

    public final void escape() {
        AudioHelper.INSTANCE.play("bamboo02");
        this.onEscapePressed.invoke();
    }

    public final void keyPressed(@Nullable KeyEvent e) {
        KeyEvent keyEvent = e;
        boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 40 : false;
        if (bl) {
            this.selectNext();
        } else {
            KeyEvent keyEvent2 = e;
            boolean bl2 = keyEvent2 != null ? keyEvent2.getKeyCode() == 38 : false;
            if (bl2) {
                this.selectPrevious();
            } else {
                KeyEvent keyEvent3 = e;
                boolean bl3 = keyEvent3 != null ? keyEvent3.getKeyCode() == 37 : false;
                if (bl3) {
                    this.decreaseValue();
                } else {
                    KeyEvent keyEvent4 = e;
                    boolean bl4 = keyEvent4 != null ? keyEvent4.getKeyCode() == 39 : false;
                    if (bl4) {
                        this.increaseValue();
                    } else {
                        KeyEvent keyEvent5 = e;
                        boolean bl5 = keyEvent5 != null ? keyEvent5.getKeyCode() == 8 : false;
                        if (bl5) {
                            this.deleteCharacter();
                        } else {
                            KeyEvent keyEvent6 = e;
                            boolean bl6 = keyEvent6 != null ? keyEvent6.getKeyCode() == 10 : false;
                            if (bl6) {
                                this.activate();
                            } else {
                                KeyEvent keyEvent7 = e;
                                boolean bl7 = keyEvent7 != null ? keyEvent7.getKeyCode() == 27 : false;
                                if (bl7) {
                                    this.escape();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public final void keyReleased(@Nullable KeyEvent e) {
    }

    @Override
    public void update() {
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(this.strokeColor);
        g.setStroke(this.stroke);
        g.drawRect((int)this.getPosition().getX(), (int)this.getPosition().getY(), this.width, this.height);
        g.setColor(this.color);
        g.fillRect((int)this.getPosition().getX() + 2, (int)this.getPosition().getY() + 2, this.width - 3, this.height - 3);
    }
}

