/*
 * Decompiled with CFR 0.152.
 */
package Game.Menu;

import Engine.GameObject2;
import Engine.GameScene;
import Engine.Pos2D;
import Engine.Vec2D;
import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"LGame/Menu/FloatingBlob;", "LEngine/GameObject2;", "parent", "LEngine/GameScene;", "<init>", "(LEngine/GameScene;)V", "size", "", "getSize", "()I", "velocity", "LEngine/Vec2D;", "getVelocity", "()LEngine/Vec2D;", "colorMargin", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "tick", "getTick", "setTick", "(I)V", "update", "", "draw", "g", "Ljava/awt/Graphics2D;", "TankWarsKotlin"})
public final class FloatingBlob
extends GameObject2 {
    private final int size;
    @NotNull
    private final Vec2D velocity;
    private final int colorMargin;
    @NotNull
    private Color color;
    private int tick;

    public FloatingBlob(@NotNull GameScene parent) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        super(parent, new Pos2D(0.0, 0.0));
        this.size = Random.Default.nextInt(120, 560);
        this.velocity = new Vec2D(Random.Default.nextDouble(-1.0, 1.0), Random.Default.nextDouble(-1.0, 1.0));
        this.colorMargin = 20;
        this.color = new Color(Random.Default.nextInt(Math.max(0, parent.getColor().getRed() - this.colorMargin), Math.min(255, parent.getColor().getRed() + this.colorMargin)), Random.Default.nextInt(Math.max(0, parent.getColor().getGreen() - this.colorMargin), Math.min(255, parent.getColor().getGreen() + this.colorMargin)), Random.Default.nextInt(Math.max(0, parent.getColor().getBlue() - this.colorMargin), Math.min(255, parent.getColor().getBlue() + this.colorMargin)));
        this.setDrawOrder(-100);
        this.getPosition().setX(Random.Default.nextDouble((double)(-this.size) / 2.0, (double)parent.getWidth() + (double)this.size / 2.0));
        this.getPosition().setY(Random.Default.nextDouble((double)(-this.size) / 2.0, (double)parent.getHeight() + (double)this.size / 2.0));
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final Vec2D getVelocity() {
        return this.velocity;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.color = color;
    }

    public final int getTick() {
        return this.tick;
    }

    public final void setTick(int n) {
        this.tick = n;
    }

    @Override
    public void update() {
        ++this.tick;
        Object object = this.getPosition();
        ((Pos2D)object).setX(((Pos2D)object).getX() + this.velocity.getX());
        object = this.getPosition();
        ((Pos2D)object).setY(((Pos2D)object).getY() + this.velocity.getY());
        object = this.velocity;
        ((Vec2D)object).setX(((Vec2D)object).getX() * 0.99);
        object = this.velocity;
        ((Vec2D)object).setY(((Vec2D)object).getY() * 0.99);
        if (this.getPosition().getX() < (double)(-this.size) / 2.0) {
            this.getPosition().setX((double)this.getParent().getWidth() + (double)this.size / 2.0);
        } else if (this.getPosition().getX() > (double)this.getParent().getWidth() + (double)this.size / 2.0) {
            this.getPosition().setX((double)(-this.size) / 2.0);
        }
        if (this.getPosition().getY() < (double)(-this.size) / 2.0) {
            this.getPosition().setY((double)this.getParent().getHeight() + (double)this.size / 2.0);
        } else if (this.getPosition().getY() >= (double)this.getParent().getHeight() + (double)this.size / 2.0) {
            this.getPosition().setY((double)(-this.size) / 2.0);
        }
        if (this.tick % this.size == 0) {
            this.velocity.setX(Random.Default.nextDouble(-1.0, 1.0));
            this.velocity.setY(Random.Default.nextDouble(-1.0, 1.0));
        }
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        g.setColor(this.color);
        g.fillArc((int)(this.getPosition().getX() - (double)(this.size / 2)), (int)(this.getPosition().getY() - (double)(this.size / 2)), this.size, this.size, 0, 360);
    }
}

