/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.GameController;
import Game.IState;
import Game.Team;
import Game.TerrainScene.Player.Player;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"LGame/BattleState;", "LGame/IState;", "<init>", "()V", "turnIndex", "", "getTurnIndex", "()I", "setTurnIndex", "(I)V", "nextTurn", "", "players", "", "LGame/TerrainScene/Player/Player;", "currentPlayer", "isBattleOver", "", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nGameController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameController.kt\nGame/BattleState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1755#2,3:118\n*S KotlinDebug\n*F\n+ 1 GameController.kt\nGame/BattleState\n*L\n106#1:118,3\n*E\n"})
public final class BattleState
implements IState {
    private int turnIndex;

    public final int getTurnIndex() {
        return this.turnIndex;
    }

    public final void setTurnIndex(int n) {
        this.turnIndex = n;
    }

    public final void nextTurn(@NotNull List<Player> players) {
        Intrinsics.checkNotNullParameter(players, "players");
        int oldIndex = this.turnIndex;
        do {
            int n = this.turnIndex + 1;
            int n2 = players.size();
            int n3 = n % n2;
            this.turnIndex = n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31);
        } while (!players.get(this.turnIndex).getPlaying() && this.turnIndex != oldIndex);
    }

    @Nullable
    public final Player currentPlayer(@NotNull List<Player> players) {
        Intrinsics.checkNotNullParameter(players, "players");
        return CollectionsKt.getOrNull(players, this.turnIndex);
    }

    public final boolean isBattleOver() {
        int numTeamsWithAliveTanks = 0;
        for (Team t : GameController.INSTANCE.getTeams()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = t.getPlayers();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Player it = (Player)element$iv;
                        boolean bl2 = false;
                        if (!it.getPlaying()) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl || ++numTeamsWithAliveTanks <= 1) continue;
            return false;
        }
        return true;
    }
}

