/*
 * Decompiled with CFR 0.152.
 */
package Experimental.CollisionBalls;

import Engine.GameScene;
import Engine.IGameObject;
import Engine.Pos2D;
import Engine.Vec2D;
import Experimental.CollisionBalls.CollisionBallsGameObject;
import Experimental.CollisionBalls.CollisionBallsKt;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016R\u0014\u0010\t\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\u000fR \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"LExperimental/CollisionBalls/CollisionBallsGameScene;", "LEngine/GameScene;", "color", "Ljava/awt/Color;", "width", "", "height", "<init>", "(Ljava/awt/Color;II)V", "interval", "getInterval", "()I", "counter", "getCounter", "setCounter", "(I)V", "ballsToCreate", "getBallsToCreate", "setBallsToCreate", "balls", "", "LExperimental/CollisionBalls/CollisionBallsGameObject;", "getBalls", "()Ljava/util/List;", "setBalls", "(Ljava/util/List;)V", "update", "", "load", "keyPressed", "e", "Ljava/awt/event/KeyEvent;", "keyReleased", "keyTyped", "add", "gameObject", "LEngine/IGameObject;", "remove", "TankWarsKotlin"})
public final class CollisionBallsGameScene
extends GameScene {
    private final int interval;
    private int counter;
    private int ballsToCreate;
    @NotNull
    private List<CollisionBallsGameObject> balls;

    public CollisionBallsGameScene(@NotNull Color color, int width, int height) {
        Intrinsics.checkNotNullParameter(color, "color");
        super(color, width, height);
        this.interval = 300;
        this.counter = 30;
        this.ballsToCreate = 30;
        this.balls = new ArrayList();
    }

    public final int getInterval() {
        return this.interval;
    }

    public final int getCounter() {
        return this.counter;
    }

    public final void setCounter(int n) {
        this.counter = n;
    }

    public final int getBallsToCreate() {
        return this.ballsToCreate;
    }

    public final void setBallsToCreate(int n) {
        this.ballsToCreate = n;
    }

    @NotNull
    public final List<CollisionBallsGameObject> getBalls() {
        return this.balls;
    }

    public final void setBalls(@NotNull List<CollisionBallsGameObject> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.balls = list;
    }

    @Override
    public void update() {
        super.update();
        --this.counter;
        if (this.counter == 0) {
            this.counter = this.interval;
            if (this.ballsToCreate > 0) {
                this.add(new CollisionBallsGameObject(this, new Pos2D(CollisionBallsKt.getRandom().nextDouble(0.0, this.getWidth()), CollisionBallsKt.getRandom().nextDouble(0.0, this.getHeight())), new Vec2D(CollisionBallsKt.getRandom().nextDouble() * (double)2, CollisionBallsKt.getRandom().nextDouble() * (double)2), CollisionBallsKt.getRandom().nextDouble(10.0, 30.0), new Color(CollisionBallsKt.getRandom().nextInt(255), CollisionBallsKt.getRandom().nextInt(255), CollisionBallsKt.getRandom().nextInt(255))));
                --this.ballsToCreate;
            }
        }
    }

    @Override
    public void load() {
    }

    @Override
    public void keyPressed(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
    }

    @Override
    public void keyReleased(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
    }

    @Override
    public void keyTyped(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
    }

    @Override
    public void add(@NotNull IGameObject gameObject) {
        Intrinsics.checkNotNullParameter(gameObject, "gameObject");
        super.add(gameObject);
        if (gameObject instanceof CollisionBallsGameObject) {
            this.balls.add((CollisionBallsGameObject)gameObject);
        }
    }

    @Override
    public void remove(@NotNull IGameObject gameObject) {
        Intrinsics.checkNotNullParameter(gameObject, "gameObject");
        super.remove(gameObject);
        TypeIntrinsics.asMutableCollection(this.balls).remove(gameObject);
    }
}

