/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import Engine.IGameScene;
import Engine.IGameWindow;
import Game.GameController;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 -2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001-B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u0018\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u0019\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u001a\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u001b\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u001c\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u001d\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u001e\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u001f\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010 \u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0016J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#J\u0014\u0010$\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J\u0006\u0010!\u001a\u00020\u0016J\u0006\u0010(\u001a\u00020\u0016J\u0006\u0010)\u001a\u00020\u0016J\u0006\u0010*\u001a\u00020\u0016J\b\u0010+\u001a\u00020\u0016H\u0002J\b\u0010,\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"LEngine/GameRunner;", "Ljava/awt/event/KeyListener;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "window", "LEngine/IGameWindow;", "gameScene", "LEngine/IGameScene;", "<init>", "(LEngine/IGameWindow;LEngine/IGameScene;)V", "keyEventQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/awt/event/KeyEvent;", "mouseEventQueue", "Ljava/awt/event/MouseEvent;", "value", "currentGameScene", "getCurrentGameScene", "()LEngine/IGameScene;", "setCurrentGameScene", "(LEngine/IGameScene;)V", "keyTyped", "", "e", "keyPressed", "keyReleased", "mouseClicked", "mousePressed", "mouseReleased", "mouseEntered", "mouseExited", "mouseDragged", "mouseMoved", "run", "numberOfIterations", "", "runUpdatesOnly", "whilePredicate", "Lkotlin/Function0;", "", "handleKeyEvents", "handleMouseEvents", "update", "renderBuffer", "renderScreen", "Companion", "TankWarsKotlin"})
@SourceDebugExtension(value={"SMAP\nGameWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameWindow.kt\nEngine/GameRunner\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,413:1\n18#2,4:414\n50#2,6:418\n18#2,4:424\n50#2,7:428\n18#2,4:435\n50#2,7:439\n18#2,4:446\n50#2,7:450\n56#2:457\n*S KotlinDebug\n*F\n+ 1 GameWindow.kt\nEngine/GameRunner\n*L\n255#1:414,4\n255#1:418,6\n256#1:424,4\n256#1:428,7\n263#1:435,4\n263#1:439,7\n266#1:446,4\n266#1:450,7\n255#1:457\n*E\n"})
public final class GameRunner
implements KeyListener,
MouseListener,
MouseMotionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IGameWindow window;
    @NotNull
    private final IGameScene gameScene;
    @NotNull
    private final ConcurrentLinkedQueue<KeyEvent> keyEventQueue;
    @NotNull
    private final ConcurrentLinkedQueue<MouseEvent> mouseEventQueue;
    @NotNull
    private IGameScene currentGameScene;
    private static final boolean debug = true;
    private static boolean exitGame;
    private static double fps;
    private static double tick;

    public GameRunner(@NotNull IGameWindow window, @NotNull IGameScene gameScene) {
        Intrinsics.checkNotNullParameter(window, "window");
        Intrinsics.checkNotNullParameter(gameScene, "gameScene");
        this.window = window;
        this.gameScene = gameScene;
        this.keyEventQueue = new ConcurrentLinkedQueue();
        this.mouseEventQueue = new ConcurrentLinkedQueue();
        this.currentGameScene = this.gameScene;
    }

    @NotNull
    public final IGameScene getCurrentGameScene() {
        return this.currentGameScene;
    }

    public final void setCurrentGameScene(@NotNull IGameScene value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.getCurrentGameScene().unload();
        this.window.onGameSceneChanged(this.getCurrentGameScene(), value);
        this.currentGameScene = value;
        this.currentGameScene.load();
    }

    @Override
    public void keyTyped(@Nullable KeyEvent e) {
        this.keyEventQueue.add(e);
    }

    @Override
    public void keyPressed(@Nullable KeyEvent e) {
        this.keyEventQueue.add(e);
    }

    @Override
    public void keyReleased(@Nullable KeyEvent e) {
        this.keyEventQueue.add(e);
    }

    @Override
    public void mouseClicked(@Nullable MouseEvent e) {
        this.mouseEventQueue.add(e);
    }

    @Override
    public void mousePressed(@Nullable MouseEvent e) {
        this.mouseEventQueue.add(e);
    }

    @Override
    public void mouseReleased(@Nullable MouseEvent e) {
        this.mouseEventQueue.add(e);
    }

    @Override
    public void mouseEntered(@Nullable MouseEvent e) {
        this.mouseEventQueue.add(e);
    }

    @Override
    public void mouseExited(@Nullable MouseEvent e) {
        this.mouseEventQueue.add(e);
    }

    @Override
    public void mouseDragged(@Nullable MouseEvent e) {
        this.mouseEventQueue.add(e);
    }

    @Override
    public void mouseMoved(@Nullable MouseEvent e) {
        this.mouseEventQueue.add(e);
    }

    public final void run(int numberOfIterations) {
        for (int i = 1; i <= numberOfIterations && !exitGame; ++i) {
            this.update();
            this.renderBuffer();
            this.renderScreen();
        }
    }

    public final void runUpdatesOnly(@NotNull Function0<Boolean> whilePredicate) {
        Intrinsics.checkNotNullParameter(whilePredicate, "whilePredicate");
        do {
            this.update();
        } while (whilePredicate.invoke().booleanValue());
    }

    public final void run() {
        long period = DurationKt.toDuration(1.0 / fps, DurationUnit.SECONDS);
        int maxSkips = 5;
        long timeTaken = 0L;
        block0: while (!exitGame) {
            int updatesPerDraw = 0;
            updatesPerDraw = 1;
            timeTaken = DurationKt.toDuration(0, DurationUnit.SECONDS);
            while (updatesPerDraw < maxSkips) {
                boolean $i$f$measureTime = false;
                TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
                boolean $i$f$measureTime2 = false;
                long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
                long l = timeTaken;
                boolean bl = false;
                boolean $i$f$measureTime3 = false;
                TimeSource.Monotonic $this$measureTime$iv$iv2 = TimeSource.Monotonic.INSTANCE;
                boolean $i$f$measureTime4 = false;
                long mark$iv$iv2 = $this$measureTime$iv$iv2.markNow-z9LOYto();
                boolean bl2 = false;
                this.update();
                long updateTime = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(mark$iv$iv2);
                GameController.INSTANCE.setUpdateTime(Duration.getInWholeMilliseconds-impl(updateTime));
                this.handleKeyEvents();
                this.handleMouseEvents();
                if (updatesPerDraw == 1) {
                    $i$f$measureTime4 = false;
                    TimeSource.Monotonic $this$measureTime$iv$iv3 = TimeSource.Monotonic.INSTANCE;
                    boolean $i$f$measureTime5 = false;
                    long mark$iv$iv3 = $this$measureTime$iv$iv3.markNow-z9LOYto();
                    boolean bl3 = false;
                    this.renderBuffer();
                    long renderBufferTime = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(mark$iv$iv3);
                    $i$f$measureTime5 = false;
                    TimeSource.Monotonic $this$measureTime$iv$iv4 = TimeSource.Monotonic.INSTANCE;
                    boolean $i$f$measureTime6 = false;
                    long mark$iv$iv4 = $this$measureTime$iv$iv4.markNow-z9LOYto();
                    boolean bl4 = false;
                    this.renderScreen();
                    long renderScreenTime = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(mark$iv$iv4);
                    GameController.INSTANCE.setRenderBufferTime(Duration.getInWholeMilliseconds-impl(renderBufferTime));
                    GameController.INSTANCE.setRenderScreenTime(Duration.getInWholeMilliseconds-impl(renderScreenTime));
                }
                Unit unit = Unit.INSTANCE;
                timeTaken = Duration.plus-LRDsOJo(l, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(mark$iv$iv));
                int n = updatesPerDraw++;
                if (Duration.compareTo-LRDsOJo(timeTaken, Duration.times-UwyO8pc(period, n)) >= 0) continue;
                n = updatesPerDraw;
                Thread.sleep(Duration.getInWholeMilliseconds-impl(Duration.minus-LRDsOJo(Duration.times-UwyO8pc(period, n), timeTaken)));
                continue block0;
            }
        }
    }

    public final void handleKeyEvents() {
        KeyEvent keyEvent = this.keyEventQueue.poll();
        while (keyEvent != null) {
            switch (keyEvent.getID()) {
                case 401: {
                    this.getCurrentGameScene().keyPressed(keyEvent);
                    break;
                }
                case 400: {
                    this.getCurrentGameScene().keyTyped(keyEvent);
                    break;
                }
                case 402: {
                    this.getCurrentGameScene().keyReleased(keyEvent);
                }
            }
            keyEvent = this.keyEventQueue.poll();
        }
    }

    public final void handleMouseEvents() {
        MouseEvent mouseEvent = this.mouseEventQueue.poll();
        while (mouseEvent != null) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.getCurrentGameScene().mousePressed(mouseEvent);
                    break;
                }
                case 503: {
                    this.getCurrentGameScene().mouseMoved(mouseEvent);
                    break;
                }
                case 500: {
                    this.getCurrentGameScene().mouseClicked(mouseEvent);
                    break;
                }
                case 502: {
                    this.getCurrentGameScene().mouseReleased(mouseEvent);
                    break;
                }
                case 504: {
                    this.getCurrentGameScene().mouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this.getCurrentGameScene().mouseExited(mouseEvent);
                    break;
                }
                case 507: {
                    this.getCurrentGameScene().mouseWheel(mouseEvent);
                }
            }
            mouseEvent = this.mouseEventQueue.poll();
        }
    }

    public final void update() {
        this.getCurrentGameScene().update();
    }

    private final void renderBuffer() {
        Graphics2D g = this.window.getGraphics2D();
        this.getCurrentGameScene().draw(g);
        g.dispose();
    }

    private final void renderScreen() {
        this.window.render(this.getCurrentGameScene().getWidth(), this.getCurrentGameScene().getHeight());
    }

    static {
        fps = 60.0;
        tick = 1.0 / fps;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0015"}, d2={"LEngine/GameRunner$Companion;", "", "<init>", "()V", "debug", "", "getDebug", "()Z", "exitGame", "getExitGame", "setExitGame", "(Z)V", "fps", "", "getFps", "()D", "setFps", "(D)V", "tick", "getTick", "setTick", "TankWarsKotlin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getDebug() {
            return debug;
        }

        public final boolean getExitGame() {
            return exitGame;
        }

        public final void setExitGame(boolean bl) {
            exitGame = bl;
        }

        public final double getFps() {
            return fps;
        }

        public final void setFps(double d) {
            fps = d;
        }

        public final double getTick() {
            return tick;
        }

        public final void setTick(double d) {
            tick = d;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

