/*
 * Decompiled with CFR 0.152.
 */
package Engine;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0006J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"LEngine/AudioClipPlayer;", "", "<init>", "()V", "audioInputStreamMap", "", "", "Ljavax/sound/sampled/AudioInputStream;", "clipMap", "Ljavax/sound/sampled/Clip;", "loadSound", "", "path", "Ljava/net/URL;", "name", "playSound", "stopSound", "loopSound", "times", "", "unload", "TankWarsKotlin"})
public final class AudioClipPlayer {
    @NotNull
    private Map<String, AudioInputStream> audioInputStreamMap = new LinkedHashMap();
    @NotNull
    private Map<String, Clip> clipMap = new LinkedHashMap();

    public final void loadSound(@NotNull URL path, @NotNull String name) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.clipMap.containsKey(name)) {
            return;
        }
        AudioInputStream audioStream = AudioSystem.getAudioInputStream(path);
        Clip audioClip = AudioSystem.getClip();
        audioClip.open(audioStream);
        this.audioInputStreamMap.put(name, audioStream);
        this.clipMap.put(name, audioClip);
    }

    public final void playSound(@NotNull String name) {
        block2: {
            Intrinsics.checkNotNullParameter(name, "name");
            Clip clip = this.clipMap.get(name);
            if (clip == null) break block2;
            Clip clip2 = clip;
            boolean bl = false;
            if (clip2.isRunning()) {
                clip2.stop();
                clip2.flush();
            }
            clip2.setFramePosition(0);
            while (!clip2.isRunning()) {
                clip2.start();
            }
        }
    }

    public final void stopSound(@NotNull String name) {
        block1: {
            Intrinsics.checkNotNullParameter(name, "name");
            Clip clip = this.clipMap.get(name);
            if (clip == null) break block1;
            Clip clip2 = clip;
            boolean bl = false;
            while (clip2.isRunning()) {
                clip2.stop();
                clip2.flush();
                clip2.setFramePosition(0);
            }
        }
    }

    public final void loopSound(@NotNull String name, int times) {
        block0: {
            Intrinsics.checkNotNullParameter(name, "name");
            Clip clip = this.clipMap.get(name);
            if (clip == null) break block0;
            clip.loop(times);
        }
    }

    public static /* synthetic */ void loopSound$default(AudioClipPlayer audioClipPlayer, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        audioClipPlayer.loopSound(string, n);
    }

    public final void unload() {
        for (Map.Entry<String, Clip> entry : this.clipMap.entrySet()) {
            entry.getValue().close();
        }
        for (Map.Entry<String, AutoCloseable> entry : this.audioInputStreamMap.entrySet()) {
            ((AudioInputStream)entry.getValue()).close();
        }
    }
}

